/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.internal.properties.tabbed;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator;

public final class StoerfallIndikatorDecoratorPropertySection
		extends ZustandsfarbenDecoratorPropertySection<StoerfallIndikatorDecorator> {

	@Override
	public void createControls(final Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		Text vorgaengerText = createDatenstatusColor("Störung:",
				DobjDecoratorPackage.Literals.STOERFALL_INDIKATOR_DECORATOR__STOERUNG_FARBE, container, null);

		vorgaengerText = createDatenstatusColor("Keine Aussage:",
				DobjDecoratorPackage.Literals.STOERFALL_INDIKATOR_DECORATOR__KEINE_AUSSAGE_FARBE, container,
				vorgaengerText);

		vorgaengerText = createDatenstatusColor("Freier Verkehr:",
				DobjDecoratorPackage.Literals.STOERFALL_INDIKATOR_DECORATOR__FREIER_VERKEHR_FARBE, container,
				vorgaengerText);

		vorgaengerText = createDatenstatusColor("Lebhafter Verkehr:",
				DobjDecoratorPackage.Literals.STOERFALL_INDIKATOR_DECORATOR__LEBHAFTER_VERKEHR_FARBE, container,
				vorgaengerText);

		vorgaengerText = createDatenstatusColor("Dichter Verkehr:",
				DobjDecoratorPackage.Literals.STOERFALL_INDIKATOR_DECORATOR__DICHTER_VERKEHR_FARBE, container,
				vorgaengerText);

		vorgaengerText = createDatenstatusColor("Zähfließender Verkehr:",
				DobjDecoratorPackage.Literals.STOERFALL_INDIKATOR_DECORATOR__ZAEHFLIESSENDER_VERKEHR_FARBE, container,
				vorgaengerText);

		vorgaengerText = createDatenstatusColor("Stockender Verkehr:",
				DobjDecoratorPackage.Literals.STOERFALL_INDIKATOR_DECORATOR__STOCKENDER_VERKEHR_FARBE, container,
				vorgaengerText);

		createDatenstatusColor("Stau:", DobjDecoratorPackage.Literals.STOERFALL_INDIKATOR_DECORATOR__STAU_FARBE,
				container, vorgaengerText);
	}

}
