/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.internal.properties.tabbed;

import static org.eclipse.swt.SWT.BORDER;
import static org.eclipse.swt.SWT.CENTER;
import static org.eclipse.swt.SWT.CHECK;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.HSPACE;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.UnsetCommand;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.TransparenzDecorator;
import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;

/**
 * @author BitCtrl Systems GmbH 2012, Christian Hösel
 */
public class TransparenzDekoriererPropertySection extends AbstractSection<TransparenzDecorator> {

	private Label transparenzLabel;
	private Spinner transparenzSpinner;
	private Button transparenzUseDefault;

	@Override
	public void createControls(final Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createTransparenz(container);
	}

	private void createTransparenz(final Composite parent) {

		// Widgets anlegen

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		transparenzLabel = factory.createLabel(parent, "Transparenz:");
		transparenzSpinner = new Spinner(parent, BORDER);
		transparenzSpinner.setMinimum(0);
		transparenzSpinner.setMaximum(255);
		transparenzSpinner.setDigits(0);
		transparenzSpinner.setIncrement(10);
		transparenzSpinner.setPageIncrement(100);
		factory.adapt(parent);
		transparenzUseDefault = factory.createButton(parent, "Defaultwert verwenden", CHECK);

		// Widgets layouten

		final FormData spinnerData = new FormData();
		spinnerData.left = new FormAttachment(transparenzLabel, HSPACE);
		spinnerData.width = 150;
		spinnerData.top = new FormAttachment(0, 0);
		transparenzSpinner.setLayoutData(spinnerData);
		final FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(transparenzSpinner, 0, CENTER);
		transparenzLabel.setLayoutData(labelData);
		final FormData useDefaultData = new FormData();
		useDefaultData.left = new FormAttachment(transparenzSpinner, 0, HSPACE);
		useDefaultData.top = new FormAttachment(transparenzSpinner, 0, CENTER);
		transparenzUseDefault.setLayoutData(useDefaultData);

		// Listener anmelden

		transparenzSpinner.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final int value = transparenzSpinner.getSelection();
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.TRANSPARENZ_DECORATOR__TRANSPARENZ, value);
				getCommandStack().execute(cmd);
			}

		});
		transparenzUseDefault.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				if (transparenzUseDefault.getSelection()) {
					final UnsetCommand cmd = new UnsetCommand(getElement(),
							DobjDecoratorPackage.Literals.TRANSPARENZ_DECORATOR__TRANSPARENZ);
					getCommandStack().execute(cmd);
				} else {
					final int value = getElement().getTransparenz();
					final SetCommand cmd = new SetCommand(getElement(),
							DobjDecoratorPackage.Literals.TRANSPARENZ_DECORATOR__TRANSPARENZ, value);
					getCommandStack().execute(cmd);
				}
			}

		});
	}

	@Override
	public void refresh() {
		setTransparenzToWidget();
		disableTransparenzIfNecessary();
	}

	private void setTransparenzToWidget() {
		final int transparenz = getElement().getTransparenz();

		final boolean isChanged = transparenzSpinner.getSelection() != transparenz;
		if (isChanged) {
			transparenzSpinner.setSelection(transparenz);
		}
	}

	private void disableTransparenzIfNecessary() {
		final boolean isDoKomponente = getElement().eContainer() instanceof DoKomponente;
		final boolean useDefault = !getElement().isSetTransparenz();

		transparenzUseDefault.setSelection(useDefault);

		final boolean enabled = !isDoKomponente && !useDefault;
		transparenzSpinner.setEnabled(enabled);
		transparenzLabel.setEnabled(enabled);
		transparenzUseDefault.setEnabled(!isDoKomponente);
	}

}
