/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.internal.properties.tabbed;

import static org.eclipse.swt.SWT.CENTER;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.HSPACE;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;

public class ZoomVerhaltenFixDecoratorPropertySection extends AbstractSection<ZoomVerhaltenFixDecorator> {

	private Label zoomVerhaltenFixLabel;
	private Button btnZoomVerhalten;

	@Override
	public void createControls(final Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createSkalierung(container);
	}

	private void createSkalierung(final Composite parent) {

		// Widgets anlegen

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		zoomVerhaltenFixLabel = factory.createLabel(parent, "Zoom Fix:");
		btnZoomVerhalten = new Button(parent, SWT.CHECK);
		btnZoomVerhalten.setText("");

		factory.adapt(parent);

		// Widgets layouten

		final FormData spinnerData = new FormData();
		spinnerData.left = new FormAttachment(zoomVerhaltenFixLabel, HSPACE);
		spinnerData.top = new FormAttachment(0, 0);
		btnZoomVerhalten.setLayoutData(spinnerData);
		final FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(btnZoomVerhalten, 0, CENTER);
		zoomVerhaltenFixLabel.setLayoutData(labelData);

		// Listener anmelden

		btnZoomVerhalten.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final boolean value = btnZoomVerhalten.getSelection();
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.ZOOM_VERHALTEN_FIX_DECORATOR__ZOOM_VERHALTEN_FIX, value);
				getCommandStack().execute(cmd);
			}

		});
	}

	@Override
	public void refresh() {
		setZoomVerhaltenFixToWidget();
	}

	private void setZoomVerhaltenFixToWidget() {
		final boolean zoomVerhaltenFix = getElement().isZoomVerhaltenFix();
		final boolean isChanged = btnZoomVerhalten.getSelection() != zoomVerhaltenFix;
		if (isChanged) {
			btnZoomVerhalten.setSelection(zoomVerhaltenFix);
		}
	}

}
