/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.legende;

import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.legende.DoLegendeBaustein;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;

/**
 * Verwendet die parametrierte Vorder- und Hintergrundfarbe beim Zeichnen des
 * Legendenbausteins.
 *
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class FarbeDoLegendeBaustein extends DoLegendeBaustein {

	private Color foregroundColor;
	private Color backgroundColor;

	/**
	 * Liest die Farben aus dem {@link DoTyp} und setzt sie an der Figure.
	 */
	public FarbeDoLegendeBaustein(final DoTyp doTyp, final IFigure figure) {
		super(doTyp, figure);

		final Display display = PlatformUI.getWorkbench().getDisplay();
		handleVordergrundfarbeDecorator(display);
		handleHintergrundfarbeDecorator(display);
	}

	private void handleVordergrundfarbeDecorator(final Display display) {
		if (getDoTyp() instanceof VordergrundfarbeDecorator) {
			final VordergrundfarbeDecorator decorator = (VordergrundfarbeDecorator) getDoTyp();
			final RGB rgb = decorator.getVordergrundfarbe();
			foregroundColor = new Color(display, rgb);
			getFigure().setForegroundColor(foregroundColor);
		}
	}

	private void handleHintergrundfarbeDecorator(final Display display) {
		if (getDoTyp() instanceof HintergrundfarbeDecorator) {
			final HintergrundfarbeDecorator decorator = (HintergrundfarbeDecorator) getDoTyp();
			final RGB rgb = decorator.getHintergrundfarbe();
			backgroundColor = new Color(display, rgb);
			getFigure().setBackgroundColor(backgroundColor);
		}
	}

	@Override
	public void dispose() {
		if (foregroundColor != null) {
			foregroundColor.dispose();
		}
		if (backgroundColor != null) {
			backgroundColor.dispose();
		}
		super.dispose();
	}

}
