/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc --> A representation of the literals of the enumeration
 * '<em><b>Line Style</b></em>', and utility methods for working with them. <!--
 * end-user-doc -->
 * 
 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage#getLinienStyle()
 * @model
 * @generated
 */
public enum LinienStyle implements Enumerator {
	/**
	 * The '<em><b>Durchgezogen</b></em>' literal object. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #DURCHGEZOGEN_VALUE
	 * @generated
	 * @ordered
	 */
	DURCHGEZOGEN(0, "Durchgezogen", "Durchgezogen"),

	/**
	 * The '<em><b>Strich</b></em>' literal object. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #STRICH_VALUE
	 * @generated
	 * @ordered
	 */
	STRICH(1, "Strich", "Strich"),

	/**
	 * The '<em><b>Strich Punkt</b></em>' literal object. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #STRICH_PUNKT_VALUE
	 * @generated
	 * @ordered
	 */
	STRICH_PUNKT(2, "StrichPunkt", "StrichPunkt"),

	/**
	 * The '<em><b>Strich Punkt Punkt</b></em>' literal object. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #STRICH_PUNKT_PUNKT_VALUE
	 * @generated
	 * @ordered
	 */
	STRICH_PUNKT_PUNKT(3, "StrichPunktPunkt", "StrichPunktPunkt"),

	/**
	 * The '<em><b>Punkt</b></em>' literal object. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #PUNKT_VALUE
	 * @generated
	 * @ordered
	 */
	PUNKT(4, "Punkt", "Punkt");

	/**
	 * The '<em><b>Durchgezogen</b></em>' literal value. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Durchgezogen</b></em>' literal object isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #DURCHGEZOGEN
	 * @model name="Durchgezogen"
	 * @generated
	 * @ordered
	 */
	public static final int DURCHGEZOGEN_VALUE = 0;

	/**
	 * The '<em><b>Strich</b></em>' literal value. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Strich</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #STRICH
	 * @model name="Strich"
	 * @generated
	 * @ordered
	 */
	public static final int STRICH_VALUE = 1;

	/**
	 * The '<em><b>Strich Punkt</b></em>' literal value. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Strich Punkt</b></em>' literal object isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #STRICH_PUNKT
	 * @model name="StrichPunkt"
	 * @generated
	 * @ordered
	 */
	public static final int STRICH_PUNKT_VALUE = 2;

	/**
	 * The '<em><b>Strich Punkt Punkt</b></em>' literal value. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Strich Punkt Punkt</b></em>' literal object
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 *
	 * @see #STRICH_PUNKT_PUNKT
	 * @model name="StrichPunktPunkt"
	 * @generated
	 * @ordered
	 */
	public static final int STRICH_PUNKT_PUNKT_VALUE = 3;

	/**
	 * The '<em><b>Punkt</b></em>' literal value. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Punkt</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #PUNKT
	 * @model name="Punkt"
	 * @generated
	 * @ordered
	 */
	public static final int PUNKT_VALUE = 4;

	/**
	 * An array of all the '<em><b>Linien Style</b></em>' enumerators. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private static final LinienStyle[] VALUES_ARRAY = new LinienStyle[] { DURCHGEZOGEN, STRICH, STRICH_PUNKT,
			STRICH_PUNKT_PUNKT, PUNKT, };

	/**
	 * A public read-only list of all the '<em><b>Linien Style</b></em>'
	 * enumerators. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public static final List<LinienStyle> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Linien Style</b></em>' literal with the specified
	 * literal value. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param literal
	 *            the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static LinienStyle get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			final LinienStyle result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Linien Style</b></em>' literal with the specified
	 * name. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param name
	 *            the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static LinienStyle getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			final LinienStyle result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Linien Style</b></em>' literal with the specified
	 * integer value. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static LinienStyle get(int value) {
		switch (value) {
		case DURCHGEZOGEN_VALUE:
			return DURCHGEZOGEN;
		case STRICH_VALUE:
			return STRICH;
		case STRICH_PUNKT_VALUE:
			return STRICH_PUNKT;
		case STRICH_PUNKT_PUNKT_VALUE:
			return STRICH_PUNKT_PUNKT;
		case PUNKT_VALUE:
			return PUNKT;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	private LinienStyle(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getLiteral() {
		return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string
	 * representation. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}

} // LinienStyle
