/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc --> A representation of the literals of the enumeration
 * '<em><b>Zoomverhalten</b></em>', and utility methods for working with them.
 * <!-- end-user-doc -->
 * 
 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage#getZoomverhalten()
 * @model
 * @generated
 */
public enum Zoomverhalten implements Enumerator {
	/**
	 * The '<em><b>Statisches Zoomverhalten</b></em>' literal object. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #STATISCHES_ZOOMVERHALTEN_VALUE
	 * @generated
	 * @ordered
	 */
	STATISCHES_ZOOMVERHALTEN(0, "statischesZoomverhalten", "statisches Zoomverhalten"),

	/**
	 * The '<em><b>Dynamisches Zoomverhalten</b></em>' literal object. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #DYNAMISCHES_ZOOMVERHALTEN_VALUE
	 * @generated
	 * @ordered
	 */
	DYNAMISCHES_ZOOMVERHALTEN(1, "dynamischesZoomverhalten", "dynamisches Zoomverhalten");

	/**
	 * The '<em><b>Statisches Zoomverhalten</b></em>' literal value. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #STATISCHES_ZOOMVERHALTEN
	 * @model name="statischesZoomverhalten" literal="statisches Zoomverhalten"
	 * @generated
	 * @ordered
	 */
	public static final int STATISCHES_ZOOMVERHALTEN_VALUE = 0;

	/**
	 * The '<em><b>Dynamisches Zoomverhalten</b></em>' literal value. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #DYNAMISCHES_ZOOMVERHALTEN
	 * @model name="dynamischesZoomverhalten" literal="dynamisches
	 *        Zoomverhalten"
	 * @generated
	 * @ordered
	 */
	public static final int DYNAMISCHES_ZOOMVERHALTEN_VALUE = 1;

	/**
	 * An array of all the '<em><b>Zoomverhalten</b></em>' enumerators. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private static final Zoomverhalten[] VALUES_ARRAY = new Zoomverhalten[] { STATISCHES_ZOOMVERHALTEN,
			DYNAMISCHES_ZOOMVERHALTEN, };

	/**
	 * A public read-only list of all the '<em><b>Zoomverhalten</b></em>'
	 * enumerators. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public static final List<Zoomverhalten> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Zoomverhalten</b></em>' literal with the specified
	 * literal value. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param literal
	 *            the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static Zoomverhalten get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			final Zoomverhalten result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Zoomverhalten</b></em>' literal with the specified
	 * name. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param name
	 *            the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static Zoomverhalten getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			final Zoomverhalten result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Zoomverhalten</b></em>' literal with the specified
	 * integer value. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static Zoomverhalten get(int value) {
		switch (value) {
		case STATISCHES_ZOOMVERHALTEN_VALUE:
			return STATISCHES_ZOOMVERHALTEN;
		case DYNAMISCHES_ZOOMVERHALTEN_VALUE:
			return DYNAMISCHES_ZOOMVERHALTEN;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	private Zoomverhalten(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getLiteral() {
		return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string
	 * representation. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}

} // Zoomverhalten
