/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.model.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipsePackage;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;

import de.bsvrz.buv.plugin.dobj.decorator.model.AntikollisionsalgorithmusDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorFactory;
import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.GroesseDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyle;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyleDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.MinMaxZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.TransparenzDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Package</b>. <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class DobjDecoratorPackageImpl extends EPackageImpl implements DobjDecoratorPackage {
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass linienabstandDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass skalierungDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass drehungDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass datenstatusDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass linienstaerkeDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass vordergrundfarbeDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass hintergrundfarbeDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass schriftDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass stoerfallIndikatorDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass antikollisionsalgorithmusDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass transparenzDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass linienStyleDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass zoomVerhaltenFixDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass minMaxZoomDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass selektierbarDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass groesseDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass linienstaerkeZoomDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass linienabstandZoomDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EEnum linienStyleEEnum = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EEnum zoomverhaltenEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the
	 * package package URI value.
	 * <p>
	 * Note: the correct way to create the package is via the static factory
	 * method {@link #init init()}, which also performs initialization of the
	 * package, or returns the registered package, if one already exists. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private DobjDecoratorPackageImpl() {
		super(eNS_URI, DobjDecoratorFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model,
	 * and for any others upon which it depends.
	 *
	 * <p>
	 * This method is used to initialize {@link DobjDecoratorPackage#eINSTANCE}
	 * when that field is accessed. Clients should not invoke it directly.
	 * Instead, they should simply access that field to obtain the package. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static DobjDecoratorPackage init() {
		if (isInited) {
			return (DobjDecoratorPackage) EPackage.Registry.INSTANCE.getEPackage(DobjDecoratorPackage.eNS_URI);
		}

		// Obtain or create and register package
		final Object registeredDobjDecoratorPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		final DobjDecoratorPackageImpl theDobjDecoratorPackage = registeredDobjDecoratorPackage instanceof DobjDecoratorPackageImpl
				? (DobjDecoratorPackageImpl) registeredDobjDecoratorPackage
				: new DobjDecoratorPackageImpl();

		isInited = true;

		// Initialize simple dependencies
		EclipsePackage.eINSTANCE.eClass();
		GefPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theDobjDecoratorPackage.createPackageContents();

		// Initialize created meta-data
		theDobjDecoratorPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theDobjDecoratorPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(DobjDecoratorPackage.eNS_URI, theDobjDecoratorPackage);
		return theDobjDecoratorPackage;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getLinienabstandDecorator() {
		return linienabstandDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getLinienabstandDecorator_Linienabstand() {
		return (EAttribute) linienabstandDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getSkalierungDecorator() {
		return skalierungDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getSkalierungDecorator_Skalierungsfaktor() {
		return (EAttribute) skalierungDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getDrehungDecorator() {
		return drehungDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getDrehungDecorator_Drehwinkel() {
		return (EAttribute) drehungDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getDatenstatusDecorator() {
		return datenstatusDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getDatenstatusDecorator_KeineQuelleFarbe() {
		return (EAttribute) datenstatusDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getDatenstatusDecorator_KeineDatenFarbe() {
		return (EAttribute) datenstatusDecoratorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getDatenstatusDecorator_NutzdatenFarbe() {
		return (EAttribute) datenstatusDecoratorEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getLinienstaerkeDecorator() {
		return linienstaerkeDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getLinienstaerkeDecorator_Linienstaerke() {
		return (EAttribute) linienstaerkeDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getVordergrundfarbeDecorator() {
		return vordergrundfarbeDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getVordergrundfarbeDecorator_Vordergrundfarbe() {
		return (EAttribute) vordergrundfarbeDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getHintergrundfarbeDecorator() {
		return hintergrundfarbeDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getHintergrundfarbeDecorator_Hintergrundfarbe() {
		return (EAttribute) hintergrundfarbeDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getSchriftDecorator() {
		return schriftDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getSchriftDecorator_Schrift() {
		return (EAttribute) schriftDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getStoerfallIndikatorDecorator() {
		return stoerfallIndikatorDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStoerfallIndikatorDecorator_StoerungFarbe() {
		return (EAttribute) stoerfallIndikatorDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStoerfallIndikatorDecorator_KeineAussageFarbe() {
		return (EAttribute) stoerfallIndikatorDecoratorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStoerfallIndikatorDecorator_FreierVerkehrFarbe() {
		return (EAttribute) stoerfallIndikatorDecoratorEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStoerfallIndikatorDecorator_LebhafterVerkehrFarbe() {
		return (EAttribute) stoerfallIndikatorDecoratorEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStoerfallIndikatorDecorator_DichterVerkehrFarbe() {
		return (EAttribute) stoerfallIndikatorDecoratorEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStoerfallIndikatorDecorator_ZaehfliessenderVerkehrFarbe() {
		return (EAttribute) stoerfallIndikatorDecoratorEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStoerfallIndikatorDecorator_StockenderVerkehrFarbe() {
		return (EAttribute) stoerfallIndikatorDecoratorEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStoerfallIndikatorDecorator_StauFarbe() {
		return (EAttribute) stoerfallIndikatorDecoratorEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getAntikollisionsalgorithmusDecorator() {
		return antikollisionsalgorithmusDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getAntikollisionsalgorithmusDecorator_AntikollisionsalgorithmusAnwenden() {
		return (EAttribute) antikollisionsalgorithmusDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getTransparenzDecorator() {
		return transparenzDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getTransparenzDecorator_Transparenz() {
		return (EAttribute) transparenzDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getLinienStyleDecorator() {
		return linienStyleDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getLinienStyleDecorator_Style() {
		return (EAttribute) linienStyleDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getZoomVerhaltenFixDecorator() {
		return zoomVerhaltenFixDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getZoomVerhaltenFixDecorator_ZoomVerhaltenFix() {
		return (EAttribute) zoomVerhaltenFixDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getMinMaxZoomDecorator() {
		return minMaxZoomDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getMinMaxZoomDecorator_MinimaleZoomstufe() {
		return (EAttribute) minMaxZoomDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getMinMaxZoomDecorator_MaximaleZoomstufe() {
		return (EAttribute) minMaxZoomDecoratorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getSelektierbarDecorator() {
		return selektierbarDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getSelektierbarDecorator_Selektierbar() {
		return (EAttribute) selektierbarDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getGroesseDecorator() {
		return groesseDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getGroesseDecorator_Groesse() {
		return (EAttribute) groesseDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getLinienstaerkeZoomDecorator() {
		return linienstaerkeZoomDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getLinienstaerkeZoomDecorator_LinienstaerkeZoomverhalten() {
		return (EAttribute) linienstaerkeZoomDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getLinienstaerkeZoomDecorator_LinienstaerkeMinimaleZoomstufe() {
		return (EAttribute) linienstaerkeZoomDecoratorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getLinienstaerkeZoomDecorator_LinienstaerkeMaximaleZoomstufe() {
		return (EAttribute) linienstaerkeZoomDecoratorEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getLinienstaerkeZoomDecorator_LinienstaerkeMaximum() {
		return (EAttribute) linienstaerkeZoomDecoratorEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getLinienstaerkeZoomDecorator_LinienstaerkeMinimum() {
		return (EAttribute) linienstaerkeZoomDecoratorEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getLinienstaerkeZoomDecorator_Linienstaerke() {
		return (EAttribute) linienstaerkeZoomDecoratorEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getLinienabstandZoomDecorator() {
		return linienabstandZoomDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getLinienabstandZoomDecorator_LinienabstandZoomverhalten() {
		return (EAttribute) linienabstandZoomDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getLinienabstandZoomDecorator_LinienabstandMinimaleZoomstufe() {
		return (EAttribute) linienabstandZoomDecoratorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getLinienabstandZoomDecorator_LinienabstandMaximaleZoomstufe() {
		return (EAttribute) linienabstandZoomDecoratorEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getLinienabstandZoomDecorator_LinienabstandMaximum() {
		return (EAttribute) linienabstandZoomDecoratorEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getLinienabstandZoomDecorator_LinienabstandMinimum() {
		return (EAttribute) linienabstandZoomDecoratorEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getLinienabstandZoomDecorator_Linienabstand() {
		return (EAttribute) linienabstandZoomDecoratorEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EEnum getLinienStyle() {
		return linienStyleEEnum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EEnum getZoomverhalten() {
		return zoomverhaltenEEnum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public DobjDecoratorFactory getDobjDecoratorFactory() {
		return (DobjDecoratorFactory) getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package. This method is guarded to
	 * have no affect on any invocation but its first. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) {
			return;
		}
		isCreated = true;

		// Create classes and their features
		linienabstandDecoratorEClass = createEClass(LINIENABSTAND_DECORATOR);
		createEAttribute(linienabstandDecoratorEClass, LINIENABSTAND_DECORATOR__LINIENABSTAND);

		skalierungDecoratorEClass = createEClass(SKALIERUNG_DECORATOR);
		createEAttribute(skalierungDecoratorEClass, SKALIERUNG_DECORATOR__SKALIERUNGSFAKTOR);

		drehungDecoratorEClass = createEClass(DREHUNG_DECORATOR);
		createEAttribute(drehungDecoratorEClass, DREHUNG_DECORATOR__DREHWINKEL);

		datenstatusDecoratorEClass = createEClass(DATENSTATUS_DECORATOR);
		createEAttribute(datenstatusDecoratorEClass, DATENSTATUS_DECORATOR__KEINE_QUELLE_FARBE);
		createEAttribute(datenstatusDecoratorEClass, DATENSTATUS_DECORATOR__KEINE_DATEN_FARBE);
		createEAttribute(datenstatusDecoratorEClass, DATENSTATUS_DECORATOR__NUTZDATEN_FARBE);

		linienstaerkeDecoratorEClass = createEClass(LINIENSTAERKE_DECORATOR);
		createEAttribute(linienstaerkeDecoratorEClass, LINIENSTAERKE_DECORATOR__LINIENSTAERKE);

		vordergrundfarbeDecoratorEClass = createEClass(VORDERGRUNDFARBE_DECORATOR);
		createEAttribute(vordergrundfarbeDecoratorEClass, VORDERGRUNDFARBE_DECORATOR__VORDERGRUNDFARBE);

		hintergrundfarbeDecoratorEClass = createEClass(HINTERGRUNDFARBE_DECORATOR);
		createEAttribute(hintergrundfarbeDecoratorEClass, HINTERGRUNDFARBE_DECORATOR__HINTERGRUNDFARBE);

		schriftDecoratorEClass = createEClass(SCHRIFT_DECORATOR);
		createEAttribute(schriftDecoratorEClass, SCHRIFT_DECORATOR__SCHRIFT);

		stoerfallIndikatorDecoratorEClass = createEClass(STOERFALL_INDIKATOR_DECORATOR);
		createEAttribute(stoerfallIndikatorDecoratorEClass, STOERFALL_INDIKATOR_DECORATOR__STOERUNG_FARBE);
		createEAttribute(stoerfallIndikatorDecoratorEClass, STOERFALL_INDIKATOR_DECORATOR__KEINE_AUSSAGE_FARBE);
		createEAttribute(stoerfallIndikatorDecoratorEClass, STOERFALL_INDIKATOR_DECORATOR__FREIER_VERKEHR_FARBE);
		createEAttribute(stoerfallIndikatorDecoratorEClass, STOERFALL_INDIKATOR_DECORATOR__LEBHAFTER_VERKEHR_FARBE);
		createEAttribute(stoerfallIndikatorDecoratorEClass, STOERFALL_INDIKATOR_DECORATOR__DICHTER_VERKEHR_FARBE);
		createEAttribute(stoerfallIndikatorDecoratorEClass,
				STOERFALL_INDIKATOR_DECORATOR__ZAEHFLIESSENDER_VERKEHR_FARBE);
		createEAttribute(stoerfallIndikatorDecoratorEClass, STOERFALL_INDIKATOR_DECORATOR__STOCKENDER_VERKEHR_FARBE);
		createEAttribute(stoerfallIndikatorDecoratorEClass, STOERFALL_INDIKATOR_DECORATOR__STAU_FARBE);

		antikollisionsalgorithmusDecoratorEClass = createEClass(ANTIKOLLISIONSALGORITHMUS_DECORATOR);
		createEAttribute(antikollisionsalgorithmusDecoratorEClass,
				ANTIKOLLISIONSALGORITHMUS_DECORATOR__ANTIKOLLISIONSALGORITHMUS_ANWENDEN);

		transparenzDecoratorEClass = createEClass(TRANSPARENZ_DECORATOR);
		createEAttribute(transparenzDecoratorEClass, TRANSPARENZ_DECORATOR__TRANSPARENZ);

		linienStyleDecoratorEClass = createEClass(LINIEN_STYLE_DECORATOR);
		createEAttribute(linienStyleDecoratorEClass, LINIEN_STYLE_DECORATOR__STYLE);

		zoomVerhaltenFixDecoratorEClass = createEClass(ZOOM_VERHALTEN_FIX_DECORATOR);
		createEAttribute(zoomVerhaltenFixDecoratorEClass, ZOOM_VERHALTEN_FIX_DECORATOR__ZOOM_VERHALTEN_FIX);

		minMaxZoomDecoratorEClass = createEClass(MIN_MAX_ZOOM_DECORATOR);
		createEAttribute(minMaxZoomDecoratorEClass, MIN_MAX_ZOOM_DECORATOR__MINIMALE_ZOOMSTUFE);
		createEAttribute(minMaxZoomDecoratorEClass, MIN_MAX_ZOOM_DECORATOR__MAXIMALE_ZOOMSTUFE);

		selektierbarDecoratorEClass = createEClass(SELEKTIERBAR_DECORATOR);
		createEAttribute(selektierbarDecoratorEClass, SELEKTIERBAR_DECORATOR__SELEKTIERBAR);

		groesseDecoratorEClass = createEClass(GROESSE_DECORATOR);
		createEAttribute(groesseDecoratorEClass, GROESSE_DECORATOR__GROESSE);

		linienstaerkeZoomDecoratorEClass = createEClass(LINIENSTAERKE_ZOOM_DECORATOR);
		createEAttribute(linienstaerkeZoomDecoratorEClass, LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_ZOOMVERHALTEN);
		createEAttribute(linienstaerkeZoomDecoratorEClass,
				LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMALE_ZOOMSTUFE);
		createEAttribute(linienstaerkeZoomDecoratorEClass,
				LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE);
		createEAttribute(linienstaerkeZoomDecoratorEClass, LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMUM);
		createEAttribute(linienstaerkeZoomDecoratorEClass, LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMUM);
		createEAttribute(linienstaerkeZoomDecoratorEClass, LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE);

		linienabstandZoomDecoratorEClass = createEClass(LINIENABSTAND_ZOOM_DECORATOR);
		createEAttribute(linienabstandZoomDecoratorEClass, LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN);
		createEAttribute(linienabstandZoomDecoratorEClass,
				LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE);
		createEAttribute(linienabstandZoomDecoratorEClass,
				LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE);
		createEAttribute(linienabstandZoomDecoratorEClass, LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM);
		createEAttribute(linienabstandZoomDecoratorEClass, LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM);
		createEAttribute(linienabstandZoomDecoratorEClass, LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND);

		// Create enums
		linienStyleEEnum = createEEnum(LINIEN_STYLE);
		zoomverhaltenEEnum = createEEnum(ZOOMVERHALTEN);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model. This
	 * method is guarded to have no affect on any invocation but its first. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) {
			return;
		}
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		final EclipsePackage theEclipsePackage = (EclipsePackage) EPackage.Registry.INSTANCE
				.getEPackage(EclipsePackage.eNS_URI);
		final GefPackage theGefPackage = (GefPackage) EPackage.Registry.INSTANCE.getEPackage(GefPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes

		// Initialize classes and features; add operations and parameters
		initEClass(linienabstandDecoratorEClass, LinienabstandDecorator.class, "LinienabstandDecorator", IS_ABSTRACT,
				IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getLinienabstandDecorator_Linienabstand(), ecorePackage.getEInt(), "linienabstand", "0", 0, 1,
				LinienabstandDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(skalierungDecoratorEClass, SkalierungDecorator.class, "SkalierungDecorator", IS_ABSTRACT,
				IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getSkalierungDecorator_Skalierungsfaktor(), ecorePackage.getEDouble(), "skalierungsfaktor",
				"1.0", 0, 1, SkalierungDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(drehungDecoratorEClass, DrehungDecorator.class, "DrehungDecorator", IS_ABSTRACT, IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getDrehungDecorator_Drehwinkel(), ecorePackage.getEFloat(), "drehwinkel", "0.0f", 0, 1,
				DrehungDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(datenstatusDecoratorEClass, DatenstatusDecorator.class, "DatenstatusDecorator", IS_ABSTRACT,
				IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getDatenstatusDecorator_KeineQuelleFarbe(), theEclipsePackage.getRGB(), "keineQuelleFarbe",
				"128,128,128", 0, 1, DatenstatusDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDatenstatusDecorator_KeineDatenFarbe(), theEclipsePackage.getRGB(), "keineDatenFarbe",
				"255,0,0", 0, 1, DatenstatusDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDatenstatusDecorator_NutzdatenFarbe(), theEclipsePackage.getRGB(), "nutzdatenFarbe",
				"0,255,0", 0, 1, DatenstatusDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(linienstaerkeDecoratorEClass, LinienstaerkeDecorator.class, "LinienstaerkeDecorator", IS_ABSTRACT,
				IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getLinienstaerkeDecorator_Linienstaerke(), ecorePackage.getEInt(), "linienstaerke", "1", 0, 1,
				LinienstaerkeDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(vordergrundfarbeDecoratorEClass, VordergrundfarbeDecorator.class, "VordergrundfarbeDecorator",
				IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getVordergrundfarbeDecorator_Vordergrundfarbe(), theEclipsePackage.getRGB(), "vordergrundfarbe",
				"0,0,0", 0, 1, VordergrundfarbeDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(hintergrundfarbeDecoratorEClass, HintergrundfarbeDecorator.class, "HintergrundfarbeDecorator",
				IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getHintergrundfarbeDecorator_Hintergrundfarbe(), theEclipsePackage.getRGB(), "hintergrundfarbe",
				"255,255,255", 0, 1, HintergrundfarbeDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(schriftDecoratorEClass, SchriftDecorator.class, "SchriftDecorator", IS_ABSTRACT, IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getSchriftDecorator_Schrift(), theEclipsePackage.getFontData(), "schrift", null, 0, 1,
				SchriftDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(stoerfallIndikatorDecoratorEClass, StoerfallIndikatorDecorator.class, "StoerfallIndikatorDecorator",
				IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getStoerfallIndikatorDecorator_StoerungFarbe(), theEclipsePackage.getRGB(), "stoerungFarbe",
				"255,255,255", 0, 1, StoerfallIndikatorDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStoerfallIndikatorDecorator_KeineAussageFarbe(), theEclipsePackage.getRGB(),
				"keineAussageFarbe", "128,128,128", 0, 1, StoerfallIndikatorDecorator.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStoerfallIndikatorDecorator_FreierVerkehrFarbe(), theEclipsePackage.getRGB(),
				"freierVerkehrFarbe", "96,255,96", 0, 1, StoerfallIndikatorDecorator.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStoerfallIndikatorDecorator_LebhafterVerkehrFarbe(), theEclipsePackage.getRGB(),
				"lebhafterVerkehrFarbe", "0,127,0", 0, 1, StoerfallIndikatorDecorator.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStoerfallIndikatorDecorator_DichterVerkehrFarbe(), theEclipsePackage.getRGB(),
				"dichterVerkehrFarbe", "255,255,0", 0, 1, StoerfallIndikatorDecorator.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStoerfallIndikatorDecorator_ZaehfliessenderVerkehrFarbe(), theEclipsePackage.getRGB(),
				"zaehfliessenderVerkehrFarbe", "255,196,0", 0, 1, StoerfallIndikatorDecorator.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStoerfallIndikatorDecorator_StockenderVerkehrFarbe(), theEclipsePackage.getRGB(),
				"stockenderVerkehrFarbe", "255,100,100", 0, 1, StoerfallIndikatorDecorator.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStoerfallIndikatorDecorator_StauFarbe(), theEclipsePackage.getRGB(), "stauFarbe", "255,0,0",
				0, 1, StoerfallIndikatorDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(antikollisionsalgorithmusDecoratorEClass, AntikollisionsalgorithmusDecorator.class,
				"AntikollisionsalgorithmusDecorator", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getAntikollisionsalgorithmusDecorator_AntikollisionsalgorithmusAnwenden(),
				ecorePackage.getEBoolean(), "antikollisionsalgorithmusAnwenden", "true", 0, 1,
				AntikollisionsalgorithmusDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(transparenzDecoratorEClass, TransparenzDecorator.class, "TransparenzDecorator", IS_ABSTRACT,
				IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getTransparenzDecorator_Transparenz(), ecorePackage.getEInt(), "transparenz", "255", 0, 1,
				TransparenzDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(linienStyleDecoratorEClass, LinienStyleDecorator.class, "LinienStyleDecorator", IS_ABSTRACT,
				IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getLinienStyleDecorator_Style(), this.getLinienStyle(), "style", "Durchgezogen", 0, 1,
				LinienStyleDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(zoomVerhaltenFixDecoratorEClass, ZoomVerhaltenFixDecorator.class, "ZoomVerhaltenFixDecorator",
				IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getZoomVerhaltenFixDecorator_ZoomVerhaltenFix(), ecorePackage.getEBoolean(), "ZoomVerhaltenFix",
				"true", 0, 1, ZoomVerhaltenFixDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				!IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(minMaxZoomDecoratorEClass, MinMaxZoomDecorator.class, "MinMaxZoomDecorator", IS_ABSTRACT,
				IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMinMaxZoomDecorator_MinimaleZoomstufe(), ecorePackage.getEInt(), "minimaleZoomstufe", "0", 0,
				1, MinMaxZoomDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMinMaxZoomDecorator_MaximaleZoomstufe(), ecorePackage.getEInt(), "maximaleZoomstufe", "5000",
				0, 1, MinMaxZoomDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(selektierbarDecoratorEClass, SelektierbarDecorator.class, "SelektierbarDecorator", IS_ABSTRACT,
				IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getSelektierbarDecorator_Selektierbar(), ecorePackage.getEBoolean(), "selektierbar", "true", 0,
				1, SelektierbarDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(groesseDecoratorEClass, GroesseDecorator.class, "GroesseDecorator", IS_ABSTRACT, IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getGroesseDecorator_Groesse(), theGefPackage.getDimension(), "groesse", "Dimension(100,100)", 0,
				1, GroesseDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(linienstaerkeZoomDecoratorEClass, LinienstaerkeZoomDecorator.class, "LinienstaerkeZoomDecorator",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getLinienstaerkeZoomDecorator_LinienstaerkeZoomverhalten(), this.getZoomverhalten(),
				"linienstaerkeZoomverhalten", "statisches Zoomverhalten", 0, 1, LinienstaerkeZoomDecorator.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getLinienstaerkeZoomDecorator_LinienstaerkeMinimaleZoomstufe(), ecorePackage.getEInt(),
				"linienstaerkeMinimaleZoomstufe", "0", 0, 1, LinienstaerkeZoomDecorator.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getLinienstaerkeZoomDecorator_LinienstaerkeMaximaleZoomstufe(), ecorePackage.getEInt(),
				"linienstaerkeMaximaleZoomstufe", "5000", 0, 1, LinienstaerkeZoomDecorator.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getLinienstaerkeZoomDecorator_LinienstaerkeMaximum(), ecorePackage.getEInt(),
				"linienstaerkeMaximum", "1", 0, 1, LinienstaerkeZoomDecorator.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getLinienstaerkeZoomDecorator_LinienstaerkeMinimum(), ecorePackage.getEInt(),
				"linienstaerkeMinimum", "1", 0, 1, LinienstaerkeZoomDecorator.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getLinienstaerkeZoomDecorator_Linienstaerke(), ecorePackage.getEInt(), "linienstaerke", "1", 0,
				1, LinienstaerkeZoomDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(linienabstandZoomDecoratorEClass, LinienabstandZoomDecorator.class, "LinienabstandZoomDecorator",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getLinienabstandZoomDecorator_LinienabstandZoomverhalten(), this.getZoomverhalten(),
				"linienabstandZoomverhalten", "statisches Zoomverhalten", 0, 1, LinienabstandZoomDecorator.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getLinienabstandZoomDecorator_LinienabstandMinimaleZoomstufe(), ecorePackage.getEInt(),
				"linienabstandMinimaleZoomstufe", "0", 0, 1, LinienabstandZoomDecorator.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getLinienabstandZoomDecorator_LinienabstandMaximaleZoomstufe(), ecorePackage.getEInt(),
				"linienabstandMaximaleZoomstufe", "5000", 0, 1, LinienabstandZoomDecorator.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getLinienabstandZoomDecorator_LinienabstandMaximum(), ecorePackage.getEInt(),
				"linienabstandMaximum", "1", 0, 1, LinienabstandZoomDecorator.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getLinienabstandZoomDecorator_LinienabstandMinimum(), ecorePackage.getEInt(),
				"linienabstandMinimum", "1", 0, 1, LinienabstandZoomDecorator.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getLinienabstandZoomDecorator_Linienabstand(), ecorePackage.getEInt(), "linienabstand", "1", 0,
				1, LinienabstandZoomDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(linienStyleEEnum, LinienStyle.class, "LinienStyle");
		addEEnumLiteral(linienStyleEEnum, LinienStyle.DURCHGEZOGEN);
		addEEnumLiteral(linienStyleEEnum, LinienStyle.STRICH);
		addEEnumLiteral(linienStyleEEnum, LinienStyle.STRICH_PUNKT);
		addEEnumLiteral(linienStyleEEnum, LinienStyle.STRICH_PUNKT_PUNKT);
		addEEnumLiteral(linienStyleEEnum, LinienStyle.PUNKT);

		initEEnum(zoomverhaltenEEnum, Zoomverhalten.class, "Zoomverhalten");
		addEEnumLiteral(zoomverhaltenEEnum, Zoomverhalten.STATISCHES_ZOOMVERHALTEN);
		addEEnumLiteral(zoomverhaltenEEnum, Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN);

		// Create resource
		createResource(eNS_URI);
	}

} // DobjDecoratorPackageImpl
