/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten;

/**
 * <!-- begin-user-doc --> An implementation of the model object
 * '<em><b>Linienstaerke Zoom Decorator</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>{@link de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienstaerkeZoomDecoratorImpl#getLinienstaerkeZoomverhalten
 * <em>Linienstaerke Zoomverhalten</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienstaerkeZoomDecoratorImpl#getLinienstaerkeMinimaleZoomstufe
 * <em>Linienstaerke Minimale Zoomstufe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienstaerkeZoomDecoratorImpl#getLinienstaerkeMaximaleZoomstufe
 * <em>Linienstaerke Maximale Zoomstufe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienstaerkeZoomDecoratorImpl#getLinienstaerkeMaximum
 * <em>Linienstaerke Maximum</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienstaerkeZoomDecoratorImpl#getLinienstaerkeMinimum
 * <em>Linienstaerke Minimum</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.dobj.decorator.model.impl.LinienstaerkeZoomDecoratorImpl#getLinienstaerke
 * <em>Linienstaerke</em>}</li>
 * </ul>
 *
 * @generated
 */
public class LinienstaerkeZoomDecoratorImpl extends EObjectImpl implements LinienstaerkeZoomDecorator {
	/**
	 * The default value of the '{@link #getLinienstaerkeZoomverhalten()
	 * <em>Linienstaerke Zoomverhalten</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeZoomverhalten()
	 * @generated
	 * @ordered
	 */
	protected static final Zoomverhalten LINIENSTAERKE_ZOOMVERHALTEN_EDEFAULT = Zoomverhalten.STATISCHES_ZOOMVERHALTEN;

	/**
	 * The cached value of the '{@link #getLinienstaerkeZoomverhalten()
	 * <em>Linienstaerke Zoomverhalten</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeZoomverhalten()
	 * @generated
	 * @ordered
	 */
	protected Zoomverhalten linienstaerkeZoomverhalten = LINIENSTAERKE_ZOOMVERHALTEN_EDEFAULT;

	/**
	 * The default value of the '{@link #getLinienstaerkeMinimaleZoomstufe()
	 * <em>Linienstaerke Minimale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMinimaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MINIMALE_ZOOMSTUFE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLinienstaerkeMinimaleZoomstufe()
	 * <em>Linienstaerke Minimale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMinimaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMinimaleZoomstufe = LINIENSTAERKE_MINIMALE_ZOOMSTUFE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Minimale Zoomstufe attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMinimaleZoomstufeESet;

	/**
	 * The default value of the '{@link #getLinienstaerkeMaximaleZoomstufe()
	 * <em>Linienstaerke Maximale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMaximaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_EDEFAULT = 5000;

	/**
	 * The cached value of the '{@link #getLinienstaerkeMaximaleZoomstufe()
	 * <em>Linienstaerke Maximale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMaximaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMaximaleZoomstufe = LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Maximale Zoomstufe attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMaximaleZoomstufeESet;

	/**
	 * The default value of the '{@link #getLinienstaerkeMaximum()
	 * <em>Linienstaerke Maximum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMaximum()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MAXIMUM_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienstaerkeMaximum()
	 * <em>Linienstaerke Maximum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMaximum()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMaximum = LINIENSTAERKE_MAXIMUM_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Maximum attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMaximumESet;

	/**
	 * The default value of the '{@link #getLinienstaerkeMinimum()
	 * <em>Linienstaerke Minimum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMinimum()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MINIMUM_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienstaerkeMinimum()
	 * <em>Linienstaerke Minimum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMinimum()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMinimum = LINIENSTAERKE_MINIMUM_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Minimum attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMinimumESet;

	/**
	 * The default value of the '{@link #getLinienstaerke()
	 * <em>Linienstaerke</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerke()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienstaerke()
	 * <em>Linienstaerke</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerke()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerke = LINIENSTAERKE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeESet;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected LinienstaerkeZoomDecoratorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Zoomverhalten getLinienstaerkeZoomverhalten() {
		return linienstaerkeZoomverhalten;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeZoomverhalten(Zoomverhalten newLinienstaerkeZoomverhalten) {
		final Zoomverhalten oldLinienstaerkeZoomverhalten = linienstaerkeZoomverhalten;
		linienstaerkeZoomverhalten = newLinienstaerkeZoomverhalten == null ? LINIENSTAERKE_ZOOMVERHALTEN_EDEFAULT
				: newLinienstaerkeZoomverhalten;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_ZOOMVERHALTEN,
					oldLinienstaerkeZoomverhalten, linienstaerkeZoomverhalten));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMinimaleZoomstufe() {
		return linienstaerkeMinimaleZoomstufe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMinimaleZoomstufe(int newLinienstaerkeMinimaleZoomstufe) {
		final int oldLinienstaerkeMinimaleZoomstufe = linienstaerkeMinimaleZoomstufe;
		linienstaerkeMinimaleZoomstufe = newLinienstaerkeMinimaleZoomstufe;
		final boolean oldLinienstaerkeMinimaleZoomstufeESet = linienstaerkeMinimaleZoomstufeESet;
		linienstaerkeMinimaleZoomstufeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMALE_ZOOMSTUFE,
					oldLinienstaerkeMinimaleZoomstufe, linienstaerkeMinimaleZoomstufe,
					!oldLinienstaerkeMinimaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMinimaleZoomstufe() {
		final int oldLinienstaerkeMinimaleZoomstufe = linienstaerkeMinimaleZoomstufe;
		final boolean oldLinienstaerkeMinimaleZoomstufeESet = linienstaerkeMinimaleZoomstufeESet;
		linienstaerkeMinimaleZoomstufe = LINIENSTAERKE_MINIMALE_ZOOMSTUFE_EDEFAULT;
		linienstaerkeMinimaleZoomstufeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMALE_ZOOMSTUFE,
					oldLinienstaerkeMinimaleZoomstufe, LINIENSTAERKE_MINIMALE_ZOOMSTUFE_EDEFAULT,
					oldLinienstaerkeMinimaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMinimaleZoomstufe() {
		return linienstaerkeMinimaleZoomstufeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMaximaleZoomstufe() {
		return linienstaerkeMaximaleZoomstufe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMaximaleZoomstufe(int newLinienstaerkeMaximaleZoomstufe) {
		final int oldLinienstaerkeMaximaleZoomstufe = linienstaerkeMaximaleZoomstufe;
		linienstaerkeMaximaleZoomstufe = newLinienstaerkeMaximaleZoomstufe;
		final boolean oldLinienstaerkeMaximaleZoomstufeESet = linienstaerkeMaximaleZoomstufeESet;
		linienstaerkeMaximaleZoomstufeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE,
					oldLinienstaerkeMaximaleZoomstufe, linienstaerkeMaximaleZoomstufe,
					!oldLinienstaerkeMaximaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMaximaleZoomstufe() {
		final int oldLinienstaerkeMaximaleZoomstufe = linienstaerkeMaximaleZoomstufe;
		final boolean oldLinienstaerkeMaximaleZoomstufeESet = linienstaerkeMaximaleZoomstufeESet;
		linienstaerkeMaximaleZoomstufe = LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_EDEFAULT;
		linienstaerkeMaximaleZoomstufeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE,
					oldLinienstaerkeMaximaleZoomstufe, LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_EDEFAULT,
					oldLinienstaerkeMaximaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMaximaleZoomstufe() {
		return linienstaerkeMaximaleZoomstufeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMaximum() {
		return linienstaerkeMaximum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMaximum(int newLinienstaerkeMaximum) {
		final int oldLinienstaerkeMaximum = linienstaerkeMaximum;
		linienstaerkeMaximum = newLinienstaerkeMaximum;
		final boolean oldLinienstaerkeMaximumESet = linienstaerkeMaximumESet;
		linienstaerkeMaximumESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMUM, oldLinienstaerkeMaximum,
					linienstaerkeMaximum, !oldLinienstaerkeMaximumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMaximum() {
		final int oldLinienstaerkeMaximum = linienstaerkeMaximum;
		final boolean oldLinienstaerkeMaximumESet = linienstaerkeMaximumESet;
		linienstaerkeMaximum = LINIENSTAERKE_MAXIMUM_EDEFAULT;
		linienstaerkeMaximumESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMUM, oldLinienstaerkeMaximum,
					LINIENSTAERKE_MAXIMUM_EDEFAULT, oldLinienstaerkeMaximumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMaximum() {
		return linienstaerkeMaximumESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMinimum() {
		return linienstaerkeMinimum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMinimum(int newLinienstaerkeMinimum) {
		final int oldLinienstaerkeMinimum = linienstaerkeMinimum;
		linienstaerkeMinimum = newLinienstaerkeMinimum;
		final boolean oldLinienstaerkeMinimumESet = linienstaerkeMinimumESet;
		linienstaerkeMinimumESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMUM, oldLinienstaerkeMinimum,
					linienstaerkeMinimum, !oldLinienstaerkeMinimumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMinimum() {
		final int oldLinienstaerkeMinimum = linienstaerkeMinimum;
		final boolean oldLinienstaerkeMinimumESet = linienstaerkeMinimumESet;
		linienstaerkeMinimum = LINIENSTAERKE_MINIMUM_EDEFAULT;
		linienstaerkeMinimumESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMUM, oldLinienstaerkeMinimum,
					LINIENSTAERKE_MINIMUM_EDEFAULT, oldLinienstaerkeMinimumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMinimum() {
		return linienstaerkeMinimumESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerke() {
		return linienstaerke;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerke(int newLinienstaerke) {
		final int oldLinienstaerke = linienstaerke;
		linienstaerke = newLinienstaerke;
		final boolean oldLinienstaerkeESet = linienstaerkeESet;
		linienstaerkeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE, oldLinienstaerke, linienstaerke,
					!oldLinienstaerkeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerke() {
		final int oldLinienstaerke = linienstaerke;
		final boolean oldLinienstaerkeESet = linienstaerkeESet;
		linienstaerke = LINIENSTAERKE_EDEFAULT;
		linienstaerkeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE, oldLinienstaerke,
					LINIENSTAERKE_EDEFAULT, oldLinienstaerkeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerke() {
		return linienstaerkeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_ZOOMVERHALTEN:
			return getLinienstaerkeZoomverhalten();
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMALE_ZOOMSTUFE:
			return getLinienstaerkeMinimaleZoomstufe();
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE:
			return getLinienstaerkeMaximaleZoomstufe();
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMUM:
			return getLinienstaerkeMaximum();
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMUM:
			return getLinienstaerkeMinimum();
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE:
			return getLinienstaerke();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_ZOOMVERHALTEN:
			setLinienstaerkeZoomverhalten((Zoomverhalten) newValue);
			return;
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMALE_ZOOMSTUFE:
			setLinienstaerkeMinimaleZoomstufe((Integer) newValue);
			return;
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE:
			setLinienstaerkeMaximaleZoomstufe((Integer) newValue);
			return;
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMUM:
			setLinienstaerkeMaximum((Integer) newValue);
			return;
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMUM:
			setLinienstaerkeMinimum((Integer) newValue);
			return;
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE:
			setLinienstaerke((Integer) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_ZOOMVERHALTEN:
			setLinienstaerkeZoomverhalten(LINIENSTAERKE_ZOOMVERHALTEN_EDEFAULT);
			return;
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMALE_ZOOMSTUFE:
			unsetLinienstaerkeMinimaleZoomstufe();
			return;
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE:
			unsetLinienstaerkeMaximaleZoomstufe();
			return;
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMUM:
			unsetLinienstaerkeMaximum();
			return;
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMUM:
			unsetLinienstaerkeMinimum();
			return;
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE:
			unsetLinienstaerke();
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_ZOOMVERHALTEN:
			return linienstaerkeZoomverhalten != LINIENSTAERKE_ZOOMVERHALTEN_EDEFAULT;
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMALE_ZOOMSTUFE:
			return isSetLinienstaerkeMinimaleZoomstufe();
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE:
			return isSetLinienstaerkeMaximaleZoomstufe();
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMUM:
			return isSetLinienstaerkeMaximum();
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMUM:
			return isSetLinienstaerkeMinimum();
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE:
			return isSetLinienstaerke();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) {
			return super.toString();
		}

		final StringBuilder result = new StringBuilder(super.toString());
		result.append(" (linienstaerkeZoomverhalten: ");
		result.append(linienstaerkeZoomverhalten);
		result.append(", linienstaerkeMinimaleZoomstufe: ");
		if (linienstaerkeMinimaleZoomstufeESet) {
			result.append(linienstaerkeMinimaleZoomstufe);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMaximaleZoomstufe: ");
		if (linienstaerkeMaximaleZoomstufeESet) {
			result.append(linienstaerkeMaximaleZoomstufe);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMaximum: ");
		if (linienstaerkeMaximumESet) {
			result.append(linienstaerkeMaximum);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMinimum: ");
		if (linienstaerkeMinimumESet) {
			result.append(linienstaerkeMinimum);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerke: ");
		if (linienstaerkeESet) {
			result.append(linienstaerke);
		} else {
			result.append("<unset>");
		}
		result.append(')');
		return result.toString();
	}

} // LinienstaerkeZoomDecoratorImpl
