/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.model.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

import de.bsvrz.buv.plugin.dobj.decorator.model.AntikollisionsalgorithmusDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.GroesseDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyleDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.MinMaxZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.TransparenzDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator;

/**
 * <!-- begin-user-doc --> The <b>Adapter Factory</b> for the model. It provides
 * an adapter <code>createXXX</code> method for each class of the model. <!--
 * end-user-doc -->
 * 
 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage
 * @generated
 */
public class DobjDecoratorAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected static DobjDecoratorPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public DobjDecoratorAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = DobjDecoratorPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc --> This implementation returns <code>true</code> if
	 * the object is either the model's package or is an instance object of the
	 * model. <!-- end-user-doc -->
	 * 
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject) object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected DobjDecoratorSwitch<Adapter> modelSwitch = new DobjDecoratorSwitch<Adapter>() {
		@Override
		public Adapter caseLinienabstandDecorator(LinienabstandDecorator object) {
			return createLinienabstandDecoratorAdapter();
		}

		@Override
		public Adapter caseSkalierungDecorator(SkalierungDecorator object) {
			return createSkalierungDecoratorAdapter();
		}

		@Override
		public Adapter caseDrehungDecorator(DrehungDecorator object) {
			return createDrehungDecoratorAdapter();
		}

		@Override
		public Adapter caseDatenstatusDecorator(DatenstatusDecorator object) {
			return createDatenstatusDecoratorAdapter();
		}

		@Override
		public Adapter caseLinienstaerkeDecorator(LinienstaerkeDecorator object) {
			return createLinienstaerkeDecoratorAdapter();
		}

		@Override
		public Adapter caseVordergrundfarbeDecorator(VordergrundfarbeDecorator object) {
			return createVordergrundfarbeDecoratorAdapter();
		}

		@Override
		public Adapter caseHintergrundfarbeDecorator(HintergrundfarbeDecorator object) {
			return createHintergrundfarbeDecoratorAdapter();
		}

		@Override
		public Adapter caseSchriftDecorator(SchriftDecorator object) {
			return createSchriftDecoratorAdapter();
		}

		@Override
		public Adapter caseStoerfallIndikatorDecorator(StoerfallIndikatorDecorator object) {
			return createStoerfallIndikatorDecoratorAdapter();
		}

		@Override
		public Adapter caseAntikollisionsalgorithmusDecorator(AntikollisionsalgorithmusDecorator object) {
			return createAntikollisionsalgorithmusDecoratorAdapter();
		}

		@Override
		public Adapter caseTransparenzDecorator(TransparenzDecorator object) {
			return createTransparenzDecoratorAdapter();
		}

		@Override
		public Adapter caseLinienStyleDecorator(LinienStyleDecorator object) {
			return createLinienStyleDecoratorAdapter();
		}

		@Override
		public Adapter caseZoomVerhaltenFixDecorator(ZoomVerhaltenFixDecorator object) {
			return createZoomVerhaltenFixDecoratorAdapter();
		}

		@Override
		public Adapter caseMinMaxZoomDecorator(MinMaxZoomDecorator object) {
			return createMinMaxZoomDecoratorAdapter();
		}

		@Override
		public Adapter caseSelektierbarDecorator(SelektierbarDecorator object) {
			return createSelektierbarDecoratorAdapter();
		}

		@Override
		public Adapter caseGroesseDecorator(GroesseDecorator object) {
			return createGroesseDecoratorAdapter();
		}

		@Override
		public Adapter caseLinienstaerkeZoomDecorator(LinienstaerkeZoomDecorator object) {
			return createLinienstaerkeZoomDecoratorAdapter();
		}

		@Override
		public Adapter caseLinienabstandZoomDecorator(LinienabstandZoomDecorator object) {
			return createLinienabstandZoomDecoratorAdapter();
		}

		@Override
		public Adapter defaultCase(EObject object) {
			return createEObjectAdapter();
		}
	};

	/**
	 * Creates an adapter for the <code>target</code>. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @param target
	 *            the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject) target);
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandDecorator
	 * <em>Linienabstand Decorator</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandDecorator
	 * @generated
	 */
	public Adapter createLinienabstandDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator
	 * <em>Skalierung Decorator</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator
	 * @generated
	 */
	public Adapter createSkalierungDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator
	 * <em>Drehung Decorator</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator
	 * @generated
	 */
	public Adapter createDrehungDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator
	 * <em>Datenstatus Decorator</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator
	 * @generated
	 */
	public Adapter createDatenstatusDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeDecorator
	 * <em>Linienstaerke Decorator</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeDecorator
	 * @generated
	 */
	public Adapter createLinienstaerkeDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator
	 * <em>Vordergrundfarbe Decorator</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator
	 * @generated
	 */
	public Adapter createVordergrundfarbeDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator
	 * <em>Hintergrundfarbe Decorator</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator
	 * @generated
	 */
	public Adapter createHintergrundfarbeDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator
	 * <em>Schrift Decorator</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator
	 * @generated
	 */
	public Adapter createSchriftDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator
	 * <em>Stoerfall Indikator Decorator</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator
	 * @generated
	 */
	public Adapter createStoerfallIndikatorDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.AntikollisionsalgorithmusDecorator
	 * <em>Antikollisionsalgorithmus Decorator</em>}'. <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.AntikollisionsalgorithmusDecorator
	 * @generated
	 */
	public Adapter createAntikollisionsalgorithmusDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.TransparenzDecorator
	 * <em>Transparenz Decorator</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.TransparenzDecorator
	 * @generated
	 */
	public Adapter createTransparenzDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyleDecorator
	 * <em>Linien Style Decorator</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyleDecorator
	 * @generated
	 */
	public Adapter createLinienStyleDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator
	 * <em>Zoom Verhalten Fix Decorator</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator
	 * @generated
	 */
	public Adapter createZoomVerhaltenFixDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.MinMaxZoomDecorator
	 * <em>Min Max Zoom Decorator</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.MinMaxZoomDecorator
	 * @generated
	 */
	public Adapter createMinMaxZoomDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator
	 * <em>Selektierbar Decorator</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator
	 * @generated
	 */
	public Adapter createSelektierbarDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.GroesseDecorator
	 * <em>Groesse Decorator</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.GroesseDecorator
	 * @generated
	 */
	public Adapter createGroesseDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator
	 * <em>Linienstaerke Zoom Decorator</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator
	 * @generated
	 */
	public Adapter createLinienstaerkeZoomDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator
	 * <em>Linienabstand Zoom Decorator</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator
	 * @generated
	 */
	public Adapter createLinienabstandZoomDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case. <!-- begin-user-doc --> This
	 * default implementation returns null. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} // DobjDecoratorAdapterFactory
