/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.model.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Switch;

import de.bsvrz.buv.plugin.dobj.decorator.model.AntikollisionsalgorithmusDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.GroesseDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyleDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.MinMaxZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.TransparenzDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator;

/**
 * <!-- begin-user-doc --> The <b>Switch</b> for the model's inheritance
 * hierarchy. It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object and proceeding up the
 * inheritance hierarchy until a non-null result is returned, which is the
 * result of the switch. <!-- end-user-doc -->
 * 
 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage
 * @generated
 */
public class DobjDecoratorSwitch<T> extends Switch<T> {
	/**
	 * The cached model package <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected static DobjDecoratorPackage modelPackage;

	/**
	 * Creates an instance of the switch. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public DobjDecoratorSwitch() {
		if (modelPackage == null) {
			modelPackage = DobjDecoratorPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param ePackage
	 *            the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns
	 * a non null result; it yields that result. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the first non-null result returned by a <code>caseXXX</code>
	 *         call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
		case DobjDecoratorPackage.LINIENABSTAND_DECORATOR: {
			final LinienabstandDecorator linienabstandDecorator = (LinienabstandDecorator) theEObject;
			T result = caseLinienabstandDecorator(linienabstandDecorator);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case DobjDecoratorPackage.SKALIERUNG_DECORATOR: {
			final SkalierungDecorator skalierungDecorator = (SkalierungDecorator) theEObject;
			T result = caseSkalierungDecorator(skalierungDecorator);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case DobjDecoratorPackage.DREHUNG_DECORATOR: {
			final DrehungDecorator drehungDecorator = (DrehungDecorator) theEObject;
			T result = caseDrehungDecorator(drehungDecorator);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case DobjDecoratorPackage.DATENSTATUS_DECORATOR: {
			final DatenstatusDecorator datenstatusDecorator = (DatenstatusDecorator) theEObject;
			T result = caseDatenstatusDecorator(datenstatusDecorator);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case DobjDecoratorPackage.LINIENSTAERKE_DECORATOR: {
			final LinienstaerkeDecorator linienstaerkeDecorator = (LinienstaerkeDecorator) theEObject;
			T result = caseLinienstaerkeDecorator(linienstaerkeDecorator);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case DobjDecoratorPackage.VORDERGRUNDFARBE_DECORATOR: {
			final VordergrundfarbeDecorator vordergrundfarbeDecorator = (VordergrundfarbeDecorator) theEObject;
			T result = caseVordergrundfarbeDecorator(vordergrundfarbeDecorator);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case DobjDecoratorPackage.HINTERGRUNDFARBE_DECORATOR: {
			final HintergrundfarbeDecorator hintergrundfarbeDecorator = (HintergrundfarbeDecorator) theEObject;
			T result = caseHintergrundfarbeDecorator(hintergrundfarbeDecorator);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case DobjDecoratorPackage.SCHRIFT_DECORATOR: {
			final SchriftDecorator schriftDecorator = (SchriftDecorator) theEObject;
			T result = caseSchriftDecorator(schriftDecorator);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case DobjDecoratorPackage.STOERFALL_INDIKATOR_DECORATOR: {
			final StoerfallIndikatorDecorator stoerfallIndikatorDecorator = (StoerfallIndikatorDecorator) theEObject;
			T result = caseStoerfallIndikatorDecorator(stoerfallIndikatorDecorator);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case DobjDecoratorPackage.ANTIKOLLISIONSALGORITHMUS_DECORATOR: {
			final AntikollisionsalgorithmusDecorator antikollisionsalgorithmusDecorator = (AntikollisionsalgorithmusDecorator) theEObject;
			T result = caseAntikollisionsalgorithmusDecorator(antikollisionsalgorithmusDecorator);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case DobjDecoratorPackage.TRANSPARENZ_DECORATOR: {
			final TransparenzDecorator transparenzDecorator = (TransparenzDecorator) theEObject;
			T result = caseTransparenzDecorator(transparenzDecorator);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case DobjDecoratorPackage.LINIEN_STYLE_DECORATOR: {
			final LinienStyleDecorator linienStyleDecorator = (LinienStyleDecorator) theEObject;
			T result = caseLinienStyleDecorator(linienStyleDecorator);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case DobjDecoratorPackage.ZOOM_VERHALTEN_FIX_DECORATOR: {
			final ZoomVerhaltenFixDecorator zoomVerhaltenFixDecorator = (ZoomVerhaltenFixDecorator) theEObject;
			T result = caseZoomVerhaltenFixDecorator(zoomVerhaltenFixDecorator);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case DobjDecoratorPackage.MIN_MAX_ZOOM_DECORATOR: {
			final MinMaxZoomDecorator minMaxZoomDecorator = (MinMaxZoomDecorator) theEObject;
			T result = caseMinMaxZoomDecorator(minMaxZoomDecorator);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case DobjDecoratorPackage.SELEKTIERBAR_DECORATOR: {
			final SelektierbarDecorator selektierbarDecorator = (SelektierbarDecorator) theEObject;
			T result = caseSelektierbarDecorator(selektierbarDecorator);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case DobjDecoratorPackage.GROESSE_DECORATOR: {
			final GroesseDecorator groesseDecorator = (GroesseDecorator) theEObject;
			T result = caseGroesseDecorator(groesseDecorator);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR: {
			final LinienstaerkeZoomDecorator linienstaerkeZoomDecorator = (LinienstaerkeZoomDecorator) theEObject;
			T result = caseLinienstaerkeZoomDecorator(linienstaerkeZoomDecorator);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR: {
			final LinienabstandZoomDecorator linienabstandZoomDecorator = (LinienabstandZoomDecorator) theEObject;
			T result = caseLinienabstandZoomDecorator(linienabstandZoomDecorator);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		default:
			return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Linienabstand Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Linienabstand Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLinienabstandDecorator(LinienabstandDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Skalierung Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Skalierung Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSkalierungDecorator(SkalierungDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Drehung Decorator</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Drehung Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDrehungDecorator(DrehungDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Datenstatus Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Datenstatus Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDatenstatusDecorator(DatenstatusDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Linienstaerke Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Linienstaerke Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLinienstaerkeDecorator(LinienstaerkeDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Vordergrundfarbe Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Vordergrundfarbe Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseVordergrundfarbeDecorator(VordergrundfarbeDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Hintergrundfarbe Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Hintergrundfarbe Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHintergrundfarbeDecorator(HintergrundfarbeDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Schrift Decorator</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Schrift Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSchriftDecorator(SchriftDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Stoerfall Indikator Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Stoerfall Indikator Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStoerfallIndikatorDecorator(StoerfallIndikatorDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Antikollisionsalgorithmus Decorator</em>'. <!-- begin-user-doc -->
	 * This implementation returns null; returning a non-null result will
	 * terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Antikollisionsalgorithmus Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAntikollisionsalgorithmusDecorator(AntikollisionsalgorithmusDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Transparenz Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Transparenz Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTransparenzDecorator(TransparenzDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Linien Style Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Linien Style Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLinienStyleDecorator(LinienStyleDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Zoom
	 * Verhalten Fix Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Zoom
	 *         Verhalten Fix Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseZoomVerhaltenFixDecorator(ZoomVerhaltenFixDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Min
	 * Max Zoom Decorator</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Min
	 *         Max Zoom Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMinMaxZoomDecorator(MinMaxZoomDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Selektierbar Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Selektierbar Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSelektierbarDecorator(SelektierbarDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Groesse Decorator</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Groesse Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGroesseDecorator(GroesseDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Linienstaerke Zoom Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Linienstaerke Zoom Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLinienstaerkeZoomDecorator(LinienstaerkeZoomDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Linienabstand Zoom Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Linienabstand Zoom Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLinienabstandZoomDecorator(LinienabstandZoomDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>EObject</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch, but this is
	 * the last case anyway. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object) {
		return null;
	}

} // DobjDecoratorSwitch
