/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.editors;

import org.eclipse.gef.ui.actions.ActionBarContributor;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.actions.MatchHeightRetargetAction;
import org.eclipse.gef.ui.actions.MatchWidthRetargetAction;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.gef.ui.actions.ZoomInRetargetAction;
import org.eclipse.gef.ui.actions.ZoomOutRetargetAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.actions.ActionFactory;

import de.bsvrz.buv.plugin.dobj.actions.DobjActionFactory;

/**
 * Kann als Basisklasse für {@link ActionBarContributor}s verwendet werden.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class DobjActionBarContributor extends ActionBarContributor {

	/** Name der Gruppe für Auswahlwerkzeuge. */
	public static final String GROUP_SELECTION = "selection";

	/** Name der Gruppe für Zoomwerkzeuge. */
	public static final String GROUP_ZOOM = "zoom";

	@Override
	protected void buildActions() {
		// Größenanpassung
		addRetargetAction(new MatchWidthRetargetAction());
		addRetargetAction(new MatchHeightRetargetAction());

		// Zoomen
		addRetargetAction(DobjActionFactory.PAN.create());
		addRetargetAction(DobjActionFactory.ZOOM_RECTANGLE.create());
		addRetargetAction(new ZoomInRetargetAction());
		addRetargetAction(new ZoomOutRetargetAction());
	}

	@Override
	public void contributeToToolBar(final IToolBarManager toolBarManager) {
		toolBarManager.add(getAction(DobjActionFactory.PAN.getCommandId()));

		toolBarManager.add(new Separator(GROUP_SELECTION));
		toolBarManager.add(new Separator(GROUP_ZOOM));

		toolBarManager.appendToGroup(GROUP_ZOOM, getAction(DobjActionFactory.ZOOM_RECTANGLE.getCommandId()));
		toolBarManager.appendToGroup(GROUP_ZOOM, getAction(GEFActionConstants.ZOOM_IN));
		toolBarManager.appendToGroup(GROUP_ZOOM, getAction(GEFActionConstants.ZOOM_OUT));
		toolBarManager.appendToGroup(GROUP_ZOOM, new ZoomComboContributionItem(getPage()));
	}

	@Override
	protected void declareGlobalActionKeys() {
		// XXX Drucken im Rahmenwerk entfernen?
		addGlobalActionKey(ActionFactory.PRINT.getCommandId());
		addGlobalActionKey(ActionFactory.SELECT_ALL.getCommandId());
	}

}
