/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;

/**
 * Basisklasse für Context Menu Provider für Editoren die Darstellungsobjekte
 * und Darstellungen bearbeiten.
 *
 * <p>
 * Registriert Aktionen für UNDO, REDO und DELETE.
 *
 * <p>
 * Das Context Menu enthält eine Sektion für Erweiterungen.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class DobjContextMenuProvider extends ContextMenuProvider {

	private final ActionRegistry actionRegistry;

	/**
	 * Initialisiert den Context Menu Provider.
	 *
	 * @param viewer
	 *            der Viewer für den Das Context Menu bestimmt ist.
	 * @param actionRegistry
	 *            die Action Registry.
	 */
	public DobjContextMenuProvider(final EditPartViewer viewer, final ActionRegistry actionRegistry) {
		super(viewer);
		Assert.isNotNull(actionRegistry);
		this.actionRegistry = actionRegistry;

		setRemoveAllWhenShown(true);
	}

	@Override
	public void buildContextMenu(final IMenuManager menu) {
		// Add standard action groups to the menu
		GEFActionConstants.addStandardActionGroups(menu);

		final IAction action = getAction(GEFActionConstants.DIRECT_EDIT);
		if (action.isEnabled()) {
			menu.appendToGroup(GEFActionConstants.GROUP_EDIT, action);
		}
	}

	private IAction getAction(final String actionId) {
		return actionRegistry.getAction(actionId);
	}

}
