/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.editors;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.Tool;
import org.eclipse.ui.IEditorPart;

import de.bsvrz.buv.plugin.dobj.tools.DObjSelectionTool;

/**
 * Diese Edit Domain sollte für Editoren verwendet werden die mit
 * Darstellungsobjekte arbeiten.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class DobjEditDomain extends DefaultEditDomain {

	/** Name der entsprechenden Property. */
	public static final String PROP_ACTIVE_TOOL = "activeTool";

	/** Name der entsprechenden Property. */
	public static final String PROP_DOBJ_SELECTION_TOOL = DObjSelectionTool.class.getSimpleName();

	private final PropertyChangeSupport pcsDelegate = new PropertyChangeSupport(this);

	private final DObjSelectionTool dobjSelectionTool;

	/**
	 * Initialisiert die Edit Domain.
	 */
	public DobjEditDomain(final IEditorPart editorPart) {
		super(editorPart);
		dobjSelectionTool = new DObjSelectionTool();
		setDefaultTool(dobjSelectionTool);
		setActiveTool(getDefaultTool());
	}

	/**
	 * Registriert einen Listener für Änderungen an Properties.
	 */
	public void addPropertyChangeListener(final PropertyChangeListener l) {
		pcsDelegate.addPropertyChangeListener(l);
	}

	/**
	 * Registriert einen Listener für Änderungen an einer bestimmten Property.
	 */
	public void addPropertyChangeListener(final String propertyName, final PropertyChangeListener l) {
		pcsDelegate.addPropertyChangeListener(propertyName, l);
	}

	/**
	 * Entfernt einen registrierten Listener für Änderungen an Properties.
	 */
	public void removePropertyChangeListener(final PropertyChangeListener l) {
		pcsDelegate.removePropertyChangeListener(l);
	}

	/**
	 * Entfernt einen registrierten Listener für Änderungen an einer bestimmten
	 * Property.
	 */
	public void removePropertyChangeListener(final String propertyName, final PropertyChangeListener l) {
		pcsDelegate.removePropertyChangeListener(propertyName, l);
	}

	/**
	 * Sendet zusätzlich ein Event, wenn das aktuelle Tool geändert wird.
	 */
	@Override
	public void setActiveTool(final Tool tool) {
		final Tool oldValue = getActiveTool();
		super.setActiveTool(tool);

		/*
		 * Prüfung auf null ist ein Workaround, weil setActiveTool() bereits im
		 * Konstruktor der Basisklasse aufgerufen wird.
		 */
		if (pcsDelegate != null) {
			pcsDelegate.firePropertyChange(PROP_ACTIVE_TOOL, oldValue, tool);
		}
	}

	/**
	 * liefert das Tool zur Auswahl von Darstellungsobjekten.
	 *
	 * @return das Tool
	 */
	public final DObjSelectionTool getDobjSelectionTool() {
		return dobjSelectionTool;
	}
}
