/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;

import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;

/**
 * Basisklasse für Edit Parts, die {@link BitCtrlDoModel}-Objekte kontrollieren.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 * @param <T>
 */
public abstract class BitCtrlDoModelEditPart<T extends SystemObjekt, F extends IFigure>
		extends DoModelEditPart<BitCtrlDoModel<T>, F> {

	/**
	 * Gibt das Systemobjekt zurück, welches das Modellobjekt repräsentiert.
	 *
	 * @return das Systemobjekt, welches hier dargestellt wird.
	 */
	protected T getSystemObjekt() {
		return getModel().getSystemObjekt();
	}

	/**
	 * Gibt die Objektfactory des BitCtrl-Datenverteilermodells zurück.
	 *
	 * @return die Objektfactory für die Nutzerverbindung.
	 */
	protected ObjektFactory getObjektFactory() {
		return RahmenwerkService.getService().getObjektFactory();
	}

	@Override
	public Object getAdapter(final Class key) {
		final T element = getSystemObjekt();
		if ((element != null) && key.isAssignableFrom(element.getClass())) {
			return element;
		}
		return super.getAdapter(key);
	}

	@Override
	public void notifyChanged(final Notification notification) {
		super.notifyChanged(notification);

		final Object notifier = notification.getNotifier();
		final int type = notification.getEventType();

		if (notifier instanceof BitCtrlDoModel) {
			final int featureID = notification.getFeatureID(BitCtrlDoModel.class);
			switch (type) {
			case Notification.SET:
				switch (featureID) {
				case DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT:
					refreshVisuals();
					break;
				}
				break;
			}
		}
	}
}
