/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Font;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EFont;

import de.bsvrz.buv.plugin.dobj.figures.DoTextFigure;
import de.bsvrz.buv.plugin.dobj.model.DoText;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;

/**
 * {@link EditPart} für eine einfache {@link DoTextFigure}.
 *
 * @author BitCtrl Systems GmbH, Hoesel
 *
 */
public class DoTextEditPart extends DoModelEditPart<DoText, DoTextFigure> {

	@Override
	protected void createEditPolicies() {
		super.createEditPolicies();
		if (!isEditor()) {
			removeEditPolicy(EditPolicy.LAYOUT_ROLE);
		}
	}

	@Override
	protected DoTextFigure createFigure() {
		return new DoTextFigure();
	}

	@Override
	public void notifyChanged(final Notification notification) {
		super.notifyChanged(notification);

		if (DobjPackage.Literals.DO_TEXT__TEXT.equals(notification.getFeature())) {
			getFigure().setText(notification.getNewStringValue());
		} else if (DobjPackage.Literals.DO_TEXT__FONT.equals(notification.getFeature())) {
			final Object neueSchrift = notification.getNewValue();
			if (neueSchrift instanceof EFont) {
				final Font f = getResourceManager()
						.createFont(FontDescriptor.createFrom(((EFont) neueSchrift).getFontData()));
				getFigure().setFont(f);
			}
		} else if (DobjPackage.Literals.DO_TEXT__ZOOM_VERHALTEN_FIX.equals(notification.getFeature())) {
			getFigure().setZoomVerhaltenFix(notification.getNewBooleanValue());
		}
	}

	@Override
	protected IFigure getToolTip() {
		// kein Tooltip
		return null;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();

		final DoTextFigure f = getFigure();
		f.setText(getModel().getText());
		final EFont efont = getModel().getFont();
		if (efont != null) {
			final Font font = getResourceManager().createFont(FontDescriptor.createFrom(efont.getFontData()));
			f.setFont(font);
		}
		f.setZoomVerhaltenFix(getModel().isZoomVerhaltenFix());
	}

	@Override
	public void zoomChanged(final double zoom) {
		super.zoomChanged(zoom);
		getFigure().handleZoomChanged(zoom);
	}

	@Override
	public boolean isSelectable() {
		return isEditor() || (super.isSelectable() && getModel().isSelektierbar());
	}

}
