/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.draw2d.IFigure;

import de.bsvrz.buv.plugin.dobj.util.Projektion;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.GeoReferenzObjekt;

/**
 * Basisklasse für Systemobjekte vom typ {@link GeoReferenzObjekt}.
 *
 * <p>
 * Diese Klasse ist nur dafür da, um auf Änderung der {@link Projektion}
 * anzumelden. Ändert sich die Projektion, dann wird
 * {@link #cleanModellKoordinaten()} aufgerufen. Wie und welche Koordinaten
 * bestimmt werden wird in den Unterklassen bestimmt.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 * @param <T>
 * @param <F>
 * @see PunktEditPart
 * @see LinieEditPart
 * @see FlaecheEditPart
 * @see KomplexEditPart
 */
public abstract class GeoRefererenzObjektEditPart<T extends GeoReferenzObjekt, F extends IFigure>
		extends BitCtrlDoModelEditPart<T, F> {

	private final PropertyChangeListener propertyListener = new PropertyChangeListener() {

		@Override
		public void propertyChange(final PropertyChangeEvent evt) {
			final String prop = evt.getPropertyName();

			if (Projektion.class.toString().equals(prop)) {
				cleanModellKoordinaten();
				refreshVisuals();
			}
		}

	};

	/**
	 * Entfernt alle gecachten Modellkoordinaten (Pixelkoordinaten), damit diese
	 * neu berechnet werden.
	 */
	protected abstract void cleanModellKoordinaten();

	@Override
	public void activate() {
		super.activate();

		if (isEditor()) {
			getViewer().addPropertyChangeListener(propertyListener);
		}
	}

	@Override
	public void deactivate() {
		if (isEditor()) {
			getViewer().removePropertyChangeListener(propertyListener);
		}

		super.deactivate();
	}

}
