/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.editparts.tree;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ResourceManager;

import com.bitctrl.lib.eclipse.emf.gef.editparts.tree.AdapterTreeEditPart;

import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.util.DobjUtil;
import de.bsvrz.dav.daf.main.ClientDavInterface;

/**
 * Basisklasse für graphische Edit Parts, gleich ob sie ein {@link DoModel}
 * kontrollieren oder andere Modellobjekte.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 * @param <T>
 */
public abstract class BaseTreeEditPart<T extends EObject> extends AdapterTreeEditPart<T> {

	/**
	 * Gibt den Resource Manager des Viewers zurück, in dem der Edit Part
	 * dargestellt wird. Die damit angelegten Ressourcen werden wieder
	 * freigegeben, wenn der Viewer zerstört wird.
	 *
	 * @return ein Resource Manager.
	 */
	protected ResourceManager getResourceManager() {
		return getViewer().getResourceManager();
	}

	/**
	 * Gibt die Laufzeiteigenschaften der Darstellung zurück. Die wichtigsten
	 * Eigenschaften sind <code>editor</code> und <code>online</code>. *
	 *
	 * @return <code>true</code>, wenn die Property {@link DobjUtil#PROP_EDITOR}
	 *         existiert und <code>true</code> ist, sonst <code>false</code>.
	 */
	protected boolean isEditor() {
		final Object result = getViewer().getProperty(DobjUtil.PROP_EDITOR);
		if (result instanceof Boolean) {
			return (Boolean) result;
		}

		return false;
	}

	/**
	 * Gibt den Typ des Editors zurück, in dem der EditPart verwendet wird. Die
	 * Standarddefinitionen sind in {@link DobjUtil} zu finden.
	 *
	 * Wenn kein Typ deifniert ist wird 0 geliefert.
	 *
	 * @return den Typ oder 0.
	 */
	protected int getEditorType() {
		final Object result = getViewer().getProperty(DobjUtil.PROP_EDITOR_TYPE);
		if (result instanceof Integer) {
			return (Integer) result;
		}

		return 0;
	}

	/**
	 * Gibt die Nutzerverbindung zum Datenverteiler zurück.
	 *
	 * @return die Verbindung.
	 */
	protected ClientDavInterface getDav() {
		return RahmenwerkService.getService().getRahmenWerk().getDavVerbindung();
	}

}
