/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Tool;
import org.eclipse.swt.widgets.Display;

/**
 * Rechteckige Feedback Figure für {@link Tool}s.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public class AnimatedRectangleFeedbackFigure extends Figure {

	private static final int DELAY = 110; // animation delay in millisecond
	private int offset;
	private boolean schedulePaint = true;

	@Override
	protected void paintFigure(final Graphics graphics) {
		final Rectangle boundsCopy = getBounds().getCopy();
		graphics.translate(getLocation());

		// XXX Geht nicht unter Mac OS X?!
		graphics.setXORMode(true);
		graphics.setForegroundColor(ColorConstants.white);
		graphics.setBackgroundColor(ColorConstants.black);

		graphics.setLineStyle(Graphics.LINE_DOT);

		final int[] points = new int[6];

		points[0] = 0 + offset;
		points[1] = 0;
		points[2] = boundsCopy.width - 1;
		points[3] = 0;
		points[4] = boundsCopy.width - 1;
		points[5] = boundsCopy.height - 1;

		graphics.drawPolyline(points);

		points[0] = 0;
		points[1] = 0 + offset;
		points[2] = 0;
		points[3] = boundsCopy.height - 1;
		points[4] = boundsCopy.width - 1;
		points[5] = boundsCopy.height - 1;

		graphics.drawPolyline(points);
		graphics.translate(getLocation().getNegated());

		if (schedulePaint) {
			Display.getCurrent().timerExec(DELAY, new Runnable() {
				@Override
				public void run() {
					offset++;
					if (offset > 5) {
						offset = 0;
					}

					schedulePaint = true;
					repaint();
				}
			});
		}

		schedulePaint = false;
	}

}
