/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.graph;

import com.bitctrl.graph.Bogen;
import com.bitctrl.graph.Knoten;

import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdLinie;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.InneresStrassenSegment;

/**
 * Repräsentiert einen Bogen (äußeres Straßensegment) im Netzgraph.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class NetzBogen implements Bogen {

	private final AeusseresStrassenSegment aeusseresStrassenSegment;
	private final NetzKnoten anfangsKnoten;
	private final NetzKnoten endKnoten;

	/**
	 * Intialisiert den Netzbogen.
	 */
	NetzBogen(final AeusseresStrassenSegment aeusseresStrassenSegment, final NetzKnoten anfangsKnoten,
			final NetzKnoten endKnoten) {
		this.aeusseresStrassenSegment = aeusseresStrassenSegment;
		this.anfangsKnoten = anfangsKnoten;
		this.endKnoten = endKnoten;
	}

	/**
	 * Gibt das gekapselte äußeres Straßensegment.
	 */
	public AeusseresStrassenSegment getAeusseresStrassenSegment() {
		return aeusseresStrassenSegment;
	}

	@Override
	public Knoten getAnfangsKnoten() {
		return anfangsKnoten;
	}

	@Override
	public Knoten getEndKnoten() {
		return endKnoten;
	}

	@Override
	public double getLength() {
		double aessLength;
		KdStrassenSegment.Daten datumStrassenSegment = aeusseresStrassenSegment.getKdStrassenSegment().getDatum();
		KdLinie.Daten datumLinie;
		if (datumStrassenSegment != null) {
			aessLength = datumStrassenSegment.getLaenge().getValue();
		} else {
			datumLinie = aeusseresStrassenSegment.getKdLinie().getDatum();
			if (datumLinie != null) {
				aessLength = datumLinie.getLaenge().getValue();
			} else {
				System.err.println("Straßensegment ohne Länge: " + aeusseresStrassenSegment);
				aessLength = 0;
			}
		}

		double issLength;
		if (getAnfangsKnoten().getStuetzBogen() != Knoten.WURZEL_BOGEN) {
			final NetzKnoten ak = (NetzKnoten) getAnfangsKnoten();
			final NetzBogen stuetzBogen = (NetzBogen) getAnfangsKnoten().getStuetzBogen();
			final InneresStrassenSegment iss = ak.getInneresStrassenSegment(stuetzBogen.getAeusseresStrassenSegment(),
					aeusseresStrassenSegment);
			if (iss == null) {
				// Der Weg existiert nicht
				return Double.MAX_VALUE;
			}

			datumStrassenSegment = iss.getKdStrassenSegment().getDatum();
			if (datumStrassenSegment != null) {
				issLength = datumStrassenSegment.getLaenge().getValue();
			} else {
				datumLinie = iss.getKdLinie().getDatum();
				if (datumLinie != null) {
					issLength = datumLinie.getLaenge().getValue();
				} else {
					System.err.println("Straßensegment ohne Länge: " + iss);
					issLength = 0;
				}
			}
		} else {
			issLength = 0;
		}

		return aessLength + issLength;
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		} else if (obj instanceof NetzBogen) {
			final NetzBogen other = (NetzBogen) obj;
			return aeusseresStrassenSegment.equals(other.aeusseresStrassenSegment);
		}
		return false;
	}

	@Override
	public int hashCode() {
		return aeusseresStrassenSegment.hashCode();
	}

	@Override
	public String toString() {
		return aeusseresStrassenSegment.toString();
	}

}
