/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.internal;

import org.eclipse.osgi.util.NLS;

/**
 * Enthält die Übersetzungen des Plug-ins <em>Darstellungsobjekte</em>.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class DobjMessages extends NLS {

	/** Label für das Handwerkzeug zum Verschieben des anzeigten Ausschnitts. */
	public static String Pan_Label;

	/**
	 * Tooltip für das Handwerkzeug zum Verschieben des anzeigten Ausschnitts.
	 */
	public static String Pan_Tooltip;

	/** Label für das Hineinzoomen in einen Ausschnitts. */
	public static String RectangleZoom_Label;

	/** Tooltip für das Hineinzoomen in einen Ausschnitts. */
	public static String RectangleZoom_Tooltip;

	/** Label für die Aktion zum Online-/Offlineschalten einer Darstellung. */
	public static String ToggleOnline_Label;

	/** Tooltip für die Aktion zum Online-/Offlineschalten einer Darstellung. */
	public static String ToggleOnline_Tooltip;

	/** Label für das Tool Streckenselektion. */
	public static String StreckeSelection_Label;

	/** Tooltip für das Tool Streckenselektion. */
	public static String StreckeSelection_Tooltip;

	/** Label für das Tool Rechteckselektion. */
	public static String RectangleSelection_Label;

	/** Tooltip für das Tool Rechteckselektion. */
	public static String RectangleSelection_Tooltip;

	/** Label für das Tool Ellipsenselektion. */
	public static String EllipseSelection_Label;

	/** Tooltip für das Tool Ellipsenselektion. */
	public static String EllipseSelection_Tooltip;

	/** Label zur Beibehalteung des Ausschnitts. */
	public static String ToggleFixViewport_Label;

	/** Tooltip zur Beibehalteung des Ausschnitts. */
	public static String ToggleFixViewport_Tooltip;

	/** Label für die Action zum Ein-/Ausschalten der Teilselektion. */
	public static String ToggleTouchedSelection_Label;

	/** Tooltip für die Action zum Ein-/Ausschalten der Teilselektion. */
	public static String ToggleTouchedSelection_Tooltip;

	/**
	 * Label für die Action zum Ein-/Ausschalten des sofortigen
	 * Selektionsfeedbacks.
	 */
	public static String ToggleSelectionFeedback_Label;

	/**
	 * Tooltip für die Action zum Ein-/Ausschalten des sofortigen
	 * Selektionsfeedbacks.
	 */
	public static String ToggleSelectionFeedback_Tooltip;

	/**
	 * Label für die Aktion zum Ein-/Ausblenden der Verbindungsinien zwischen
	 * einem verschobenen Objekt und seiner Originalposition.
	 */
	public static String ToggleVerbindungslinie_Label;

	/**
	 * Label fuer die Aktion zum Ein-/Ausblenden des Filters fuer <b>alle</b>
	 * gueltige Baustellen.
	 */
	public static String ToggleBaustelleGueltig_Label;

	/**
	 * Tooltip für die Aktion zum Ein-/Ausblenden der Verbindungsinien zwischen
	 * einem verschobenen Objekt und seiner Originalposition.
	 */
	public static String ToggleVerbindungslinie_Tooltip;

	/**
	 * Tooltip fuer die Aktion zum Ein-/Ausblenden des Filters fuer <b>alle</b>
	 * gueltige Baustellen.
	 */
	public static String ToggleBaustelleGueltig_Tooltip;

	public static String ToggleAntiKollisionsAlgorithmus_Label;

	public static String ToggleAntiKollisionsAlgorithmus_Tooltip;

	static {
		NLS.initializeMessages("de.bsvrz.buv.plugin.dobj.internal.messages", DobjMessages.class); //$NON-NLS-1$
	}

}
