/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.kollision;

import de.bsvrz.buv.plugin.dobj.kollision.travers.IPunktTraverser;

/**
 * Schnittstelle zu einem Objekt, das sich auf der Karte mit gleichartigen
 * Objekten raeumlich arrangieren kann.
 *
 * @author BitCtrl Systems GmbH, thierfelder
 *
 */
public interface IArrangierbar {

	/**
	 * Erfragt eine Menge von Punkten, an denen sich dieses Objekt verorten
	 * koennte. Hier sollte mindestens ein Punkt (der Originalpunkt) uebergeben
	 * werden.
	 *
	 * @return eine Menge von Punkten, an denen sich dieses Objekt verorten
	 *         koennte. Nie <code>null</code>.
	 */
	IPunktTraverser getAlternativeOrte();

	/**
	 * Erfragt, ob dieses Objekt ueberhaupt sichtbar ist.
	 *
	 * @return ob dieses Objekt ueberhaupt sichtbar ist.
	 */
	boolean isSichtbar();

}
