/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.kollision;

import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.ScalableFigure;

/**
 * Utensilien.
 *
 * @author BitCtrl Systems GmbH, thierfelder
 *
 */
public final class KollisionsUtil {

	private KollisionsUtil() {
		// es gibt keine Instanzen der Klasse
	}

	/**
	 * Erfragt ob beide uebergebenen Objekte die gleiche Skalierung haben. Wenn
	 * mindestens eins der beiden Objekte nicht skalierbar ist, haben sie die
	 * gleiche Skalierung.
	 *
	 * @param o1
	 *            ein ggf. skalierbares Objekt.
	 * @param o2
	 *            ein ggf. skalierbares Objekt.
	 * @return ob beide uebergebenen Objekte die gleiche Skalierung haben.
	 */
	public static boolean haveSameScale(final Object o1, final Object o2) {
		final ScalableFigure f1 = Platform.getAdapterManager().getAdapter(o1, ScalableFigure.class);
		final ScalableFigure f2 = Platform.getAdapterManager().getAdapter(o2, ScalableFigure.class);
		if (f1 != null && f2 != null) {
			return f1.getScale() == f2.getScale();
		}
		return true;
	}

}
