/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.kollision.travers;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;

import de.bsvrz.buv.plugin.dobj.vektor.Vektor2D;

/**
 * Sucht einen Kegelstumpf ab.
 *
 * @author BitCtrl Systems GmbH, thierfelder
 *
 */
public class KegelStumpfUeberPunktAbsucher extends PunktTraverser {

	/**
	 * Standardkonstruktor.
	 *
	 * @param startMittelPunkt
	 *            (gedachte) Spitze des Kegelstumpfs und Startpunkt der Suche.
	 * @param normierterNormalenVektor
	 *            normierter Normalenvektor im Startpunkt des Kegels zum Stumpf
	 *            hin.
	 * @param achsenLaenge
	 *            Achsenlaenge des Kegels.
	 * @param anzahlPunkteSoll
	 *            Anzahl der Punkte, die innerhalb des Kegels besucht werden
	 *            sollen.
	 */
	public KegelStumpfUeberPunktAbsucher(final Point startMittelPunkt, final Vektor2D normierterNormalenVektor,
			final double achsenLaenge, final int anzahlPunkteSoll) {
		super(startMittelPunkt);
		final double radius = achsenLaenge / 2.0;
		final double step = achsenLaenge / Math.sqrt(2.0 * Math.min(anzahlPunkteSoll, achsenLaenge * achsenLaenge));

		final Vektor2D antennaLinks = normierterNormalenVektor.getNormalenVektorLinks();
		final Vektor2D antennaRechts = normierterNormalenVektor.getNormalenVektorRechts();
		double laengeSenkrechte = achsenLaenge / 5.0;
		double inset = radius / 5.0;
		for (; laengeSenkrechte < achsenLaenge; laengeSenkrechte += step) {
			for (double laengeWaagerechte = 0; laengeWaagerechte < radius - inset / 2; laengeWaagerechte += step * 2) {
				final Point punktLinks = new PrecisionPoint(
						startMittelPunkt.x + laengeSenkrechte * normierterNormalenVektor.x
								+ antennaLinks.x * laengeWaagerechte,
						startMittelPunkt.y + laengeSenkrechte * normierterNormalenVektor.y
								+ antennaLinks.y * laengeWaagerechte);
				final Point punktRechts = new PrecisionPoint(
						startMittelPunkt.x + laengeSenkrechte * normierterNormalenVektor.x
								+ antennaRechts.x * laengeWaagerechte,
						startMittelPunkt.y + laengeSenkrechte * normierterNormalenVektor.y
								+ antennaRechts.y * laengeWaagerechte);

				punktListe.add(punktLinks);
				if (!punktLinks.equals(punktRechts)) {
					punktListe.add(punktRechts);
				}
			}
			inset -= step;
		}
	}
}
