/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.kollision.travers;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;

/**
 * Traversiert eine Menge von Punkten, die auf einem Quadrat liegen.
 *
 * @author BitCtrl Systems GmbH, thierfelder
 *
 */
public class QuadratTraverser extends PunktTraverser {

	/**
	 * Standardkonstruktor.
	 *
	 * @param mittelPunkt
	 *            der Mittelpunkt des Quadrats.
	 * @param seitenLaenge
	 *            die Grundseitenlaenge des Quadrats.
	 * @param anzahlPunkteSoll
	 *            Anzahl der Punkte, die hoechstens traversiert werden sollen.
	 */
	public QuadratTraverser(final Point mittelPunkt, final double seitenLaenge, final int anzahlPunkteSoll) {
		super(mittelPunkt);
		final double radius = seitenLaenge / 2.0;
		final double step = seitenLaenge / Math.sqrt(Math.min(anzahlPunkteSoll, seitenLaenge * seitenLaenge));
		for (double y = mittelPunkt.preciseY() + radius; y > mittelPunkt.preciseY() - radius; y -= step) {
			for (double x = mittelPunkt.preciseX() - radius; x < mittelPunkt.preciseX() + radius; x += step) {
				punktListe.add(new PrecisionPoint(x, y));
			}
		}
	}

}
