/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.dobj.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Bit Ctrl Do Model</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.BitCtrlDoModelImpl#getSystemObjekt <em>System Objekt</em>}</li>
 * </ul>
 *
 * @generated
 */
public class BitCtrlDoModelImpl<T extends SystemObjekt> extends DoModelImpl implements BitCtrlDoModel<T> {
	/**
	 * The cached value of the '{@link #getSystemObjekt() <em>System Objekt</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getSystemObjekt()
	 * @generated
	 * @ordered
	 */
	protected T systemObjekt;

	/**
	 * Dient als Flag, für den Abgleich von SystemObjekt und SystemObject.
	 * 
	 * @generated NOT
	 */
	private boolean internalSyc = false;

	/**
	 * @generated NOT
	 */
	private ObjektFactory objektFactory;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected BitCtrlDoModelImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DobjPackage.Literals.BIT_CTRL_DO_MODEL;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public T getSystemObjekt() {
		return systemObjekt;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public void setSystemObjekt(final T newSystemObjekt) {
		final T oldSystemObjekt = systemObjekt;
		systemObjekt = newSystemObjekt;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT,
					oldSystemObjekt, systemObjekt));
		}

		// SystemObject aktualisieren
		synchronized (this) {
			if (!internalSyc) {
				if (systemObjekt == null) {
					super.setSystemObject(null);
				} else {
					super.setSystemObject(systemObjekt.getSystemObject());
				}
			}
		}
	}

	/**
	 * @generated NOT
	 */
	@Override
	public void setSystemObject(final SystemObject systemObject) {
		super.setSystemObject(systemObject);

		// SystemObjekt aktualisieren
		synchronized (this) {
			internalSyc = true;
			if (systemObject != null) {
				setSystemObjekt((T) getObjektFactory().getModellobjekt(systemObject));
			} else {
				setSystemObjekt(null);
			}
			internalSyc = false;
		}
	}

	/**
	 * @generated NOT
	 */
	protected ObjektFactory getObjektFactory() {
		if (objektFactory != null) {
			return objektFactory;
		}

		return RahmenwerkService.getService().getObjektFactory();
	}

	/**
	 * Test Seam.
	 * 
	 * @generated NOT
	 */
	public void setObjektFactory(final ObjektFactory objektFactory) {
		this.objektFactory = objektFactory;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT:
			return getSystemObjekt();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT:
			setSystemObjekt((T) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT:
			setSystemObjekt((T) null);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT:
			return systemObjekt != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (systemObjekt: ");
		result.append(systemObjekt);
		result.append(')');
		return result.toString();
	}

} // BitCtrlDoModelImpl
