/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.dobj.model.impl;

import java.util.Collection;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;

import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import com.bitctrl.lib.eclipse.emf.eclipse.model.impl.NamedImpl;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;
import com.bitctrl.lib.eclipse.emf.gef.model.Located;

import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.dobj.model.Verbindungslinie;
import de.bsvrz.buv.plugin.dobj.model.util.DobjAdapterFactory;
import de.bsvrz.dav.daf.main.config.SystemObject;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Do Model</b></em>'.<!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.DoModelImpl#getLocation <em>Location</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.DoModelImpl#getKomponentenId <em>Komponenten Id</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.DoModelImpl#getDoTyp <em>Do Typ</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.DoModelImpl#getSystemObject <em>System Object</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.DoModelImpl#getRelativZu <em>Relativ Zu</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.DoModelImpl#getAbsoluteLocation <em>Absolute Location</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.DoModelImpl#getAusgehendeVerbindungen <em>Ausgehende Verbindungen</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.DoModelImpl#getEingehendeVerbindungen <em>Eingehende Verbindungen</em>}</li>
 * </ul>
 *
 * @generated
 */
public class DoModelImpl extends NamedImpl implements DoModel {
	/**
	 * The default value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected static final Point LOCATION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected Point location = LOCATION_EDEFAULT;

	/**
	 * The default value of the '{@link #getKomponentenId() <em>Komponenten Id</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getKomponentenId()
	 * @generated
	 * @ordered
	 */
	protected static final long KOMPONENTEN_ID_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getKomponentenId() <em>Komponenten Id</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getKomponentenId()
	 * @generated
	 * @ordered
	 */
	protected long komponentenId = KOMPONENTEN_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDoTyp() <em>Do Typ</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getDoTyp()
	 * @generated
	 * @ordered
	 */
	protected DoTyp doTyp;

	/**
	 * The default value of the '{@link #getSystemObject() <em>System Object</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getSystemObject()
	 * @generated
	 * @ordered
	 */
	protected static final SystemObject SYSTEM_OBJECT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSystemObject() <em>System Object</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getSystemObject()
	 * @generated
	 * @ordered
	 */
	protected SystemObject systemObject = SYSTEM_OBJECT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getRelativZu() <em>Relativ Zu</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getRelativZu()
	 * @generated
	 * @ordered
	 */
	protected DoModel relativZu;

	/**
	 * The default value of the '{@link #getAbsoluteLocation() <em>Absolute Location</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getAbsoluteLocation()
	 * @generated
	 * @ordered
	 */
	protected static final Point ABSOLUTE_LOCATION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAusgehendeVerbindungen() <em>Ausgehende Verbindungen</em>}' reference list.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #getAusgehendeVerbindungen()
	 * @generated
	 * @ordered
	 */
	protected EList<Verbindungslinie> ausgehendeVerbindungen;

	/**
	 * The cached value of the '{@link #getEingehendeVerbindungen() <em>Eingehende Verbindungen</em>}' reference list.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #getEingehendeVerbindungen()
	 * @generated
	 * @ordered
	 */
	protected EList<Verbindungslinie> eingehendeVerbindungen;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	protected DoModelImpl() {
		super();

		new DobjAdapterFactory().adapt(this, DoModel.class);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DobjPackage.Literals.DO_MODEL;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DoTyp getDoTyp() {
		if (doTyp != null && doTyp.eIsProxy()) {
			InternalEObject oldDoTyp = (InternalEObject) doTyp;
			doTyp = (DoTyp) eResolveProxy(oldDoTyp);
			if (doTyp != oldDoTyp) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DobjPackage.DO_MODEL__DO_TYP, oldDoTyp,
							doTyp));
			}
		}
		return doTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public DoTyp basicGetDoTyp() {
		return doTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDoTyp(DoTyp newDoTyp) {
		DoTyp oldDoTyp = doTyp;
		doTyp = newDoTyp;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DobjPackage.DO_MODEL__DO_TYP, oldDoTyp, doTyp));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Point getLocation() {
		return location;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLocation(Point newLocation) {
		Point oldLocation = location;
		location = newLocation;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DobjPackage.DO_MODEL__LOCATION, oldLocation,
					location));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public long getKomponentenId() {
		return komponentenId;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setKomponentenId(long newKomponentenId) {
		long oldKomponentenId = komponentenId;
		komponentenId = newKomponentenId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DobjPackage.DO_MODEL__KOMPONENTEN_ID,
					oldKomponentenId, komponentenId));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SystemObject getSystemObject() {
		return systemObject;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSystemObject(SystemObject newSystemObject) {
		SystemObject oldSystemObject = systemObject;
		systemObject = newSystemObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DobjPackage.DO_MODEL__SYSTEM_OBJECT, oldSystemObject,
					systemObject));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DoModel getRelativZu() {
		if (relativZu != null && relativZu.eIsProxy()) {
			InternalEObject oldRelativZu = (InternalEObject) relativZu;
			relativZu = (DoModel) eResolveProxy(oldRelativZu);
			if (relativZu != oldRelativZu) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DobjPackage.DO_MODEL__RELATIV_ZU,
							oldRelativZu, relativZu));
			}
		}
		return relativZu;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public DoModel basicGetRelativZu() {
		return relativZu;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRelativZu(DoModel newRelativZu) {
		DoModel oldRelativZu = relativZu;
		relativZu = newRelativZu;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DobjPackage.DO_MODEL__RELATIV_ZU, oldRelativZu,
					relativZu));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public Point getAbsoluteLocation() {
		// Ensure that you remove @generated or mark it @generated NOT

		final Point p = getLocation();

		if (p == null) {
			return null;
		}

		final DoModel relativModel = getRelativZu();
		if (relativModel == null) {
			return p;
		}

		return relativModel.getAbsoluteLocation().getCopy().translate(p);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Verbindungslinie> getAusgehendeVerbindungen() {
		if (ausgehendeVerbindungen == null) {
			ausgehendeVerbindungen = new EObjectWithInverseResolvingEList<Verbindungslinie>(Verbindungslinie.class,
					this, DobjPackage.DO_MODEL__AUSGEHENDE_VERBINDUNGEN, DobjPackage.VERBINDUNGSLINIE__QUELLE);
		}
		return ausgehendeVerbindungen;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Verbindungslinie> getEingehendeVerbindungen() {
		if (eingehendeVerbindungen == null) {
			eingehendeVerbindungen = new EObjectWithInverseResolvingEList<Verbindungslinie>(Verbindungslinie.class,
					this, DobjPackage.DO_MODEL__EINGEHENDE_VERBINDUNGEN, DobjPackage.VERBINDUNGSLINIE__ZIEL);
		}
		return eingehendeVerbindungen;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DobjPackage.DO_MODEL__AUSGEHENDE_VERBINDUNGEN:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getAusgehendeVerbindungen()).basicAdd(otherEnd,
					msgs);
		case DobjPackage.DO_MODEL__EINGEHENDE_VERBINDUNGEN:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getEingehendeVerbindungen()).basicAdd(otherEnd,
					msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DobjPackage.DO_MODEL__AUSGEHENDE_VERBINDUNGEN:
			return ((InternalEList<?>) getAusgehendeVerbindungen()).basicRemove(otherEnd, msgs);
		case DobjPackage.DO_MODEL__EINGEHENDE_VERBINDUNGEN:
			return ((InternalEList<?>) getEingehendeVerbindungen()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DobjPackage.DO_MODEL__LOCATION:
			return getLocation();
		case DobjPackage.DO_MODEL__KOMPONENTEN_ID:
			return getKomponentenId();
		case DobjPackage.DO_MODEL__DO_TYP:
			if (resolve)
				return getDoTyp();
			return basicGetDoTyp();
		case DobjPackage.DO_MODEL__SYSTEM_OBJECT:
			return getSystemObject();
		case DobjPackage.DO_MODEL__RELATIV_ZU:
			if (resolve)
				return getRelativZu();
			return basicGetRelativZu();
		case DobjPackage.DO_MODEL__ABSOLUTE_LOCATION:
			return getAbsoluteLocation();
		case DobjPackage.DO_MODEL__AUSGEHENDE_VERBINDUNGEN:
			return getAusgehendeVerbindungen();
		case DobjPackage.DO_MODEL__EINGEHENDE_VERBINDUNGEN:
			return getEingehendeVerbindungen();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DobjPackage.DO_MODEL__LOCATION:
			setLocation((Point) newValue);
			return;
		case DobjPackage.DO_MODEL__KOMPONENTEN_ID:
			setKomponentenId((Long) newValue);
			return;
		case DobjPackage.DO_MODEL__DO_TYP:
			setDoTyp((DoTyp) newValue);
			return;
		case DobjPackage.DO_MODEL__SYSTEM_OBJECT:
			setSystemObject((SystemObject) newValue);
			return;
		case DobjPackage.DO_MODEL__RELATIV_ZU:
			setRelativZu((DoModel) newValue);
			return;
		case DobjPackage.DO_MODEL__AUSGEHENDE_VERBINDUNGEN:
			getAusgehendeVerbindungen().clear();
			getAusgehendeVerbindungen().addAll((Collection<? extends Verbindungslinie>) newValue);
			return;
		case DobjPackage.DO_MODEL__EINGEHENDE_VERBINDUNGEN:
			getEingehendeVerbindungen().clear();
			getEingehendeVerbindungen().addAll((Collection<? extends Verbindungslinie>) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DobjPackage.DO_MODEL__LOCATION:
			setLocation(LOCATION_EDEFAULT);
			return;
		case DobjPackage.DO_MODEL__KOMPONENTEN_ID:
			setKomponentenId(KOMPONENTEN_ID_EDEFAULT);
			return;
		case DobjPackage.DO_MODEL__DO_TYP:
			setDoTyp((DoTyp) null);
			return;
		case DobjPackage.DO_MODEL__SYSTEM_OBJECT:
			setSystemObject(SYSTEM_OBJECT_EDEFAULT);
			return;
		case DobjPackage.DO_MODEL__RELATIV_ZU:
			setRelativZu((DoModel) null);
			return;
		case DobjPackage.DO_MODEL__AUSGEHENDE_VERBINDUNGEN:
			getAusgehendeVerbindungen().clear();
			return;
		case DobjPackage.DO_MODEL__EINGEHENDE_VERBINDUNGEN:
			getEingehendeVerbindungen().clear();
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DobjPackage.DO_MODEL__LOCATION:
			return LOCATION_EDEFAULT == null ? location != null : !LOCATION_EDEFAULT.equals(location);
		case DobjPackage.DO_MODEL__KOMPONENTEN_ID:
			return komponentenId != KOMPONENTEN_ID_EDEFAULT;
		case DobjPackage.DO_MODEL__DO_TYP:
			return doTyp != null;
		case DobjPackage.DO_MODEL__SYSTEM_OBJECT:
			return SYSTEM_OBJECT_EDEFAULT == null ? systemObject != null : !SYSTEM_OBJECT_EDEFAULT.equals(systemObject);
		case DobjPackage.DO_MODEL__RELATIV_ZU:
			return relativZu != null;
		case DobjPackage.DO_MODEL__ABSOLUTE_LOCATION:
			return ABSOLUTE_LOCATION_EDEFAULT == null ? getAbsoluteLocation() != null
					: !ABSOLUTE_LOCATION_EDEFAULT.equals(getAbsoluteLocation());
		case DobjPackage.DO_MODEL__AUSGEHENDE_VERBINDUNGEN:
			return ausgehendeVerbindungen != null && !ausgehendeVerbindungen.isEmpty();
		case DobjPackage.DO_MODEL__EINGEHENDE_VERBINDUNGEN:
			return eingehendeVerbindungen != null && !eingehendeVerbindungen.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == Located.class) {
			switch (derivedFeatureID) {
			case DobjPackage.DO_MODEL__LOCATION:
				return GefPackage.LOCATED__LOCATION;
			default:
				return -1;
			}
		}
		if (baseClass == DoKomponente.class) {
			switch (derivedFeatureID) {
			case DobjPackage.DO_MODEL__KOMPONENTEN_ID:
				return DobjPackage.DO_KOMPONENTE__KOMPONENTEN_ID;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == Located.class) {
			switch (baseFeatureID) {
			case GefPackage.LOCATED__LOCATION:
				return DobjPackage.DO_MODEL__LOCATION;
			default:
				return -1;
			}
		}
		if (baseClass == DoKomponente.class) {
			switch (baseFeatureID) {
			case DobjPackage.DO_KOMPONENTE__KOMPONENTEN_ID:
				return DobjPackage.DO_MODEL__KOMPONENTEN_ID;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (location: ");
		result.append(location);
		result.append(", komponentenId: ");
		result.append(komponentenId);
		result.append(", systemObject: ");
		result.append(systemObject);
		result.append(')');
		return result.toString();
	}

} // DoModelImpl
