/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EFont;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator;
import de.bsvrz.buv.plugin.dobj.model.DoText;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Do Text</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.DoTextImpl#isSelektierbar <em>Selektierbar</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.DoTextImpl#getText <em>Text</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.DoTextImpl#getFont <em>Font</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.DoTextImpl#isZoomVerhaltenFix <em>Zoom Verhalten Fix</em>}</li>
 * </ul>
 *
 * @generated
 */
public class DoTextImpl extends DoModelImpl implements DoText {
	/**
	 * The default value of the '{@link #isSelektierbar() <em>Selektierbar</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSelektierbar()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SELEKTIERBAR_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isSelektierbar() <em>Selektierbar</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSelektierbar()
	 * @generated
	 * @ordered
	 */
	protected boolean selektierbar = SELEKTIERBAR_EDEFAULT;

	/**
	 * The default value of the '{@link #getText() <em>Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getText()
	 * @generated
	 * @ordered
	 */
	protected static final String TEXT_EDEFAULT = "Text";

	/**
	 * The cached value of the '{@link #getText() <em>Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getText()
	 * @generated
	 * @ordered
	 */
	protected String text = TEXT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getFont() <em>Font</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFont()
	 * @generated
	 * @ordered
	 */
	protected EFont font;

	/**
	 * The default value of the '{@link #isZoomVerhaltenFix() <em>Zoom Verhalten Fix</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isZoomVerhaltenFix()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ZOOM_VERHALTEN_FIX_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isZoomVerhaltenFix() <em>Zoom Verhalten Fix</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isZoomVerhaltenFix()
	 * @generated
	 * @ordered
	 */
	protected boolean zoomVerhaltenFix = ZOOM_VERHALTEN_FIX_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DoTextImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DobjPackage.Literals.DO_TEXT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSelektierbar() {
		return selektierbar;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSelektierbar(boolean newSelektierbar) {
		boolean oldSelektierbar = selektierbar;
		selektierbar = newSelektierbar;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DobjPackage.DO_TEXT__SELEKTIERBAR, oldSelektierbar,
					selektierbar));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText() {
		return text;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setText(String newText) {
		String oldText = text;
		text = newText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DobjPackage.DO_TEXT__TEXT, oldText, text));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EFont getFont() {
		return font;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetFont(EFont newFont, NotificationChain msgs) {
		EFont oldFont = font;
		font = newFont;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DobjPackage.DO_TEXT__FONT,
					oldFont, newFont);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFont(EFont newFont) {
		if (newFont != font) {
			NotificationChain msgs = null;
			if (font != null)
				msgs = ((InternalEObject) font).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DobjPackage.DO_TEXT__FONT,
						null, msgs);
			if (newFont != null)
				msgs = ((InternalEObject) newFont).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DobjPackage.DO_TEXT__FONT,
						null, msgs);
			msgs = basicSetFont(newFont, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DobjPackage.DO_TEXT__FONT, newFont, newFont));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isZoomVerhaltenFix() {
		return zoomVerhaltenFix;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setZoomVerhaltenFix(boolean newZoomVerhaltenFix) {
		boolean oldZoomVerhaltenFix = zoomVerhaltenFix;
		zoomVerhaltenFix = newZoomVerhaltenFix;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DobjPackage.DO_TEXT__ZOOM_VERHALTEN_FIX,
					oldZoomVerhaltenFix, zoomVerhaltenFix));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DobjPackage.DO_TEXT__FONT:
			return basicSetFont(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DobjPackage.DO_TEXT__SELEKTIERBAR:
			return isSelektierbar();
		case DobjPackage.DO_TEXT__TEXT:
			return getText();
		case DobjPackage.DO_TEXT__FONT:
			return getFont();
		case DobjPackage.DO_TEXT__ZOOM_VERHALTEN_FIX:
			return isZoomVerhaltenFix();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DobjPackage.DO_TEXT__SELEKTIERBAR:
			setSelektierbar((Boolean) newValue);
			return;
		case DobjPackage.DO_TEXT__TEXT:
			setText((String) newValue);
			return;
		case DobjPackage.DO_TEXT__FONT:
			setFont((EFont) newValue);
			return;
		case DobjPackage.DO_TEXT__ZOOM_VERHALTEN_FIX:
			setZoomVerhaltenFix((Boolean) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DobjPackage.DO_TEXT__SELEKTIERBAR:
			setSelektierbar(SELEKTIERBAR_EDEFAULT);
			return;
		case DobjPackage.DO_TEXT__TEXT:
			setText(TEXT_EDEFAULT);
			return;
		case DobjPackage.DO_TEXT__FONT:
			setFont((EFont) null);
			return;
		case DobjPackage.DO_TEXT__ZOOM_VERHALTEN_FIX:
			setZoomVerhaltenFix(ZOOM_VERHALTEN_FIX_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DobjPackage.DO_TEXT__SELEKTIERBAR:
			return selektierbar != SELEKTIERBAR_EDEFAULT;
		case DobjPackage.DO_TEXT__TEXT:
			return TEXT_EDEFAULT == null ? text != null : !TEXT_EDEFAULT.equals(text);
		case DobjPackage.DO_TEXT__FONT:
			return font != null;
		case DobjPackage.DO_TEXT__ZOOM_VERHALTEN_FIX:
			return zoomVerhaltenFix != ZOOM_VERHALTEN_FIX_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == SelektierbarDecorator.class) {
			switch (derivedFeatureID) {
			case DobjPackage.DO_TEXT__SELEKTIERBAR:
				return DobjDecoratorPackage.SELEKTIERBAR_DECORATOR__SELEKTIERBAR;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == SelektierbarDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.SELEKTIERBAR_DECORATOR__SELEKTIERBAR:
				return DobjPackage.DO_TEXT__SELEKTIERBAR;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (selektierbar: ");
		result.append(selektierbar);
		result.append(", text: ");
		result.append(text);
		result.append(", ZoomVerhaltenFix: ");
		result.append(zoomVerhaltenFix);
		result.append(')');
		return result.toString();
	}

} //DoTextImpl
