/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.dobj.model.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.impl.EPackageImpl;

import com.bitctrl.lib.eclipse.emf.dav.model.DavPackage;
import com.bitctrl.lib.eclipse.emf.davbitctrl.model.DavbitctrlPackage;
import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipsePackage;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel;
import de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp;
import de.bsvrz.buv.plugin.dobj.model.DoBild;
import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.model.DoKompositum;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoText;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.dobj.model.DobjFactory;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.dobj.model.Verbindungslinie;
import de.bsvrz.buv.plugin.dobj.model.ZoomStufe;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Package</b>. <!--
 * end-user-doc -->
 * @generated
 */
public class DobjPackageImpl extends EPackageImpl implements DobjPackage {
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass doModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass doTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass configuratedDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass bitCtrlDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass doKompositumEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass doKomponenteEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass zoomStufeEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass doBildEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass doTextEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass verbindungslinieEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the
	 * package package URI value.
	 * <p>
	 * Note: the correct way to create the package is via the static factory
	 * method {@link #init init()}, which also performs initialization of the
	 * package, or returns the registered package, if one already exists. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see de.bsvrz.buv.plugin.dobj.model.DobjPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private DobjPackageImpl() {
		super(eNS_URI, DobjFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model,
	 * and for any others upon which it depends.
	 * 
	 * <p>
	 * This method is used to initialize {@link DobjPackage#eINSTANCE} when that
	 * field is accessed. Clients should not invoke it directly. Instead, they
	 * should simply access that field to obtain the package. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static DobjPackage init() {
		if (isInited)
			return (DobjPackage) EPackage.Registry.INSTANCE.getEPackage(DobjPackage.eNS_URI);

		// Obtain or create and register package
		DobjPackageImpl theDobjPackage = (DobjPackageImpl) (EPackage.Registry.INSTANCE
				.get(eNS_URI) instanceof DobjPackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI)
						: new DobjPackageImpl());

		isInited = true;

		// Initialize simple dependencies
		DavPackage.eINSTANCE.eClass();
		DavbitctrlPackage.eINSTANCE.eClass();
		DobjDecoratorPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theDobjPackage.createPackageContents();

		// Initialize created meta-data
		theDobjPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theDobjPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(DobjPackage.eNS_URI, theDobjPackage);
		return theDobjPackage;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDoModel() {
		return doModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDoModel_DoTyp() {
		return (EReference) doModelEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDoModel_SystemObject() {
		return (EAttribute) doModelEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDoModel_RelativZu() {
		return (EReference) doModelEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDoModel_AbsoluteLocation() {
		return (EAttribute) doModelEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDoModel_AusgehendeVerbindungen() {
		return (EReference) doModelEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDoModel_EingehendeVerbindungen() {
		return (EReference) doModelEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDoTyp() {
		return doTypEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDoTyp_Id() {
		return (EAttribute) doTypEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDoTyp_Description() {
		return (EAttribute) doTypEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDoTyp_SystemObjectType() {
		return (EAttribute) doTypEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDoTyp_Icon() {
		return (EAttribute) doTypEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDoTyp_ZoomStufe() {
		return (EReference) doTypEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConfiguratedDoTyp() {
		return configuratedDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getConfiguratedDoTyp_ConfigurationElement() {
		return (EAttribute) configuratedDoTypEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getConfiguratedDoTyp_NurMassstaeblicheDarstellung() {
		return (EAttribute) configuratedDoTypEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBitCtrlDoModel() {
		return bitCtrlDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getBitCtrlDoModel_SystemObjekt() {
		return (EAttribute) bitCtrlDoModelEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDoKompositum() {
		return doKompositumEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDoKompositum_Komponenten() {
		return (EReference) doKompositumEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDoKomponente() {
		return doKomponenteEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDoKomponente_KomponentenId() {
		return (EAttribute) doKomponenteEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getZoomStufe() {
		return zoomStufeEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getZoomStufe_VonLevel() {
		return (EAttribute) zoomStufeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getZoomStufe_BisLevel() {
		return (EAttribute) zoomStufeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDoBild() {
		return doBildEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDoBild_Bild() {
		return (EAttribute) doBildEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDoText() {
		return doTextEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDoText_Text() {
		return (EAttribute) doTextEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDoText_Font() {
		return (EReference) doTextEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDoText_ZoomVerhaltenFix() {
		return (EAttribute) doTextEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getVerbindungslinie() {
		return verbindungslinieEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVerbindungslinie_Quelle() {
		return (EReference) verbindungslinieEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVerbindungslinie_Ziel() {
		return (EReference) verbindungslinieEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public DobjFactory getDobjFactory() {
		return (DobjFactory) getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated)
			return;
		isCreated = true;

		// Create classes and their features
		doModelEClass = createEClass(DO_MODEL);
		createEReference(doModelEClass, DO_MODEL__DO_TYP);
		createEAttribute(doModelEClass, DO_MODEL__SYSTEM_OBJECT);
		createEReference(doModelEClass, DO_MODEL__RELATIV_ZU);
		createEAttribute(doModelEClass, DO_MODEL__ABSOLUTE_LOCATION);
		createEReference(doModelEClass, DO_MODEL__AUSGEHENDE_VERBINDUNGEN);
		createEReference(doModelEClass, DO_MODEL__EINGEHENDE_VERBINDUNGEN);

		doTypEClass = createEClass(DO_TYP);
		createEAttribute(doTypEClass, DO_TYP__ID);
		createEAttribute(doTypEClass, DO_TYP__DESCRIPTION);
		createEAttribute(doTypEClass, DO_TYP__SYSTEM_OBJECT_TYPE);
		createEAttribute(doTypEClass, DO_TYP__ICON);
		createEReference(doTypEClass, DO_TYP__ZOOM_STUFE);

		configuratedDoTypEClass = createEClass(CONFIGURATED_DO_TYP);
		createEAttribute(configuratedDoTypEClass, CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT);
		createEAttribute(configuratedDoTypEClass, CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG);

		bitCtrlDoModelEClass = createEClass(BIT_CTRL_DO_MODEL);
		createEAttribute(bitCtrlDoModelEClass, BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT);

		doKompositumEClass = createEClass(DO_KOMPOSITUM);
		createEReference(doKompositumEClass, DO_KOMPOSITUM__KOMPONENTEN);

		doKomponenteEClass = createEClass(DO_KOMPONENTE);
		createEAttribute(doKomponenteEClass, DO_KOMPONENTE__KOMPONENTEN_ID);

		zoomStufeEClass = createEClass(ZOOM_STUFE);
		createEAttribute(zoomStufeEClass, ZOOM_STUFE__VON_LEVEL);
		createEAttribute(zoomStufeEClass, ZOOM_STUFE__BIS_LEVEL);

		doBildEClass = createEClass(DO_BILD);
		createEAttribute(doBildEClass, DO_BILD__BILD);

		doTextEClass = createEClass(DO_TEXT);
		createEAttribute(doTextEClass, DO_TEXT__TEXT);
		createEReference(doTextEClass, DO_TEXT__FONT);
		createEAttribute(doTextEClass, DO_TEXT__ZOOM_VERHALTEN_FIX);

		verbindungslinieEClass = createEClass(VERBINDUNGSLINIE);
		createEReference(verbindungslinieEClass, VERBINDUNGSLINIE__QUELLE);
		createEReference(verbindungslinieEClass, VERBINDUNGSLINIE__ZIEL);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model. This
	 * method is guarded to have no affect on any invocation but its first. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized)
			return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		EclipsePackage theEclipsePackage = (EclipsePackage) EPackage.Registry.INSTANCE
				.getEPackage(EclipsePackage.eNS_URI);
		GefPackage theGefPackage = (GefPackage) EPackage.Registry.INSTANCE.getEPackage(GefPackage.eNS_URI);
		DavPackage theDavPackage = (DavPackage) EPackage.Registry.INSTANCE.getEPackage(DavPackage.eNS_URI);
		DavbitctrlPackage theDavbitctrlPackage = (DavbitctrlPackage) EPackage.Registry.INSTANCE
				.getEPackage(DavbitctrlPackage.eNS_URI);
		DobjDecoratorPackage theDobjDecoratorPackage = (DobjDecoratorPackage) EPackage.Registry.INSTANCE
				.getEPackage(DobjDecoratorPackage.eNS_URI);

		// Create type parameters
		ETypeParameter bitCtrlDoModelEClass_T = addETypeParameter(bitCtrlDoModelEClass, "T");
		ETypeParameter doKompositumEClass_T = addETypeParameter(doKompositumEClass, "T");

		// Set bounds for type parameters
		EGenericType g1 = createEGenericType(theDavbitctrlPackage.getSystemObjekt());
		bitCtrlDoModelEClass_T.getEBounds().add(g1);
		g1 = createEGenericType(this.getDoKomponente());
		doKompositumEClass_T.getEBounds().add(g1);

		// Add supertypes to classes
		doModelEClass.getESuperTypes().add(theEclipsePackage.getNamed());
		doModelEClass.getESuperTypes().add(theGefPackage.getLocated());
		doModelEClass.getESuperTypes().add(this.getDoKomponente());
		doTypEClass.getESuperTypes().add(theEclipsePackage.getNamed());
		configuratedDoTypEClass.getESuperTypes().add(this.getDoTyp());
		bitCtrlDoModelEClass.getESuperTypes().add(this.getDoModel());
		doKompositumEClass.getESuperTypes().add(this.getDoKomponente());
		doBildEClass.getESuperTypes().add(this.getDoModel());
		doBildEClass.getESuperTypes().add(theGefPackage.getSized());
		doBildEClass.getESuperTypes().add(theGefPackage.getLocated());
		doBildEClass.getESuperTypes().add(theDobjDecoratorPackage.getSelektierbarDecorator());
		doBildEClass.getESuperTypes().add(theDobjDecoratorPackage.getZoomVerhaltenFixDecorator());
		doTextEClass.getESuperTypes().add(this.getDoModel());
		doTextEClass.getESuperTypes().add(theGefPackage.getLocated());
		doTextEClass.getESuperTypes().add(theDobjDecoratorPackage.getSelektierbarDecorator());

		// Initialize classes and features; add operations and parameters
		initEClass(doModelEClass, DoModel.class, "DoModel", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getDoModel_DoTyp(), this.getDoTyp(), null, "doTyp", null, 1, 1, DoModel.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getDoModel_SystemObject(), theDavPackage.getSystemObject(), "systemObject", null, 0, 1,
				DoModel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEReference(getDoModel_RelativZu(), this.getDoModel(), null, "relativZu", null, 0, 1, DoModel.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDoModel_AbsoluteLocation(), theGefPackage.getPoint(), "absoluteLocation", null, 0, 1,
				DoModel.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, IS_DERIVED,
				IS_ORDERED);
		initEReference(getDoModel_AusgehendeVerbindungen(), this.getVerbindungslinie(),
				this.getVerbindungslinie_Quelle(), "ausgehendeVerbindungen", null, 0, -1, DoModel.class, IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEReference(getDoModel_EingehendeVerbindungen(), this.getVerbindungslinie(), this.getVerbindungslinie_Ziel(),
				"eingehendeVerbindungen", null, 0, -1, DoModel.class, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				!IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(doTypEClass, DoTyp.class, "DoTyp", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getDoTyp_Id(), ecorePackage.getEString(), "id", null, 0, 1, DoTyp.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDoTyp_Description(), ecorePackage.getEString(), "description", null, 0, 1, DoTyp.class,
				IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDoTyp_SystemObjectType(), theDavPackage.getSystemObjectType(), "systemObjectType", null, 0, 1,
				DoTyp.class, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getDoTyp_Icon(), theEclipsePackage.getImageDescriptor(), "icon", null, 0, 1, DoTyp.class,
				IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDoTyp_ZoomStufe(), this.getZoomStufe(), null, "zoomStufe", null, 0, 1, DoTyp.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(doTypEClass, this.getDoModel(), "createModel", 0, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(doTypEClass, theGefPackage.getGraphicalEditPart(), "createController", 0, 1, IS_UNIQUE,
				IS_ORDERED);

		initEClass(configuratedDoTypEClass, ConfiguratedDoTyp.class, "ConfiguratedDoTyp", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getConfiguratedDoTyp_ConfigurationElement(), theEclipsePackage.getIConfigurationElement(),
				"configurationElement", null, 1, 1, ConfiguratedDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				!IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getConfiguratedDoTyp_NurMassstaeblicheDarstellung(), ecorePackage.getEBoolean(),
				"nurMassstaeblicheDarstellung", "false", 0, 1, ConfiguratedDoTyp.class, IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(bitCtrlDoModelEClass, BitCtrlDoModel.class, "BitCtrlDoModel", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		g1 = createEGenericType(bitCtrlDoModelEClass_T);
		initEAttribute(getBitCtrlDoModel_SystemObjekt(), g1, "systemObjekt", "", 0, 1, BitCtrlDoModel.class,
				IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(doKompositumEClass, DoKompositum.class, "DoKompositum", IS_ABSTRACT, IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		g1 = createEGenericType(doKompositumEClass_T);
		initEReference(getDoKompositum_Komponenten(), g1, null, "komponenten", null, 0, -1, DoKompositum.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(doKomponenteEClass, DoKomponente.class, "DoKomponente", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getDoKomponente_KomponentenId(), ecorePackage.getELong(), "komponentenId", "0", 0, 1,
				DoKomponente.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(zoomStufeEClass, ZoomStufe.class, "ZoomStufe", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getZoomStufe_VonLevel(), ecorePackage.getEInt(), "vonLevel", null, 0, 1, ZoomStufe.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getZoomStufe_BisLevel(), ecorePackage.getEInt(), "bisLevel", null, 0, 1, ZoomStufe.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(doBildEClass, DoBild.class, "DoBild", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getDoBild_Bild(), theDavbitctrlPackage.getBild(), "bild", null, 0, 1, DoBild.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(doTextEClass, DoText.class, "DoText", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getDoText_Text(), ecorePackage.getEString(), "text", "Text", 0, 1, DoText.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDoText_Font(), theEclipsePackage.getEFont(), null, "font", null, 0, 1, DoText.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDoText_ZoomVerhaltenFix(), ecorePackage.getEBoolean(), "ZoomVerhaltenFix", "true", 0, 1,
				DoText.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(verbindungslinieEClass, Verbindungslinie.class, "Verbindungslinie", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEReference(getVerbindungslinie_Quelle(), this.getDoModel(), this.getDoModel_AusgehendeVerbindungen(),
				"quelle", null, 1, 1, Verbindungslinie.class, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE,
				IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getVerbindungslinie_Ziel(), this.getDoModel(), this.getDoModel_EingehendeVerbindungen(), "ziel",
				null, 1, 1, Verbindungslinie.class, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE,
				IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Create resource
		createResource(eNS_URI);
	}

} // DobjPackageImpl
