/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.properties;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;

/**
 * Basisklasse für Property Sections im Plug-in.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 * @param <T>
 */
public abstract class AbstractSection<T extends EObject> extends AbstractPropertySection {

	/** Überschreibt die Standardbreite, da hier die Namen länger sind. */
	protected static final int STANDARD_LABEL_WIDTH = 170;

	private final Adapter adapter = new SectionAdapter();
	private T element;

	@Override
	public void setInput(final IWorkbenchPart part, final ISelection selection) {
		super.setInput(part, selection);

		final Object input = ((IStructuredSelection) selection).getFirstElement();

		Assert.isTrue(input instanceof EditPart);
		final Object model = ((EditPart) input).getModel();
		Assert.isTrue(model instanceof EObject);

		if (element != null) {
			element.eAdapters().remove(adapter);
		}
		element = (T) model;
		element.eAdapters().add(adapter);
	}

	@Override
	public void dispose() {
		if (getElement() != null) {
			getElement().eAdapters().remove(adapter);
		}
	}

	/**
	 * Gibt das zu bearbeitende Objekt zurück.
	 *
	 * @return das zu bearbeitende Objekt.
	 */
	protected T getElement() {
		return element;
	}

	/**
	 * Gibt den Command Stack zurück.
	 *
	 * @return der Command Stack, niemals <code>null</code>.
	 */
	protected CommandStack getCommandStack() {
		CommandStack stack = getPart().getAdapter(CommandStack.class);
		if (stack == null) {
			final IContributedContentsView contributedView = getPart().getAdapter(IContributedContentsView.class);
			stack = contributedView.getContributingPart().getAdapter(CommandStack.class);
		}

		Assert.isNotNull(stack, "Der Command Stack ist nicht verfügbar.");
		return stack;
	}

	private class SectionAdapter extends AdapterImpl {

		@Override
		public void notifyChanged(final Notification notification) {
			final int type = notification.getEventType();

			switch (type) {
			case Notification.SET:
			case Notification.UNSET:
			case Notification.ADD:
			case Notification.ADD_MANY:
			case Notification.MOVE:
			case Notification.REMOVE:
			case Notification.REMOVE_MANY:
				refresh();
				break;
			}
		}

	}

}
