/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.properties;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;

import de.bsvrz.buv.plugin.dobj.model.DoBild;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.dobj.util.BildManager;

/**
 * @author BitCtrl Systems GmbH 2010, Christian Hoesel
 */
public class BildEigenschaftenPropertySection extends AbstractSection<DoBild> {

	private final ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener() {

		@Override
		public void selectionChanged(final SelectionChangedEvent event) {
			final EStructuralFeature feature;
			final Object value;

			if (event.getSelectionProvider() == bildComboViewer) {
				feature = DobjPackage.Literals.DO_BILD__BILD;

				if (!event.getSelection().isEmpty()) {
					value = ((StructuredSelection) event.getSelection()).getFirstElement();
				} else {
					value = null;
				}
			} else {
				return;
			}

			final SetCommand cmd = new SetCommand(getElement(), feature, value);
			getCommandStack().execute(cmd);
		}
	};
	private ComboViewer bildComboViewer;

	/*
	 * (non-Javadoc)
	 *
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#
	 * createControls (org.eclipse.swt.widgets.Composite,
	 * org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage)
	 */
	@Override
	public void createControls(final Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createBildQuelle(container);
	}

	private void createBildQuelle(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		FormData data;

		final CLabel label = factory.createCLabel(parent, "Bild :");
		data = new FormData();
		data.left = new FormAttachment(parent, 0);
		data.right = new FormAttachment(0, 2 * STANDARD_LABEL_WIDTH);
		data.top = new FormAttachment(parent, 0, SWT.CENTER);
		label.setLayoutData(data);
		factory.adapt(label, true, true);

		bildComboViewer = new ComboViewer(parent, SWT.READ_ONLY);
		bildComboViewer.setContentProvider(new ArrayContentProvider());
		data = new FormData();
		data.left = new FormAttachment(label, ITabbedPropertyConstants.HSPACE);
		data.right = new FormAttachment(100, -ITabbedPropertyConstants.HSPACE);
		data.top = new FormAttachment(parent, 0, SWT.CENTER);
		bildComboViewer.getControl().setLayoutData(data);
		bildComboViewer.setInput(BildManager.INSTANCE.getBilder());
		bildComboViewer.addSelectionChangedListener(selectionChangedListener);

	}

	@Override
	public void refresh() {
		final IStructuredSelection isel = (IStructuredSelection) bildComboViewer.getSelection();
		if (getElement() != null && getElement().getBild() != null
				&& !getElement().getBild().equals(isel.getFirstElement())) {
			bildComboViewer.setSelection(new StructuredSelection(getElement().getBild()));
		}
		super.refresh();
	}
}
