/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.properties;

import static org.eclipse.swt.SWT.CENTER;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.HSPACE;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EFont;
import com.bitctrl.lib.eclipse.emf.eclipse.model.impl.EclipseFactoryImpl;
import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;

import de.bsvrz.buv.plugin.dobj.model.DoText;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;

/**
 * @author BitCtrl Systems GmbH, Hoesel
 *
 */
public class TextEigenschaftenPropertySection extends AbstractSection<DoText> {

	private Text textText;
	private Label fontLabel;
	private Button zoomVerhaltenFixCheckBox;

	@Override
	public void createControls(final Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createText(container);
		createFont(container);
		createZoomverhaltenFix(container);
	}

	private void createText(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		// Widgets anlegen
		final Label label = factory.createLabel(parent, "Text:");
		textText = factory.createText(parent, "", SWT.MULTI | SWT.BORDER | SWT.V_SCROLL);

		// Layout festlegen
		final FormData textData = new FormData();
		textData.left = new FormAttachment(label, HSPACE);
		textData.right = new FormAttachment(100, -ITabbedPropertyConstants.HMARGIN);
		textData.top = new FormAttachment(0, ITabbedPropertyConstants.VMARGIN);
		textData.height = 100;
		textText.setLayoutData(textData);
		final FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(zoomVerhaltenFixCheckBox, 0, CENTER);
		label.setLayoutData(labelData);

		// Listener anmelden
		textText.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(final ModifyEvent e) {
				EStructuralFeature feature;
				Object value;

				feature = DobjPackage.Literals.DO_TEXT__TEXT;
				value = textText.getText();

				final SetCommand cmd = new SetCommand(getElement(), feature, value);
				getCommandStack().execute(cmd);
			}
		});

	}

	private void createFont(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		// Widgets anlegen
		final Label label = factory.createLabel(parent, "Schriftart:");
		fontLabel = factory.createLabel(parent, "");
		final Button changeButton = factory.createButton(parent, "Ändern", SWT.PUSH);

		// Layout festlegen
		final FormData fontLabelData = new FormData();
		fontLabelData.left = new FormAttachment(label, HSPACE);
		fontLabelData.right = new FormAttachment(changeButton, ITabbedPropertyConstants.HSPACE);
		fontLabelData.top = new FormAttachment(textText, ITabbedPropertyConstants.VSPACE);
		fontLabel.setLayoutData(fontLabelData);
		final FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(fontLabel, 0, SWT.CENTER);
		label.setLayoutData(labelData);
		final FormData changeButtonData = new FormData();
		changeButtonData.left = new FormAttachment(100, -STANDARD_LABEL_WIDTH);
		changeButtonData.right = new FormAttachment(100, -ITabbedPropertyConstants.HMARGIN);
		changeButtonData.top = new FormAttachment(fontLabel, 0, SWT.CENTER);
		changeButton.setLayoutData(changeButtonData);

		// Listener anmelden
		changeButton.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				EStructuralFeature feature;

				feature = DobjPackage.Literals.DO_TEXT__FONT;

				final FontDialog d = new FontDialog(changeButton.getShell());
				final FontData fd = d.open();

				final EFont font = EclipseFactoryImpl.init().createEFont();
				font.setFontData(fd);

				fontLabel.setText(fd.toString());

				final SetCommand cmd = new SetCommand(getElement(), feature, font);
				getCommandStack().execute(cmd);
			}

		});
	}

	private void createZoomverhaltenFix(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		// Widgets anlegen
		final Label label = factory.createLabel(parent, "Zoomverhalten:");
		zoomVerhaltenFixCheckBox = factory.createButton(parent, "fix (nicht mitzoomen)", SWT.CHECK);

		// Layout festlegen
		final FormData checkBoxData = new FormData();
		checkBoxData.left = new FormAttachment(label, HSPACE);
		checkBoxData.width = 150;
		checkBoxData.top = new FormAttachment(fontLabel, ITabbedPropertyConstants.VSPACE);
		zoomVerhaltenFixCheckBox.setLayoutData(checkBoxData);
		final FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(zoomVerhaltenFixCheckBox, 0, CENTER);
		label.setLayoutData(labelData);

		// Listener anmelden
		zoomVerhaltenFixCheckBox.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final EAttribute feature = DobjPackage.Literals.DO_TEXT__ZOOM_VERHALTEN_FIX;
				final boolean value = zoomVerhaltenFixCheckBox.getSelection();

				final SetCommand cmd = new SetCommand(getElement(), feature, value);
				getCommandStack().execute(cmd);
			}

		});
	}

	@Override
	public void refresh() {
		super.refresh();

		final String text = getElement().getText();
		if (text != null && !text.equals(textText.getText())) {
			textText.setText(text);
		}

		final EFont font = getElement().getFont();
		if (font != null) {
			fontLabel.setText(font.getFontData().toString());
		} else {
			fontLabel.setText("");
		}

		final boolean zoomVerhaltenFix = getElement().isZoomVerhaltenFix();
		zoomVerhaltenFixCheckBox.setSelection(zoomVerhaltenFix);
	}

}
