/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.requests;

/**
 * Enthält die Konstanten der GEF-Requests des Plug-ins.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public interface DobjRequestConstants {

	/**
	 * Request zum Ein- und Ausschalten der Verbindungslinie eines verschobenen
	 * Objekts zu seiner Originalposition.
	 */
	String REQ_VERBINDUNGSLINIE = "Verbindungslinie";

	/**
	 * Request zum Ein- und Ausschalten des Filters zum Anzeigen aller gueltigen
	 * Baustellen.
	 */
	String REQ_BAUSTELLE_GUELTIG = "Baustellegueltig";

	/**
	 * Request zum umschalten zwischen Online- und Offlinemodus von Edit Parts.
	 */
	String REQ_ONLINE = "Online";

	/*
	 * TODO Flag (EMF-Property) ob der Antikollisionsalgorithmus verwendet
	 * werden sollte vom Netz-Plug-in ins DObj-Plug-in verschieben.
	 *
	 * XXX Sollte das Flag nicht Antikollisionsalgorithmus heißen? Schließlich
	 * sollen Kollisionen vermieden werden.
	 */
	String REQ_KOLLISIONSALGORITHMUS = "Kollisionsalgorithmus";

}
