/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.tools;

import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Tool;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.AbstractTool;

/**
 * Kann als Basisklasse für {@link Tool}s dienen, die für einen
 * {@link GraphicalViewer} gedacht sind.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public abstract class BaseTool extends AbstractTool {

	/**
	 * Gibt den {@link ZoomManager} des {@link EditPartViewer} zurück.
	 *
	 * @return der Zoom Manager oder <code>null</code>, wenn es keinen gibt.
	 */
	protected ZoomManager getZoomManager() {
		return (ZoomManager) getCurrentViewer().getProperty(ZoomManager.class.toString());
	}

	/**
	 * Prüft, ob der aktuelle {@link EditPartViewer} ein {@link GraphicalViewer}
	 * ist.
	 */
	protected boolean isGraphicalViewer() {
		return getCurrentViewer() instanceof GraphicalViewer;
	}

	/**
	 * Prüft, ob der übergebene Viewer ein {@link GraphicalViewer} ist.
	 */
	@Override
	protected boolean isViewerImportant(final EditPartViewer viewer) {
		return viewer instanceof GraphicalViewer;
	}

}