/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.util;

import java.util.EventObject;

import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.Bild;

/**
 * Dieses Event wird verteilt, wenn sich die in der Konfiguration des
 * Datenverteilers vorhandenen {@link Bild}er geändert haben.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class BildEvent extends EventObject {

	private static final long serialVersionUID = 1L;

	private final Bild bild;

	/**
	 * Initialisiert das Event.
	 *
	 * @param source
	 *            die Quelle des Events.
	 * @param bild
	 *            das Bild, das sich geändert hat.
	 */
	public BildEvent(final BildManager source, final Bild bild) {
		super(source);
		this.bild = bild;
	}

	/**
	 * Das Bild, das sich geändert zurück.
	 *
	 * @return das geändert Bild.
	 */
	public Bild getBild() {
		return bild;
	}

}
