/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.util;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;

import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;

/**
 * Stellt gemeinsam nutzbare Cursor zur Verfügung.
 *
 * @author BitCtrl Systems GmbH, Schumann
 *
 */
public enum DobjCursors {

	/** Der Cursor zum Hineinzoomen in eine Rechteckauswahl. */
	ZoomIn("icons/16x16/actions/zoom-in.gif");

	private final Cursor cursor;

	private DobjCursors(final String imagePath) {
		final ImageDescriptor imageDescriptor = DObjPlugin.getDefault().getImageDescriptor(imagePath);
		if (imageDescriptor != null) {
			final Image image = imageDescriptor.createImage();
			cursor = new Cursor(null, image.getImageData(), 0, 0);
			image.dispose();
		} else {
			cursor = null;
			final String message = "Datei nicht gefunden: " + imagePath;
			DObjPlugin.getDefault().getLogger().error(message);
		}
	}

	/**
	 * Gibt den gemeinsamen Cursor zurück.
	 */
	public Cursor getCursor() {
		return cursor;
	}

}
