/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.util;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;

/**
 * Eine Projektion wird für die Darstellung benötigt, um zwischen Welt und
 * Modellkorrdinaten umzurechnen. Modellkoordinaten sind immer die
 * Bildschirmkoordinaten in Pixel, mit denen GEF/Draw2d arbeitet.
 * Weltkoordinaten können z.&nbsp;B. WGS-84-Koordinaten sein.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public interface Projektion {

	Projektion NULL = new Projektion() {

		@Override
		public Point umrechnenWeltNachModel(final Point welt) {
			return new PrecisionPoint(welt);
		}

		@Override
		public Point umrechnenModellNachWelt(final Point modell) {
			return new PrecisionPoint(modell);
		}
	};

	/**
	 * Rechnet einen Punkt in Weltkoordinaten in die entsprechenden
	 * Modellkoordinaten um.
	 *
	 * @param welt
	 *            ein Punkt in Weltkoordinaten.
	 * @return der entsprechenden Punkt in Modellkoordinaten.
	 */
	Point umrechnenWeltNachModel(Point welt);

	/**
	 * Rechnet einen Punkt in Modellkoordinaten in die entsprechenden
	 * Weltkoordinaten um.
	 *
	 * @param modell
	 *            ein Punkt in Modellkoordinaten.
	 * @return der entsprechenden Punkt in Weltkoordinaten.
	 */
	Point umrechnenModellNachWelt(Point modell);

}
