/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.vektor;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;

class ParallelKomplex {

	private final LineareFunktion f;

	private final Point p1, p2;

	private final Point p1Strich, p2Strich;

	private final Vektor2D v;

	private Point pSchnittMitVorgaenger;

	private Point pSchnittMitNachfolger;

	ParallelKomplex(final Point p1, final Point p2, final double a) {
		final double aAbsolut = Math.abs(a);
		this.p1 = p1;
		this.p2 = p2;
		v = new Vektor2D(p1, p2);

		final boolean rechtenNormalenVektor = a > 0;
		final Vektor2D normalenVektorNormiert;
		if (rechtenNormalenVektor) {
			normalenVektorNormiert = v.getNormalenVektorRechts().getVektorNormiert();
		} else {
			normalenVektorNormiert = v.getNormalenVektorLinks().getVektorNormiert();
		}

		p1Strich = new PrecisionPoint(p1.x + aAbsolut * normalenVektorNormiert.x,
				p1.y + aAbsolut * normalenVektorNormiert.y);
		p2Strich = new PrecisionPoint(p2.x + aAbsolut * normalenVektorNormiert.x,
				p2.y + aAbsolut * normalenVektorNormiert.y);
		f = new LineareFunktion(p1Strich, p2Strich);
	}

	final Point calcSchnittPunktMitVorgaenger(final ParallelKomplex vorgaenger) {
		if (vorgaenger == null) {
			pSchnittMitVorgaenger = p1Strich;
		} else {
			pSchnittMitVorgaenger = LinAlgUtil.getSchnittpunkt(vorgaenger.getF(), f);
		}
		return pSchnittMitVorgaenger;
	}

	final Point calcSchnittPunktMitNachfolger(final ParallelKomplex nachfolger) {
		if (nachfolger == null) {
			pSchnittMitNachfolger = p2Strich;
		} else {
			pSchnittMitNachfolger = LinAlgUtil.getSchnittpunkt(f, nachfolger.getF());
		}
		return pSchnittMitNachfolger;
	}

	final Point getpSchnittMitVorgaenger() {
		return pSchnittMitVorgaenger;
	}

	final Point getpSchnittMitNachfolger() {
		return pSchnittMitNachfolger;
	}

	final LineareFunktion getF() {
		return f;
	}

	final Point getP1() {
		return p1;
	}

	final Point getP2() {
		return p2;
	}

	final Point getP1Strich() {
		return p1Strich;
	}

	final Point getP2Strich() {
		return p2Strich;
	}

	final Vektor2D getV() {
		return v;
	}

}
