/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.editparts;

import de.bsvrz.dav.daf.main.Data;

/**
 * Datensatz der an einen Decorator übergeben wird. Der Datensatz enthält
 * potentiell:
 * <ul>
 * <li>vom Datenverteiler empfangene Daten</li>
 * <li>einen Textwert</li>
 * <li>einen prozentualen Wert, um bspw. Farbverläufe auf eine Werteintervall
 * abzubilden</li>
 * </ul>
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 */
public class DecoratorDatenSatz {

	/** vom Datenverteiler empfangene Daten. */
	private final Data daten;

	/** der relative Wert bezüglich der Intervallgrenzen des Decorators. */
	private final double relativerWert;

	/** ein optionaler Textwert. */
	private final String textWert;

	/**
	 * Konstruktor.
	 *
	 * @param daten
	 *            die Datenverteilerdaten
	 * @param relativerWert
	 *            der relative Wert
	 * @param textWert
	 *            der Wert als Text
	 */
	protected DecoratorDatenSatz(final Data daten, final double relativerWert, final String textWert) {
		this.daten = daten;
		this.relativerWert = relativerWert;
		this.textWert = textWert;
	}

	/**
	 * liefert die Datenverteilerdaten oder <code>null</code>, wenn keine
	 * empfangen wurden.
	 *
	 * @return die Daten oder <code>null</code>
	 */
	public Data getDaten() {
		return daten;
	}

	/**
	 * liefert den relativen (innerhalb eines Intervalldekorators) Datenwert.
	 *
	 * @return den Wert
	 */
	public double getRelativerWert() {
		return relativerWert;
	}

	/**
	 * liefert den definierten Textwert.
	 *
	 * @return den Wert
	 */
	public String getTextWert() {
		return textWert;
	}
}
