/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;

import de.bsvrz.buv.plugin.doeditor.editparts.DecoratorDatenSatz;
import de.bsvrz.buv.plugin.doeditor.model.EmbeddedDoForm;
import de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitParameterDefinition;

/**
 * Figur zur Darstellung einer eingebetten Instanz eines Darstellungsobjekttyps,
 * der mit dem DOT-Editor erstellt wurde.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 */
public class EmbeddDoFormFigure extends Figure implements VisibleFormFigure {

	/** das Modellobjekt der eingebetteten Instanz. */
	private final EmbeddedDoForm embedded;
	/** die aktuelle Skalierung. */
	private double scale;

	/**
	 * Konstruktor.
	 *
	 * @param embedded
	 *            die darzustellende eingebette Instanz
	 */
	public EmbeddDoFormFigure(final EmbeddedDoForm embedded) {
		this.embedded = embedded;
		setLayoutManager(new StackLayout());

		/*
		 * der Layoutmanager wird verwendet, um die Größe des Elements zu
		 * aktualisieren, wenn alle untergeordneten Formen eingefügt wurden.
		 */
		addLayoutListener(new LayoutListener() {

			@Override
			public void invalidate(final IFigure container) {
				// keine speziellen Aktionen erforderlich
			}

			@Override
			public boolean layout(final IFigure container) {
				return false;
			}

			@Override
			public void postLayout(final IFigure container) {
				// keine Aktionen vorgesehen
			}

			@Override
			public void remove(final IFigure child) {
				// wird hier nicht ausgeführt
			}

			@Override
			public void setConstraint(final IFigure child, final Object constraint) {
				setSize(child.getSize());
			}
		});
	}

	@Override
	public void aktualisiereVomModel() {
		if (embedded.getDarstellungsObjektTyp() != null) {
			final Point location = new Point(embedded.getLocation());
			location.x -= embedded.getDarstellungsObjektTyp().getWrapped().getHotspot().x;
			location.y -= embedded.getDarstellungsObjektTyp().getWrapped().getHotspot().y;

			setLocation(location);
			setVisible(embedded.isVisible());
		}
	}

	@Override
	public void decorate(final ParameterDefinition decorator, final DecoratorDatenSatz datenSatz) {
		if (decorator instanceof SichtbarkeitParameterDefinition) {
			setVisible(((SichtbarkeitParameterDefinition) decorator).isSichtbar());
		}
	}

	@Override
	public double getScale() {
		return scale;
	}

	@Override
	public void setScale(final double scale) {
		/*
		 * die Berücksichtigung Skalierung wird für dieses Element nicht
		 * unterstützt
		 */
		this.scale = scale;
	}

	@Override
	protected boolean useLocalCoordinates() {
		return true;
	}

}
