/*
 * Rahmenwerk-Plug-in "Darstellungsobjekttyp-Editor"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import de.bsvrz.buv.plugin.doeditor.model.AttributeDecorator;
import de.bsvrz.buv.plugin.doeditor.model.AttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Attribute Text Decorator</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.AttributeTextDecoratorImpl#getText <em>Text</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.AttributeTextDecoratorImpl#getAttributGruppe <em>Attribut Gruppe</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.AttributeTextDecoratorImpl#getAspekt <em>Aspekt</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.AttributeTextDecoratorImpl#getAttributPfad <em>Attribut Pfad</em>}</li>
 * </ul>
 *
 * @generated
 */
public class AttributeTextDecoratorImpl extends DecoratorImpl implements AttributeTextDecorator {
	/**
	 * The default value of the '{@link #getText() <em>Text</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getText()
	 * @generated
	 * @ordered
	 */
	protected static final String TEXT_EDEFAULT = "";

	/**
	 * The cached value of the '{@link #getText() <em>Text</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getText()
	 * @generated
	 * @ordered
	 */
	protected String text = TEXT_EDEFAULT;

	/**
	 * The default value of the '{@link #getAttributGruppe() <em>Attribut Gruppe</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getAttributGruppe()
	 * @generated
	 * @ordered
	 */
	protected static final AttributeGroup ATTRIBUT_GRUPPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAttributGruppe() <em>Attribut Gruppe</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getAttributGruppe()
	 * @generated
	 * @ordered
	 */
	protected AttributeGroup attributGruppe = ATTRIBUT_GRUPPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getAspekt() <em>Aspekt</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getAspekt()
	 * @generated
	 * @ordered
	 */
	protected static final Aspect ASPEKT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAspekt() <em>Aspekt</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getAspekt()
	 * @generated
	 * @ordered
	 */
	protected Aspect aspekt = ASPEKT_EDEFAULT;

	/**
	 * The default value of the '{@link #getAttributPfad() <em>Attribut Pfad</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getAttributPfad()
	 * @generated
	 * @ordered
	 */
	protected static final String ATTRIBUT_PFAD_EDEFAULT = "";

	/**
	 * The cached value of the '{@link #getAttributPfad() <em>Attribut Pfad</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getAttributPfad()
	 * @generated
	 * @ordered
	 */
	protected String attributPfad = ATTRIBUT_PFAD_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributeTextDecoratorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DoeditorPackage.Literals.ATTRIBUTE_TEXT_DECORATOR;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String getText() {
		return text;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setText(String newText) {
		String oldText = text;
		text = newText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__TEXT,
					oldText, text));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public AttributeGroup getAttributGruppe() {
		return attributGruppe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setAttributGruppe(AttributeGroup newAttributGruppe) {
		AttributeGroup oldAttributGruppe = attributGruppe;
		attributGruppe = newAttributGruppe;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE, oldAttributGruppe, attributGruppe));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Aspect getAspekt() {
		return aspekt;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setAspekt(Aspect newAspekt) {
		Aspect oldAspekt = aspekt;
		aspekt = newAspekt;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ASPEKT,
					oldAspekt, aspekt));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String getAttributPfad() {
		return attributPfad;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setAttributPfad(String newAttributPfad) {
		String oldAttributPfad = attributPfad;
		attributPfad = newAttributPfad;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD, oldAttributPfad, attributPfad));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__TEXT:
			return getText();
		case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE:
			return getAttributGruppe();
		case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ASPEKT:
			return getAspekt();
		case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD:
			return getAttributPfad();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__TEXT:
			setText((String) newValue);
			return;
		case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE:
			setAttributGruppe((AttributeGroup) newValue);
			return;
		case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ASPEKT:
			setAspekt((Aspect) newValue);
			return;
		case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD:
			setAttributPfad((String) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__TEXT:
			setText(TEXT_EDEFAULT);
			return;
		case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE:
			setAttributGruppe(ATTRIBUT_GRUPPE_EDEFAULT);
			return;
		case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ASPEKT:
			setAspekt(ASPEKT_EDEFAULT);
			return;
		case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD:
			setAttributPfad(ATTRIBUT_PFAD_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__TEXT:
			return TEXT_EDEFAULT == null ? text != null : !TEXT_EDEFAULT.equals(text);
		case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE:
			return ATTRIBUT_GRUPPE_EDEFAULT == null ? attributGruppe != null
					: !ATTRIBUT_GRUPPE_EDEFAULT.equals(attributGruppe);
		case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ASPEKT:
			return ASPEKT_EDEFAULT == null ? aspekt != null : !ASPEKT_EDEFAULT.equals(aspekt);
		case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD:
			return ATTRIBUT_PFAD_EDEFAULT == null ? attributPfad != null : !ATTRIBUT_PFAD_EDEFAULT.equals(attributPfad);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == AttributeDecorator.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE:
				return DoeditorPackage.ATTRIBUTE_DECORATOR__ATTRIBUT_GRUPPE;
			case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ASPEKT:
				return DoeditorPackage.ATTRIBUTE_DECORATOR__ASPEKT;
			case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD:
				return DoeditorPackage.ATTRIBUTE_DECORATOR__ATTRIBUT_PFAD;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == AttributeDecorator.class) {
			switch (baseFeatureID) {
			case DoeditorPackage.ATTRIBUTE_DECORATOR__ATTRIBUT_GRUPPE:
				return DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE;
			case DoeditorPackage.ATTRIBUTE_DECORATOR__ASPEKT:
				return DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ASPEKT;
			case DoeditorPackage.ATTRIBUTE_DECORATOR__ATTRIBUT_PFAD:
				return DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (text: ");
		result.append(text);
		result.append(", attributGruppe: ");
		result.append(attributGruppe);
		result.append(", aspekt: ");
		result.append(aspekt);
		result.append(", attributPfad: ");
		result.append(attributPfad);
		result.append(')');
		return result.toString();
	}

} // AttributeTextDecoratorImpl
