/*
 * Rahmenwerk-Plug-in "Darstellungsobjekttyp-Editor"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EColor;

import de.bsvrz.buv.plugin.doeditor.model.BackgroundAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BackgroundParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.ColorParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Background Attribute Interval Decorator</b></em>'. <!-- end-user-doc
 * -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>
 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.BackgroundAttributeIntervalDecoratorImpl#getDefaultValue
 * <em>Default Value</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.BackgroundAttributeIntervalDecoratorImpl#getParameter
 * <em>Parameter</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class BackgroundAttributeIntervalDecoratorImpl extends AttributeIntervalDecoratorImpl
		implements BackgroundAttributeIntervalDecorator {
	/**
	 * The cached value of the '{@link #getStartColor() <em>Start Color</em>}' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getStartColor()
	 * @generated
	 * @ordered
	 */
	protected EColor startColor;

	/**
	 * The cached value of the '{@link #getEndColor() <em>End Color</em>}' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getEndColor()
	 * @generated
	 * @ordered
	 */
	protected EColor endColor;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected BackgroundAttributeIntervalDecoratorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DoeditorPackage.Literals.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EColor getStartColor() {
		return startColor;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetStartColor(EColor newStartColor, NotificationChain msgs) {
		EColor oldStartColor = startColor;
		startColor = newStartColor;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__START_COLOR, oldStartColor, newStartColor);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setStartColor(EColor newStartColor) {
		if (newStartColor != startColor) {
			NotificationChain msgs = null;
			if (startColor != null)
				msgs = ((InternalEObject) startColor).eInverseRemove(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__START_COLOR,
						null, msgs);
			if (newStartColor != null)
				msgs = ((InternalEObject) newStartColor).eInverseAdd(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__START_COLOR,
						null, msgs);
			msgs = basicSetStartColor(newStartColor, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__START_COLOR, newStartColor,
					newStartColor));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EColor getEndColor() {
		return endColor;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetEndColor(EColor newEndColor, NotificationChain msgs) {
		EColor oldEndColor = endColor;
		endColor = newEndColor;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__END_COLOR, oldEndColor, newEndColor);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setEndColor(EColor newEndColor) {
		if (newEndColor != endColor) {
			NotificationChain msgs = null;
			if (endColor != null)
				msgs = ((InternalEObject) endColor).eInverseRemove(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__END_COLOR,
						null, msgs);
			if (newEndColor != null)
				msgs = ((InternalEObject) newEndColor).eInverseAdd(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__END_COLOR,
						null, msgs);
			msgs = basicSetEndColor(newEndColor, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__END_COLOR, newEndColor, newEndColor));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__START_COLOR:
			return basicSetStartColor(null, msgs);
		case DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__END_COLOR:
			return basicSetEndColor(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__START_COLOR:
			return getStartColor();
		case DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__END_COLOR:
			return getEndColor();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__START_COLOR:
			setStartColor((EColor) newValue);
			return;
		case DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__END_COLOR:
			setEndColor((EColor) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__START_COLOR:
			setStartColor((EColor) null);
			return;
		case DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__END_COLOR:
			setEndColor((EColor) null);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__START_COLOR:
			return startColor != null;
		case DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__END_COLOR:
			return endColor != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == ParameterDefinition.class) {
			switch (derivedFeatureID) {
			default:
				return -1;
			}
		}
		if (baseClass == ColorParameterDefinition.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__START_COLOR:
				return DoeditorPackage.COLOR_PARAMETER_DEFINITION__START_COLOR;
			case DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__END_COLOR:
				return DoeditorPackage.COLOR_PARAMETER_DEFINITION__END_COLOR;
			default:
				return -1;
			}
		}
		if (baseClass == BackgroundParameterDefinition.class) {
			switch (derivedFeatureID) {
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == ParameterDefinition.class) {
			switch (baseFeatureID) {
			default:
				return -1;
			}
		}
		if (baseClass == ColorParameterDefinition.class) {
			switch (baseFeatureID) {
			case DoeditorPackage.COLOR_PARAMETER_DEFINITION__START_COLOR:
				return DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__START_COLOR;
			case DoeditorPackage.COLOR_PARAMETER_DEFINITION__END_COLOR:
				return DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__END_COLOR;
			default:
				return -1;
			}
		}
		if (baseClass == BackgroundParameterDefinition.class) {
			switch (baseFeatureID) {
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

} // BackgroundAttributeIntervalDecoratorImpl
