/*
 * Rahmenwerk-Plug-in "Darstellungsobjekttyp-Editor"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.DrehwinkelAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.DrehwinkelParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Drehwinkel Attribute Interval Decorator</b></em>'. <!-- end-user-doc
 * -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>
 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.DrehwinkelAttributeIntervalDecoratorImpl#getDefaultValue
 * <em>Default Value</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.DrehwinkelAttributeIntervalDecoratorImpl#getParameter
 * <em>Parameter</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class DrehwinkelAttributeIntervalDecoratorImpl extends AttributeIntervalDecoratorImpl
		implements DrehwinkelAttributeIntervalDecorator {
	/**
	 * The default value of the '{@link #getStartWinkel() <em>Start Winkel</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getStartWinkel()
	 * @generated
	 * @ordered
	 */
	protected static final float START_WINKEL_EDEFAULT = 0.0F;

	/**
	 * The cached value of the '{@link #getStartWinkel() <em>Start Winkel</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getStartWinkel()
	 * @generated
	 * @ordered
	 */
	protected float startWinkel = START_WINKEL_EDEFAULT;

	/**
	 * The default value of the '{@link #getEndWinkel() <em>End Winkel</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getEndWinkel()
	 * @generated
	 * @ordered
	 */
	protected static final Float END_WINKEL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEndWinkel() <em>End Winkel</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getEndWinkel()
	 * @generated
	 * @ordered
	 */
	protected Float endWinkel = END_WINKEL_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected DrehwinkelAttributeIntervalDecoratorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DoeditorPackage.Literals.DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public float getStartWinkel() {
		return startWinkel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setStartWinkel(float newStartWinkel) {
		float oldStartWinkel = startWinkel;
		startWinkel = newStartWinkel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__START_WINKEL, oldStartWinkel,
					startWinkel));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Float getEndWinkel() {
		return endWinkel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setEndWinkel(Float newEndWinkel) {
		Float oldEndWinkel = endWinkel;
		endWinkel = newEndWinkel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__END_WINKEL, oldEndWinkel, endWinkel));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DoeditorPackage.DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__START_WINKEL:
			return getStartWinkel();
		case DoeditorPackage.DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__END_WINKEL:
			return getEndWinkel();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DoeditorPackage.DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__START_WINKEL:
			setStartWinkel((Float) newValue);
			return;
		case DoeditorPackage.DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__END_WINKEL:
			setEndWinkel((Float) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DoeditorPackage.DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__START_WINKEL:
			setStartWinkel(START_WINKEL_EDEFAULT);
			return;
		case DoeditorPackage.DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__END_WINKEL:
			setEndWinkel(END_WINKEL_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DoeditorPackage.DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__START_WINKEL:
			return startWinkel != START_WINKEL_EDEFAULT;
		case DoeditorPackage.DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__END_WINKEL:
			return END_WINKEL_EDEFAULT == null ? endWinkel != null : !END_WINKEL_EDEFAULT.equals(endWinkel);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == ParameterDefinition.class) {
			switch (derivedFeatureID) {
			default:
				return -1;
			}
		}
		if (baseClass == DrehwinkelParameterDefinition.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__START_WINKEL:
				return DoeditorPackage.DREHWINKEL_PARAMETER_DEFINITION__START_WINKEL;
			case DoeditorPackage.DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__END_WINKEL:
				return DoeditorPackage.DREHWINKEL_PARAMETER_DEFINITION__END_WINKEL;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == ParameterDefinition.class) {
			switch (baseFeatureID) {
			default:
				return -1;
			}
		}
		if (baseClass == DrehwinkelParameterDefinition.class) {
			switch (baseFeatureID) {
			case DoeditorPackage.DREHWINKEL_PARAMETER_DEFINITION__START_WINKEL:
				return DoeditorPackage.DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__START_WINKEL;
			case DoeditorPackage.DREHWINKEL_PARAMETER_DEFINITION__END_WINKEL:
				return DoeditorPackage.DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__END_WINKEL;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (startWinkel: ");
		result.append(startWinkel);
		result.append(", endWinkel: ");
		result.append(endWinkel);
		result.append(')');
		return result.toString();
	}

} // DrehwinkelAttributeIntervalDecoratorImpl
