/*
 * Rahmenwerk-Plug-in "Darstellungsobjekttyp-Editor"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator;
import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.model.DoKompositum;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.dobj.model.impl.DoModelImpl;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoModel;
import de.bsvrz.buv.plugin.doeditor.model.Identidy;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Editor Do Model</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoModelImpl#getKomponenten <em>Komponenten</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoModelImpl#getSkalierungsfaktor <em>Skalierungsfaktor</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoModelImpl#getDrehwinkel <em>Drehwinkel</em>}</li>
 * </ul>
 *
 * @generated
 */
public class EditorDoModelImpl extends DoModelImpl implements EditorDoModel {
	/**
	 * The cached value of the '{@link #getKomponenten() <em>Komponenten</em>}' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getKomponenten()
	 * @generated
	 * @ordered
	 */
	protected EList<DoModel> komponenten;
	/**
	 * The default value of the '{@link #getSkalierungsfaktor() <em>Skalierungsfaktor</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getSkalierungsfaktor()
	 * @generated
	 * @ordered
	 */
	protected static final double SKALIERUNGSFAKTOR_EDEFAULT = 1.0;
	/**
	 * The cached value of the '{@link #getSkalierungsfaktor() <em>Skalierungsfaktor</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getSkalierungsfaktor()
	 * @generated
	 * @ordered
	 */
	protected double skalierungsfaktor = SKALIERUNGSFAKTOR_EDEFAULT;
	/**
	 * This is true if the Skalierungsfaktor attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean skalierungsfaktorESet;
	/**
	 * The default value of the '{@link #getDrehwinkel() <em>Drehwinkel</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getDrehwinkel()
	 * @generated
	 * @ordered
	 */
	protected static final float DREHWINKEL_EDEFAULT = 0.0F;
	/**
	 * The cached value of the '{@link #getDrehwinkel() <em>Drehwinkel</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getDrehwinkel()
	 * @generated
	 * @ordered
	 */
	protected float drehwinkel = DREHWINKEL_EDEFAULT;
	/**
	 * This is true if the Drehwinkel attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean drehwinkelESet;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected EditorDoModelImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DoeditorPackage.Literals.EDITOR_DO_MODEL;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<DoModel> getKomponenten() {
		if (komponenten == null) {
			komponenten = new EObjectContainmentEList<DoModel>(DoModel.class, this,
					DoeditorPackage.EDITOR_DO_MODEL__KOMPONENTEN);
		}
		return komponenten;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getSkalierungsfaktor() {
		return skalierungsfaktor;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSkalierungsfaktor(double newSkalierungsfaktor) {
		double oldSkalierungsfaktor = skalierungsfaktor;
		skalierungsfaktor = newSkalierungsfaktor;
		boolean oldSkalierungsfaktorESet = skalierungsfaktorESet;
		skalierungsfaktorESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.EDITOR_DO_MODEL__SKALIERUNGSFAKTOR,
					oldSkalierungsfaktor, skalierungsfaktor, !oldSkalierungsfaktorESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetSkalierungsfaktor() {
		double oldSkalierungsfaktor = skalierungsfaktor;
		boolean oldSkalierungsfaktorESet = skalierungsfaktorESet;
		skalierungsfaktor = SKALIERUNGSFAKTOR_EDEFAULT;
		skalierungsfaktorESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, DoeditorPackage.EDITOR_DO_MODEL__SKALIERUNGSFAKTOR,
					oldSkalierungsfaktor, SKALIERUNGSFAKTOR_EDEFAULT, oldSkalierungsfaktorESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetSkalierungsfaktor() {
		return skalierungsfaktorESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public float getDrehwinkel() {
		return drehwinkel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDrehwinkel(float newDrehwinkel) {
		float oldDrehwinkel = drehwinkel;
		drehwinkel = newDrehwinkel;
		boolean oldDrehwinkelESet = drehwinkelESet;
		drehwinkelESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.EDITOR_DO_MODEL__DREHWINKEL,
					oldDrehwinkel, drehwinkel, !oldDrehwinkelESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetDrehwinkel() {
		float oldDrehwinkel = drehwinkel;
		boolean oldDrehwinkelESet = drehwinkelESet;
		drehwinkel = DREHWINKEL_EDEFAULT;
		drehwinkelESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, DoeditorPackage.EDITOR_DO_MODEL__DREHWINKEL,
					oldDrehwinkel, DREHWINKEL_EDEFAULT, oldDrehwinkelESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetDrehwinkel() {
		return drehwinkelESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DoeditorPackage.EDITOR_DO_MODEL__KOMPONENTEN:
			return ((InternalEList<?>) getKomponenten()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DoeditorPackage.EDITOR_DO_MODEL__KOMPONENTEN:
			return getKomponenten();
		case DoeditorPackage.EDITOR_DO_MODEL__SKALIERUNGSFAKTOR:
			return getSkalierungsfaktor();
		case DoeditorPackage.EDITOR_DO_MODEL__DREHWINKEL:
			return getDrehwinkel();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DoeditorPackage.EDITOR_DO_MODEL__KOMPONENTEN:
			getKomponenten().clear();
			getKomponenten().addAll((Collection<? extends DoModel>) newValue);
			return;
		case DoeditorPackage.EDITOR_DO_MODEL__SKALIERUNGSFAKTOR:
			setSkalierungsfaktor((Double) newValue);
			return;
		case DoeditorPackage.EDITOR_DO_MODEL__DREHWINKEL:
			setDrehwinkel((Float) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DoeditorPackage.EDITOR_DO_MODEL__KOMPONENTEN:
			getKomponenten().clear();
			return;
		case DoeditorPackage.EDITOR_DO_MODEL__SKALIERUNGSFAKTOR:
			unsetSkalierungsfaktor();
			return;
		case DoeditorPackage.EDITOR_DO_MODEL__DREHWINKEL:
			unsetDrehwinkel();
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DoeditorPackage.EDITOR_DO_MODEL__KOMPONENTEN:
			return komponenten != null && !komponenten.isEmpty();
		case DoeditorPackage.EDITOR_DO_MODEL__SKALIERUNGSFAKTOR:
			return isSetSkalierungsfaktor();
		case DoeditorPackage.EDITOR_DO_MODEL__DREHWINKEL:
			return isSetDrehwinkel();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == DoKompositum.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.EDITOR_DO_MODEL__KOMPONENTEN:
				return DobjPackage.DO_KOMPOSITUM__KOMPONENTEN;
			default:
				return -1;
			}
		}
		if (baseClass == SkalierungDecorator.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.EDITOR_DO_MODEL__SKALIERUNGSFAKTOR:
				return DobjDecoratorPackage.SKALIERUNG_DECORATOR__SKALIERUNGSFAKTOR;
			default:
				return -1;
			}
		}
		if (baseClass == DrehungDecorator.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.EDITOR_DO_MODEL__DREHWINKEL:
				return DobjDecoratorPackage.DREHUNG_DECORATOR__DREHWINKEL;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == DoKompositum.class) {
			switch (baseFeatureID) {
			case DobjPackage.DO_KOMPOSITUM__KOMPONENTEN:
				return DoeditorPackage.EDITOR_DO_MODEL__KOMPONENTEN;
			default:
				return -1;
			}
		}
		if (baseClass == SkalierungDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.SKALIERUNG_DECORATOR__SKALIERUNGSFAKTOR:
				return DoeditorPackage.EDITOR_DO_MODEL__SKALIERUNGSFAKTOR;
			default:
				return -1;
			}
		}
		if (baseClass == DrehungDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.DREHUNG_DECORATOR__DREHWINKEL:
				return DoeditorPackage.EDITOR_DO_MODEL__DREHWINKEL;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (skalierungsfaktor: ");
		if (skalierungsfaktorESet)
			result.append(skalierungsfaktor);
		else
			result.append("<unset>");
		result.append(", drehwinkel: ");
		if (drehwinkelESet)
			result.append(drehwinkel);
		else
			result.append("<unset>");
		result.append(')');
		return result.toString();
	}

} // EditorDoModelImpl
