/**
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 * 
 */
package de.bsvrz.buv.plugin.doeditor.model.impl;

import java.net.URL;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.resource.ImageDescriptor;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.dobj.model.impl.DoTypImpl;
import de.bsvrz.buv.plugin.doeditor.editparts.EditorDoModelEditPart;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorFactory;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoModel;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTypReferenz;
import de.bsvrz.buv.plugin.doeditor.model.EmbeddedDoForm;
import de.bsvrz.buv.plugin.doeditor.model.ExternalDoForm;
import de.bsvrz.buv.plugin.doeditor.model.Identidy;
import de.bsvrz.buv.plugin.doeditor.model.VisibleForm;
import de.bsvrz.buv.plugin.doeditor.model.provider.DoeditorEditPlugin;
import de.bsvrz.buv.plugin.doeditor.model.util.DoeditorAdapterFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellungsobjekteglobal.objekte.DarstellungsObjektTyp;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Editor Do Typ Referenz</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypReferenzImpl#getSkalierungsfaktor <em>Skalierungsfaktor</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypReferenzImpl#getDrehwinkel <em>Drehwinkel</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypReferenzImpl#getSystemObjekt <em>System Objekt</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypReferenzImpl#getWrapped <em>Wrapped</em>}</li>
 * </ul>
 *
 * @generated
 */
public class EditorDoTypReferenzImpl extends DoTypImpl implements EditorDoTypReferenz {
	/**
	 * The default value of the '{@link #getSkalierungsfaktor() <em>Skalierungsfaktor</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getSkalierungsfaktor()
	 * @generated
	 * @ordered
	 */
	protected static final double SKALIERUNGSFAKTOR_EDEFAULT = 1.0;

	/**
	 * The cached value of the '{@link #getSkalierungsfaktor() <em>Skalierungsfaktor</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getSkalierungsfaktor()
	 * @generated
	 * @ordered
	 */
	protected double skalierungsfaktor = SKALIERUNGSFAKTOR_EDEFAULT;

	/**
	 * This is true if the Skalierungsfaktor attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean skalierungsfaktorESet;

	/**
	 * The default value of the '{@link #getDrehwinkel() <em>Drehwinkel</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getDrehwinkel()
	 * @generated
	 * @ordered
	 */
	protected static final float DREHWINKEL_EDEFAULT = 0.0F;

	/**
	 * The cached value of the '{@link #getDrehwinkel() <em>Drehwinkel</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getDrehwinkel()
	 * @generated
	 * @ordered
	 */
	protected float drehwinkel = DREHWINKEL_EDEFAULT;

	/**
	 * This is true if the Drehwinkel attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean drehwinkelESet;

	/**
	 * The default value of the '{@link #getSystemObjekt() <em>System Objekt</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getSystemObjekt()
	 * @generated
	 * @ordered
	 */
	protected static final SystemObjekt SYSTEM_OBJEKT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSystemObjekt() <em>System Objekt</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getSystemObjekt()
	 * @generated
	 * @ordered
	 */
	protected SystemObjekt systemObjekt = SYSTEM_OBJEKT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getWrapped() <em>Wrapped</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getWrapped()
	 * @generated
	 * @ordered
	 */
	protected EditorDoTyp wrapped;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	protected EditorDoTypReferenzImpl() {
		super();

		final Object obj = DoeditorEditPlugin.INSTANCE.getImage("full/obj16/EditorDoTypReferenz");
		if (obj instanceof ImageDescriptor) {
			icon = (ImageDescriptor) obj;
		} else if (obj instanceof URL) {
			icon = ImageDescriptor.createFromURL((URL) obj);
		}

		new DoeditorAdapterFactory().adapt(this, EditorDoTypReferenz.class);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EditorDoTyp basicGetWrapped() {
		return wrapped;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setWrapped(EditorDoTyp newWrapped) {
		EditorDoTyp oldWrapped = wrapped;
		wrapped = newWrapped;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.EDITOR_DO_TYP_REFERENZ__WRAPPED,
					oldWrapped, wrapped));
	}

	/**
	 * @generated NOT
	 */
	@Override
	public GraphicalEditPart createController() {
		return new EditorDoModelEditPart();
	}

	/**
	 * @generated NOT
	 */
	@Override
	public DoModel createModel() {
		final EditorDoModel doModel = DoeditorFactory.eINSTANCE.createEditorDoModel();
		doModel.setDoTyp(this);

		for (final VisibleForm form : getWrapped().getFormen()) {
			if (form instanceof EmbeddedDoForm) {
				final DarstellungsObjektTyp doTypObjekt = (DarstellungsObjektTyp) ((EmbeddedDoForm) form)
						.getDarstellungsObjektTyp().getSystemObjekt();

				final EditorDoTypReferenz doTypReference = DoeditorFactory.eINSTANCE.createEditorDoTypReferenz();
				doTypReference.setSystemObjekt(doTypObjekt);
				final EditorDoModelImpl model = (EditorDoModelImpl) doTypReference.createModel();
				if (model.getDoTyp() != null) {
					model.setLocation(form.getLocation().getCopy().translate(form.getEditorDoTyp().getHotspot()));
					model.setKomponentenId(((Identidy) form).getId());
					doModel.getKomponenten().add(model);
				}
			} else if (form instanceof ExternalDoForm) {
				final DoTyp externalDoTyp = ((ExternalDoForm) form).getDarstellungsObjektTyp();
				if (externalDoTyp != null) {
					final DoModel model = externalDoTyp.createModel();
					model.setLocation(form.getLocation());
					model.setKomponentenId(((Identidy) form).getId());
					doModel.getKomponenten().add(model);
				}
			}
		}
		return doModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DoeditorPackage.EDITOR_DO_TYP_REFERENZ__SKALIERUNGSFAKTOR:
			return getSkalierungsfaktor();
		case DoeditorPackage.EDITOR_DO_TYP_REFERENZ__DREHWINKEL:
			return getDrehwinkel();
		case DoeditorPackage.EDITOR_DO_TYP_REFERENZ__SYSTEM_OBJEKT:
			return getSystemObjekt();
		case DoeditorPackage.EDITOR_DO_TYP_REFERENZ__WRAPPED:
			if (resolve)
				return getWrapped();
			return basicGetWrapped();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DoeditorPackage.EDITOR_DO_TYP_REFERENZ__SKALIERUNGSFAKTOR:
			return isSetSkalierungsfaktor();
		case DoeditorPackage.EDITOR_DO_TYP_REFERENZ__DREHWINKEL:
			return isSetDrehwinkel();
		case DoeditorPackage.EDITOR_DO_TYP_REFERENZ__SYSTEM_OBJEKT:
			return SYSTEM_OBJEKT_EDEFAULT == null ? systemObjekt != null : !SYSTEM_OBJEKT_EDEFAULT.equals(systemObjekt);
		case DoeditorPackage.EDITOR_DO_TYP_REFERENZ__WRAPPED:
			return wrapped != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == SkalierungDecorator.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.EDITOR_DO_TYP_REFERENZ__SKALIERUNGSFAKTOR:
				return DobjDecoratorPackage.SKALIERUNG_DECORATOR__SKALIERUNGSFAKTOR;
			default:
				return -1;
			}
		}
		if (baseClass == DrehungDecorator.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.EDITOR_DO_TYP_REFERENZ__DREHWINKEL:
				return DobjDecoratorPackage.DREHUNG_DECORATOR__DREHWINKEL;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == SkalierungDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.SKALIERUNG_DECORATOR__SKALIERUNGSFAKTOR:
				return DoeditorPackage.EDITOR_DO_TYP_REFERENZ__SKALIERUNGSFAKTOR;
			default:
				return -1;
			}
		}
		if (baseClass == DrehungDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.DREHUNG_DECORATOR__DREHWINKEL:
				return DoeditorPackage.EDITOR_DO_TYP_REFERENZ__DREHWINKEL;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DoeditorPackage.EDITOR_DO_TYP_REFERENZ__SKALIERUNGSFAKTOR:
			setSkalierungsfaktor((Double) newValue);
			return;
		case DoeditorPackage.EDITOR_DO_TYP_REFERENZ__DREHWINKEL:
			setDrehwinkel((Float) newValue);
			return;
		case DoeditorPackage.EDITOR_DO_TYP_REFERENZ__SYSTEM_OBJEKT:
			setSystemObjekt((SystemObjekt) newValue);
			return;
		case DoeditorPackage.EDITOR_DO_TYP_REFERENZ__WRAPPED:
			setWrapped((EditorDoTyp) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DoeditorPackage.Literals.EDITOR_DO_TYP_REFERENZ;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getSkalierungsfaktor() {
		return skalierungsfaktor;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSkalierungsfaktor(double newSkalierungsfaktor) {
		double oldSkalierungsfaktor = skalierungsfaktor;
		skalierungsfaktor = newSkalierungsfaktor;
		boolean oldSkalierungsfaktorESet = skalierungsfaktorESet;
		skalierungsfaktorESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.EDITOR_DO_TYP_REFERENZ__SKALIERUNGSFAKTOR, oldSkalierungsfaktor, skalierungsfaktor,
					!oldSkalierungsfaktorESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetSkalierungsfaktor() {
		double oldSkalierungsfaktor = skalierungsfaktor;
		boolean oldSkalierungsfaktorESet = skalierungsfaktorESet;
		skalierungsfaktor = SKALIERUNGSFAKTOR_EDEFAULT;
		skalierungsfaktorESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					DoeditorPackage.EDITOR_DO_TYP_REFERENZ__SKALIERUNGSFAKTOR, oldSkalierungsfaktor,
					SKALIERUNGSFAKTOR_EDEFAULT, oldSkalierungsfaktorESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetSkalierungsfaktor() {
		return skalierungsfaktorESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public float getDrehwinkel() {
		return drehwinkel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDrehwinkel(float newDrehwinkel) {
		float oldDrehwinkel = drehwinkel;
		drehwinkel = newDrehwinkel;
		boolean oldDrehwinkelESet = drehwinkelESet;
		drehwinkelESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.EDITOR_DO_TYP_REFERENZ__DREHWINKEL,
					oldDrehwinkel, drehwinkel, !oldDrehwinkelESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetDrehwinkel() {
		float oldDrehwinkel = drehwinkel;
		boolean oldDrehwinkelESet = drehwinkelESet;
		drehwinkel = DREHWINKEL_EDEFAULT;
		drehwinkelESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, DoeditorPackage.EDITOR_DO_TYP_REFERENZ__DREHWINKEL,
					oldDrehwinkel, DREHWINKEL_EDEFAULT, oldDrehwinkelESet));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetDrehwinkel() {
		return drehwinkelESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DoeditorPackage.EDITOR_DO_TYP_REFERENZ__SKALIERUNGSFAKTOR:
			unsetSkalierungsfaktor();
			return;
		case DoeditorPackage.EDITOR_DO_TYP_REFERENZ__DREHWINKEL:
			unsetDrehwinkel();
			return;
		case DoeditorPackage.EDITOR_DO_TYP_REFERENZ__SYSTEM_OBJEKT:
			setSystemObjekt(SYSTEM_OBJEKT_EDEFAULT);
			return;
		case DoeditorPackage.EDITOR_DO_TYP_REFERENZ__WRAPPED:
			setWrapped((EditorDoTyp) null);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SystemObjekt getSystemObjekt() {
		return systemObjekt;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EditorDoTyp getWrapped() {
		if (wrapped != null && wrapped.eIsProxy()) {
			InternalEObject oldWrapped = (InternalEObject) wrapped;
			wrapped = (EditorDoTyp) eResolveProxy(oldWrapped);
			if (wrapped != oldWrapped) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE,
							DoeditorPackage.EDITOR_DO_TYP_REFERENZ__WRAPPED, oldWrapped, wrapped));
			}
		}
		return wrapped;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSystemObjekt(SystemObjekt newSystemObjekt) {
		SystemObjekt oldSystemObjekt = systemObjekt;
		systemObjekt = newSystemObjekt;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.EDITOR_DO_TYP_REFERENZ__SYSTEM_OBJEKT,
					oldSystemObjekt, systemObjekt));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (skalierungsfaktor: ");
		if (skalierungsfaktorESet)
			result.append(skalierungsfaktor);
		else
			result.append("<unset>");
		result.append(", drehwinkel: ");
		if (drehwinkelESet)
			result.append(drehwinkel);
		else
			result.append("<unset>");
		result.append(", systemObjekt: ");
		result.append(systemObjekt);
		result.append(')');
		return result.toString();
	}

} // EditorDoTypReferenzImpl
