/*
 * Rahmenwerk-Plug-in "Darstellungsobjekttyp-Editor"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.model.impl;

import java.util.Collection;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import com.bitctrl.lib.eclipse.emf.eclipse.model.impl.NamedImpl;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;
import com.bitctrl.lib.eclipse.emf.gef.model.Located;

import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.doeditor.model.Decorator;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp;
import de.bsvrz.buv.plugin.doeditor.model.ExternalDoForm;
import de.bsvrz.buv.plugin.doeditor.model.Identidy;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>External Do Form</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.ExternalDoFormImpl#getLocation <em>Location</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.ExternalDoFormImpl#getEditorDoTyp <em>Editor Do Typ</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.ExternalDoFormImpl#isVisible <em>Visible</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.ExternalDoFormImpl#getDecorators <em>Decorators</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.ExternalDoFormImpl#getId <em>Id</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.ExternalDoFormImpl#getDarstellungsObjektTyp <em>Darstellungs Objekt Typ</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.ExternalDoFormImpl#getExtensionPointID <em>Extension Point ID</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ExternalDoFormImpl extends NamedImpl implements ExternalDoForm {
	/**
	 * The default value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected static final Point LOCATION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected Point location = LOCATION_EDEFAULT;

	/**
	 * The default value of the '{@link #isVisible() <em>Visible</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isVisible()
	 * @generated
	 * @ordered
	 */
	protected static final boolean VISIBLE_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isVisible() <em>Visible</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isVisible()
	 * @generated
	 * @ordered
	 */
	protected boolean visible = VISIBLE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDecorators() <em>Decorators</em>}' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getDecorators()
	 * @generated
	 * @ordered
	 */
	protected EList<Decorator> decorators;

	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final long ID_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected long id = ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDarstellungsObjektTyp()
	 * <em>Darstellungs Objekt Typ</em>}' containment reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getDarstellungsObjektTyp()
	 * @generated
	 * @ordered
	 */
	protected DoTyp darstellungsObjektTyp;

	/**
	 * The default value of the '{@link #getExtensionPointID() <em>Extension Point ID</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getExtensionPointID()
	 * @generated
	 * @ordered
	 */
	protected static final String EXTENSION_POINT_ID_EDEFAULT = null;
	/**
	 * The cached value of the '{@link #getExtensionPointID() <em>Extension Point ID</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getExtensionPointID()
	 * @generated
	 * @ordered
	 */
	protected String extensionPointID = EXTENSION_POINT_ID_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ExternalDoFormImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DoeditorPackage.Literals.EXTERNAL_DO_FORM;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Point getLocation() {
		return location;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setLocation(Point newLocation) {
		Point oldLocation = location;
		location = newLocation;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.EXTERNAL_DO_FORM__LOCATION,
					oldLocation, location));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EditorDoTyp getEditorDoTyp() {
		if (eContainerFeatureID() != DoeditorPackage.EXTERNAL_DO_FORM__EDITOR_DO_TYP)
			return null;
		return (EditorDoTyp) eInternalContainer();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetEditorDoTyp(EditorDoTyp newEditorDoTyp, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject) newEditorDoTyp, DoeditorPackage.EXTERNAL_DO_FORM__EDITOR_DO_TYP,
				msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setEditorDoTyp(EditorDoTyp newEditorDoTyp) {
		if (newEditorDoTyp != eInternalContainer()
				|| (eContainerFeatureID() != DoeditorPackage.EXTERNAL_DO_FORM__EDITOR_DO_TYP
						&& newEditorDoTyp != null)) {
			if (EcoreUtil.isAncestor(this, newEditorDoTyp))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newEditorDoTyp != null)
				msgs = ((InternalEObject) newEditorDoTyp).eInverseAdd(this, DoeditorPackage.EDITOR_DO_TYP__FORMEN,
						EditorDoTyp.class, msgs);
			msgs = basicSetEditorDoTyp(newEditorDoTyp, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.EXTERNAL_DO_FORM__EDITOR_DO_TYP,
					newEditorDoTyp, newEditorDoTyp));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isVisible() {
		return visible;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setVisible(boolean newVisible) {
		boolean oldVisible = visible;
		visible = newVisible;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.EXTERNAL_DO_FORM__VISIBLE, oldVisible,
					visible));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Decorator> getDecorators() {
		if (decorators == null) {
			decorators = new EObjectContainmentEList<Decorator>(Decorator.class, this,
					DoeditorPackage.EXTERNAL_DO_FORM__DECORATORS);
		}
		return decorators;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(long newId) {
		long oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.EXTERNAL_DO_FORM__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public Rectangle getBounds() {
		// TODO: Groesse ermitteln
		return new Rectangle(getLocation(), new Dimension(50, 50));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public void setBounds(final Rectangle newBounds) {
		setLocation(newBounds.getLocation());
		// TODO: Größe berücksichtigen
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public DoTyp getDarstellungsObjektTyp() {
		return darstellungsObjektTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDarstellungsObjektTyp(DoTyp newDarstellungsObjektTyp, NotificationChain msgs) {
		DoTyp oldDarstellungsObjektTyp = darstellungsObjektTyp;
		darstellungsObjektTyp = newDarstellungsObjektTyp;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.EXTERNAL_DO_FORM__DARSTELLUNGS_OBJEKT_TYP, oldDarstellungsObjektTyp,
					newDarstellungsObjektTyp);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setDarstellungsObjektTyp(DoTyp newDarstellungsObjektTyp) {
		if (newDarstellungsObjektTyp != darstellungsObjektTyp) {
			NotificationChain msgs = null;
			if (darstellungsObjektTyp != null)
				msgs = ((InternalEObject) darstellungsObjektTyp).eInverseRemove(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.EXTERNAL_DO_FORM__DARSTELLUNGS_OBJEKT_TYP, null, msgs);
			if (newDarstellungsObjektTyp != null)
				msgs = ((InternalEObject) newDarstellungsObjektTyp).eInverseAdd(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.EXTERNAL_DO_FORM__DARSTELLUNGS_OBJEKT_TYP, null, msgs);
			msgs = basicSetDarstellungsObjektTyp(newDarstellungsObjektTyp, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.EXTERNAL_DO_FORM__DARSTELLUNGS_OBJEKT_TYP, newDarstellungsObjektTyp,
					newDarstellungsObjektTyp));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String getExtensionPointID() {
		return extensionPointID;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setExtensionPointID(String newExtensionPointID) {
		String oldExtensionPointID = extensionPointID;
		extensionPointID = newExtensionPointID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.EXTERNAL_DO_FORM__EXTENSION_POINT_ID,
					oldExtensionPointID, extensionPointID));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DoeditorPackage.EXTERNAL_DO_FORM__EDITOR_DO_TYP:
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			return basicSetEditorDoTyp((EditorDoTyp) otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DoeditorPackage.EXTERNAL_DO_FORM__EDITOR_DO_TYP:
			return basicSetEditorDoTyp(null, msgs);
		case DoeditorPackage.EXTERNAL_DO_FORM__DECORATORS:
			return ((InternalEList<?>) getDecorators()).basicRemove(otherEnd, msgs);
		case DoeditorPackage.EXTERNAL_DO_FORM__DARSTELLUNGS_OBJEKT_TYP:
			return basicSetDarstellungsObjektTyp(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
		case DoeditorPackage.EXTERNAL_DO_FORM__EDITOR_DO_TYP:
			return eInternalContainer().eInverseRemove(this, DoeditorPackage.EDITOR_DO_TYP__FORMEN, EditorDoTyp.class,
					msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DoeditorPackage.EXTERNAL_DO_FORM__LOCATION:
			return getLocation();
		case DoeditorPackage.EXTERNAL_DO_FORM__EDITOR_DO_TYP:
			return getEditorDoTyp();
		case DoeditorPackage.EXTERNAL_DO_FORM__VISIBLE:
			return isVisible();
		case DoeditorPackage.EXTERNAL_DO_FORM__DECORATORS:
			return getDecorators();
		case DoeditorPackage.EXTERNAL_DO_FORM__ID:
			return getId();
		case DoeditorPackage.EXTERNAL_DO_FORM__DARSTELLUNGS_OBJEKT_TYP:
			return getDarstellungsObjektTyp();
		case DoeditorPackage.EXTERNAL_DO_FORM__EXTENSION_POINT_ID:
			return getExtensionPointID();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DoeditorPackage.EXTERNAL_DO_FORM__LOCATION:
			setLocation((Point) newValue);
			return;
		case DoeditorPackage.EXTERNAL_DO_FORM__EDITOR_DO_TYP:
			setEditorDoTyp((EditorDoTyp) newValue);
			return;
		case DoeditorPackage.EXTERNAL_DO_FORM__VISIBLE:
			setVisible((Boolean) newValue);
			return;
		case DoeditorPackage.EXTERNAL_DO_FORM__DECORATORS:
			getDecorators().clear();
			getDecorators().addAll((Collection<? extends Decorator>) newValue);
			return;
		case DoeditorPackage.EXTERNAL_DO_FORM__ID:
			setId((Long) newValue);
			return;
		case DoeditorPackage.EXTERNAL_DO_FORM__DARSTELLUNGS_OBJEKT_TYP:
			setDarstellungsObjektTyp((DoTyp) newValue);
			return;
		case DoeditorPackage.EXTERNAL_DO_FORM__EXTENSION_POINT_ID:
			setExtensionPointID((String) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DoeditorPackage.EXTERNAL_DO_FORM__LOCATION:
			setLocation(LOCATION_EDEFAULT);
			return;
		case DoeditorPackage.EXTERNAL_DO_FORM__EDITOR_DO_TYP:
			setEditorDoTyp((EditorDoTyp) null);
			return;
		case DoeditorPackage.EXTERNAL_DO_FORM__VISIBLE:
			setVisible(VISIBLE_EDEFAULT);
			return;
		case DoeditorPackage.EXTERNAL_DO_FORM__DECORATORS:
			getDecorators().clear();
			return;
		case DoeditorPackage.EXTERNAL_DO_FORM__ID:
			setId(ID_EDEFAULT);
			return;
		case DoeditorPackage.EXTERNAL_DO_FORM__DARSTELLUNGS_OBJEKT_TYP:
			setDarstellungsObjektTyp((DoTyp) null);
			return;
		case DoeditorPackage.EXTERNAL_DO_FORM__EXTENSION_POINT_ID:
			setExtensionPointID(EXTENSION_POINT_ID_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DoeditorPackage.EXTERNAL_DO_FORM__LOCATION:
			return LOCATION_EDEFAULT == null ? location != null : !LOCATION_EDEFAULT.equals(location);
		case DoeditorPackage.EXTERNAL_DO_FORM__EDITOR_DO_TYP:
			return getEditorDoTyp() != null;
		case DoeditorPackage.EXTERNAL_DO_FORM__VISIBLE:
			return visible != VISIBLE_EDEFAULT;
		case DoeditorPackage.EXTERNAL_DO_FORM__DECORATORS:
			return decorators != null && !decorators.isEmpty();
		case DoeditorPackage.EXTERNAL_DO_FORM__ID:
			return id != ID_EDEFAULT;
		case DoeditorPackage.EXTERNAL_DO_FORM__DARSTELLUNGS_OBJEKT_TYP:
			return darstellungsObjektTyp != null;
		case DoeditorPackage.EXTERNAL_DO_FORM__EXTENSION_POINT_ID:
			return EXTENSION_POINT_ID_EDEFAULT == null ? extensionPointID != null
					: !EXTENSION_POINT_ID_EDEFAULT.equals(extensionPointID);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == Located.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.EXTERNAL_DO_FORM__LOCATION:
				return GefPackage.LOCATED__LOCATION;
			default:
				return -1;
			}
		}
		if (baseClass == Identidy.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.EXTERNAL_DO_FORM__ID:
				return DoeditorPackage.IDENTIDY__ID;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == Located.class) {
			switch (baseFeatureID) {
			case GefPackage.LOCATED__LOCATION:
				return DoeditorPackage.EXTERNAL_DO_FORM__LOCATION;
			default:
				return -1;
			}
		}
		if (baseClass == Identidy.class) {
			switch (baseFeatureID) {
			case DoeditorPackage.IDENTIDY__ID:
				return DoeditorPackage.EXTERNAL_DO_FORM__ID;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (location: ");
		result.append(location);
		result.append(", visible: ");
		result.append(visible);
		result.append(", id: ");
		result.append(id);
		result.append(", extensionPointID: ");
		result.append(extensionPointID);
		result.append(')');
		return result.toString();
	}

} // ExternalDoFormImpl
