/*
 * Rahmenwerk-Plug-in "Darstellungsobjekttyp-Editor"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.model.impl;

import java.util.Collection;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EColor;
import com.bitctrl.lib.eclipse.emf.eclipse.model.ELineAttributes;
import com.bitctrl.lib.eclipse.emf.eclipse.model.impl.NamedImpl;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;
import com.bitctrl.lib.eclipse.emf.gef.model.Located;
import com.bitctrl.lib.eclipse.emf.gef.model.Sized;

import de.bsvrz.buv.plugin.doeditor.model.Decorator;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp;
import de.bsvrz.buv.plugin.doeditor.model.FlaechenForm;
import de.bsvrz.buv.plugin.doeditor.model.Positionierung;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhalten;
import de.bsvrz.buv.plugin.doeditor.model.ZoomableForm;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.PortableBitMap;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Flaechen Form</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.FlaechenFormImpl#getLocation <em>Location</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.FlaechenFormImpl#getEditorDoTyp <em>Editor Do Typ</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.FlaechenFormImpl#isVisible <em>Visible</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.FlaechenFormImpl#getDecorators <em>Decorators</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.FlaechenFormImpl#getAngle <em>Angle</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.FlaechenFormImpl#getZoomVerhalten <em>Zoom Verhalten</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.FlaechenFormImpl#getPositionierung <em>Positionierung</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.FlaechenFormImpl#getBounds <em>Bounds</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.FlaechenFormImpl#getForegroundColor <em>Foreground Color</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.FlaechenFormImpl#getLineAttributes <em>Line Attributes</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.FlaechenFormImpl#getSize <em>Size</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.FlaechenFormImpl#getBackgroundPattern <em>Background Pattern</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.FlaechenFormImpl#isFilled <em>Filled</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.FlaechenFormImpl#getBackgroundColor <em>Background Color</em>}</li>
 * </ul>
 *
 * @generated
 */
public abstract class FlaechenFormImpl extends NamedImpl implements FlaechenForm {
	/**
	 * The default value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected static final Point LOCATION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected Point location = LOCATION_EDEFAULT;

	/**
	 * The default value of the '{@link #isVisible() <em>Visible</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isVisible()
	 * @generated
	 * @ordered
	 */
	protected static final boolean VISIBLE_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isVisible() <em>Visible</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isVisible()
	 * @generated
	 * @ordered
	 */
	protected boolean visible = VISIBLE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDecorators() <em>Decorators</em>}' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getDecorators()
	 * @generated
	 * @ordered
	 */
	protected EList<Decorator> decorators;

	/**
	 * The default value of the '{@link #getAngle() <em>Angle</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getAngle()
	 * @generated
	 * @ordered
	 */
	protected static final double ANGLE_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getAngle() <em>Angle</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getAngle()
	 * @generated
	 * @ordered
	 */
	protected double angle = ANGLE_EDEFAULT;

	/**
	 * The default value of the '{@link #getZoomVerhalten() <em>Zoom Verhalten</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getZoomVerhalten()
	 * @generated
	 * @ordered
	 */
	protected static final ZoomVerhalten ZOOM_VERHALTEN_EDEFAULT = ZoomVerhalten.DYNAMISCH;

	/**
	 * The cached value of the '{@link #getZoomVerhalten() <em>Zoom Verhalten</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getZoomVerhalten()
	 * @generated
	 * @ordered
	 */
	protected ZoomVerhalten zoomVerhalten = ZOOM_VERHALTEN_EDEFAULT;

	/**
	 * The default value of the '{@link #getPositionierung() <em>Positionierung</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getPositionierung()
	 * @generated
	 * @ordered
	 */
	protected static final Positionierung POSITIONIERUNG_EDEFAULT = Positionierung.LINKS_OBEN;

	/**
	 * The cached value of the '{@link #getPositionierung() <em>Positionierung</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getPositionierung()
	 * @generated
	 * @ordered
	 */
	protected Positionierung positionierung = POSITIONIERUNG_EDEFAULT;

	/**
	 * The default value of the '{@link #getBounds() <em>Bounds</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getBounds()
	 * @generated
	 * @ordered
	 */
	protected static final Rectangle BOUNDS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getForegroundColor() <em>Foreground Color</em>}' containment reference.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #getForegroundColor()
	 * @generated
	 * @ordered
	 */
	protected EColor foregroundColor;

	/**
	 * The cached value of the '{@link #getLineAttributes() <em>Line Attributes</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLineAttributes()
	 * @generated
	 * @ordered
	 */
	protected ELineAttributes lineAttributes;

	/**
	 * The default value of the '{@link #getSize() <em>Size</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSize()
	 * @generated
	 * @ordered
	 */
	protected static final Dimension SIZE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSize() <em>Size</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSize()
	 * @generated
	 * @ordered
	 */
	protected Dimension size = SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #getBackgroundPattern() <em>Background Pattern</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getBackgroundPattern()
	 * @generated
	 * @ordered
	 */
	protected static final PortableBitMap BACKGROUND_PATTERN_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getBackgroundPattern() <em>Background Pattern</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getBackgroundPattern()
	 * @generated
	 * @ordered
	 */
	protected PortableBitMap backgroundPattern = BACKGROUND_PATTERN_EDEFAULT;

	/**
	 * The default value of the '{@link #isFilled() <em>Filled</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isFilled()
	 * @generated
	 * @ordered
	 */
	protected static final boolean FILLED_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isFilled() <em>Filled</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isFilled()
	 * @generated
	 * @ordered
	 */
	protected boolean filled = FILLED_EDEFAULT;

	/**
	 * The cached value of the '{@link #getBackgroundColor() <em>Background Color</em>}' containment reference.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #getBackgroundColor()
	 * @generated
	 * @ordered
	 */
	protected EColor backgroundColor;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected FlaechenFormImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetBackgroundColor(EColor newBackgroundColor, NotificationChain msgs) {
		EColor oldBackgroundColor = backgroundColor;
		backgroundColor = newBackgroundColor;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.FLAECHEN_FORM__BACKGROUND_COLOR, oldBackgroundColor, newBackgroundColor);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetEditorDoTyp(EditorDoTyp newEditorDoTyp, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject) newEditorDoTyp, DoeditorPackage.FLAECHEN_FORM__EDITOR_DO_TYP, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetForegroundColor(EColor newForegroundColor, NotificationChain msgs) {
		EColor oldForegroundColor = foregroundColor;
		foregroundColor = newForegroundColor;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.FLAECHEN_FORM__FOREGROUND_COLOR, oldForegroundColor, newForegroundColor);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLineAttributes(ELineAttributes newLineAttributes, NotificationChain msgs) {
		ELineAttributes oldLineAttributes = lineAttributes;
		lineAttributes = newLineAttributes;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.FLAECHEN_FORM__LINE_ATTRIBUTES, oldLineAttributes, newLineAttributes);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == Located.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.FLAECHEN_FORM__LOCATION:
				return GefPackage.LOCATED__LOCATION;
			default:
				return -1;
			}
		}
		if (baseClass == ZoomableForm.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.FLAECHEN_FORM__ZOOM_VERHALTEN:
				return DoeditorPackage.ZOOMABLE_FORM__ZOOM_VERHALTEN;
			default:
				return -1;
			}
		}
		if (baseClass == Sized.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.FLAECHEN_FORM__SIZE:
				return GefPackage.SIZED__SIZE;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
		case DoeditorPackage.FLAECHEN_FORM__EDITOR_DO_TYP:
			return eInternalContainer().eInverseRemove(this, DoeditorPackage.EDITOR_DO_TYP__FORMEN, EditorDoTyp.class,
					msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == Located.class) {
			switch (baseFeatureID) {
			case GefPackage.LOCATED__LOCATION:
				return DoeditorPackage.FLAECHEN_FORM__LOCATION;
			default:
				return -1;
			}
		}
		if (baseClass == ZoomableForm.class) {
			switch (baseFeatureID) {
			case DoeditorPackage.ZOOMABLE_FORM__ZOOM_VERHALTEN:
				return DoeditorPackage.FLAECHEN_FORM__ZOOM_VERHALTEN;
			default:
				return -1;
			}
		}
		if (baseClass == Sized.class) {
			switch (baseFeatureID) {
			case GefPackage.SIZED__SIZE:
				return DoeditorPackage.FLAECHEN_FORM__SIZE;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DoeditorPackage.FLAECHEN_FORM__LOCATION:
			return getLocation();
		case DoeditorPackage.FLAECHEN_FORM__EDITOR_DO_TYP:
			return getEditorDoTyp();
		case DoeditorPackage.FLAECHEN_FORM__VISIBLE:
			return isVisible();
		case DoeditorPackage.FLAECHEN_FORM__DECORATORS:
			return getDecorators();
		case DoeditorPackage.FLAECHEN_FORM__ANGLE:
			return getAngle();
		case DoeditorPackage.FLAECHEN_FORM__ZOOM_VERHALTEN:
			return getZoomVerhalten();
		case DoeditorPackage.FLAECHEN_FORM__POSITIONIERUNG:
			return getPositionierung();
		case DoeditorPackage.FLAECHEN_FORM__BOUNDS:
			return getBounds();
		case DoeditorPackage.FLAECHEN_FORM__FOREGROUND_COLOR:
			return getForegroundColor();
		case DoeditorPackage.FLAECHEN_FORM__LINE_ATTRIBUTES:
			return getLineAttributes();
		case DoeditorPackage.FLAECHEN_FORM__SIZE:
			return getSize();
		case DoeditorPackage.FLAECHEN_FORM__BACKGROUND_PATTERN:
			return getBackgroundPattern();
		case DoeditorPackage.FLAECHEN_FORM__FILLED:
			return isFilled();
		case DoeditorPackage.FLAECHEN_FORM__BACKGROUND_COLOR:
			return getBackgroundColor();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DoeditorPackage.FLAECHEN_FORM__EDITOR_DO_TYP:
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			return basicSetEditorDoTyp((EditorDoTyp) otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DoeditorPackage.FLAECHEN_FORM__EDITOR_DO_TYP:
			return basicSetEditorDoTyp(null, msgs);
		case DoeditorPackage.FLAECHEN_FORM__DECORATORS:
			return ((InternalEList<?>) getDecorators()).basicRemove(otherEnd, msgs);
		case DoeditorPackage.FLAECHEN_FORM__FOREGROUND_COLOR:
			return basicSetForegroundColor(null, msgs);
		case DoeditorPackage.FLAECHEN_FORM__LINE_ATTRIBUTES:
			return basicSetLineAttributes(null, msgs);
		case DoeditorPackage.FLAECHEN_FORM__BACKGROUND_COLOR:
			return basicSetBackgroundColor(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DoeditorPackage.FLAECHEN_FORM__LOCATION:
			return LOCATION_EDEFAULT == null ? location != null : !LOCATION_EDEFAULT.equals(location);
		case DoeditorPackage.FLAECHEN_FORM__EDITOR_DO_TYP:
			return getEditorDoTyp() != null;
		case DoeditorPackage.FLAECHEN_FORM__VISIBLE:
			return visible != VISIBLE_EDEFAULT;
		case DoeditorPackage.FLAECHEN_FORM__DECORATORS:
			return decorators != null && !decorators.isEmpty();
		case DoeditorPackage.FLAECHEN_FORM__ANGLE:
			return angle != ANGLE_EDEFAULT;
		case DoeditorPackage.FLAECHEN_FORM__ZOOM_VERHALTEN:
			return zoomVerhalten != ZOOM_VERHALTEN_EDEFAULT;
		case DoeditorPackage.FLAECHEN_FORM__POSITIONIERUNG:
			return positionierung != POSITIONIERUNG_EDEFAULT;
		case DoeditorPackage.FLAECHEN_FORM__BOUNDS:
			return BOUNDS_EDEFAULT == null ? getBounds() != null : !BOUNDS_EDEFAULT.equals(getBounds());
		case DoeditorPackage.FLAECHEN_FORM__FOREGROUND_COLOR:
			return foregroundColor != null;
		case DoeditorPackage.FLAECHEN_FORM__LINE_ATTRIBUTES:
			return lineAttributes != null;
		case DoeditorPackage.FLAECHEN_FORM__SIZE:
			return SIZE_EDEFAULT == null ? size != null : !SIZE_EDEFAULT.equals(size);
		case DoeditorPackage.FLAECHEN_FORM__BACKGROUND_PATTERN:
			return BACKGROUND_PATTERN_EDEFAULT == null ? backgroundPattern != null
					: !BACKGROUND_PATTERN_EDEFAULT.equals(backgroundPattern);
		case DoeditorPackage.FLAECHEN_FORM__FILLED:
			return filled != FILLED_EDEFAULT;
		case DoeditorPackage.FLAECHEN_FORM__BACKGROUND_COLOR:
			return backgroundColor != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DoeditorPackage.FLAECHEN_FORM__LOCATION:
			setLocation((Point) newValue);
			return;
		case DoeditorPackage.FLAECHEN_FORM__EDITOR_DO_TYP:
			setEditorDoTyp((EditorDoTyp) newValue);
			return;
		case DoeditorPackage.FLAECHEN_FORM__VISIBLE:
			setVisible((Boolean) newValue);
			return;
		case DoeditorPackage.FLAECHEN_FORM__DECORATORS:
			getDecorators().clear();
			getDecorators().addAll((Collection<? extends Decorator>) newValue);
			return;
		case DoeditorPackage.FLAECHEN_FORM__ANGLE:
			setAngle((Double) newValue);
			return;
		case DoeditorPackage.FLAECHEN_FORM__ZOOM_VERHALTEN:
			setZoomVerhalten((ZoomVerhalten) newValue);
			return;
		case DoeditorPackage.FLAECHEN_FORM__POSITIONIERUNG:
			setPositionierung((Positionierung) newValue);
			return;
		case DoeditorPackage.FLAECHEN_FORM__BOUNDS:
			setBounds((Rectangle) newValue);
			return;
		case DoeditorPackage.FLAECHEN_FORM__FOREGROUND_COLOR:
			setForegroundColor((EColor) newValue);
			return;
		case DoeditorPackage.FLAECHEN_FORM__LINE_ATTRIBUTES:
			setLineAttributes((ELineAttributes) newValue);
			return;
		case DoeditorPackage.FLAECHEN_FORM__SIZE:
			setSize((Dimension) newValue);
			return;
		case DoeditorPackage.FLAECHEN_FORM__BACKGROUND_PATTERN:
			setBackgroundPattern((PortableBitMap) newValue);
			return;
		case DoeditorPackage.FLAECHEN_FORM__FILLED:
			setFilled((Boolean) newValue);
			return;
		case DoeditorPackage.FLAECHEN_FORM__BACKGROUND_COLOR:
			setBackgroundColor((EColor) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DoeditorPackage.Literals.FLAECHEN_FORM;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DoeditorPackage.FLAECHEN_FORM__LOCATION:
			setLocation(LOCATION_EDEFAULT);
			return;
		case DoeditorPackage.FLAECHEN_FORM__EDITOR_DO_TYP:
			setEditorDoTyp((EditorDoTyp) null);
			return;
		case DoeditorPackage.FLAECHEN_FORM__VISIBLE:
			setVisible(VISIBLE_EDEFAULT);
			return;
		case DoeditorPackage.FLAECHEN_FORM__DECORATORS:
			getDecorators().clear();
			return;
		case DoeditorPackage.FLAECHEN_FORM__ANGLE:
			setAngle(ANGLE_EDEFAULT);
			return;
		case DoeditorPackage.FLAECHEN_FORM__ZOOM_VERHALTEN:
			setZoomVerhalten(ZOOM_VERHALTEN_EDEFAULT);
			return;
		case DoeditorPackage.FLAECHEN_FORM__POSITIONIERUNG:
			setPositionierung(POSITIONIERUNG_EDEFAULT);
			return;
		case DoeditorPackage.FLAECHEN_FORM__BOUNDS:
			setBounds(BOUNDS_EDEFAULT);
			return;
		case DoeditorPackage.FLAECHEN_FORM__FOREGROUND_COLOR:
			setForegroundColor((EColor) null);
			return;
		case DoeditorPackage.FLAECHEN_FORM__LINE_ATTRIBUTES:
			setLineAttributes((ELineAttributes) null);
			return;
		case DoeditorPackage.FLAECHEN_FORM__SIZE:
			setSize(SIZE_EDEFAULT);
			return;
		case DoeditorPackage.FLAECHEN_FORM__BACKGROUND_PATTERN:
			setBackgroundPattern(BACKGROUND_PATTERN_EDEFAULT);
			return;
		case DoeditorPackage.FLAECHEN_FORM__FILLED:
			setFilled(FILLED_EDEFAULT);
			return;
		case DoeditorPackage.FLAECHEN_FORM__BACKGROUND_COLOR:
			setBackgroundColor((EColor) null);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getAngle() {
		return angle;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EColor getBackgroundColor() {
		return backgroundColor;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PortableBitMap getBackgroundPattern() {
		return backgroundPattern;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public Rectangle getBounds() {
		return new Rectangle(getLocation(), getSize());
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Decorator> getDecorators() {
		if (decorators == null) {
			decorators = new EObjectContainmentEList<Decorator>(Decorator.class, this,
					DoeditorPackage.FLAECHEN_FORM__DECORATORS);
		}
		return decorators;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EditorDoTyp getEditorDoTyp() {
		if (eContainerFeatureID() != DoeditorPackage.FLAECHEN_FORM__EDITOR_DO_TYP)
			return null;
		return (EditorDoTyp) eInternalContainer();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EColor getForegroundColor() {
		return foregroundColor;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ELineAttributes getLineAttributes() {
		return lineAttributes;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Point getLocation() {
		return location;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Positionierung getPositionierung() {
		return positionierung;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Dimension getSize() {
		return size;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ZoomVerhalten getZoomVerhalten() {
		return zoomVerhalten;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFilled() {
		return filled;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isVisible() {
		return visible;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAngle(double newAngle) {
		double oldAngle = angle;
		angle = newAngle;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.FLAECHEN_FORM__ANGLE, oldAngle,
					angle));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setBackgroundColor(EColor newBackgroundColor) {
		if (newBackgroundColor != backgroundColor) {
			NotificationChain msgs = null;
			if (backgroundColor != null)
				msgs = ((InternalEObject) backgroundColor).eInverseRemove(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.FLAECHEN_FORM__BACKGROUND_COLOR, null, msgs);
			if (newBackgroundColor != null)
				msgs = ((InternalEObject) newBackgroundColor).eInverseAdd(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.FLAECHEN_FORM__BACKGROUND_COLOR, null, msgs);
			msgs = basicSetBackgroundColor(newBackgroundColor, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.FLAECHEN_FORM__BACKGROUND_COLOR,
					newBackgroundColor, newBackgroundColor));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setBackgroundPattern(PortableBitMap newBackgroundPattern) {
		PortableBitMap oldBackgroundPattern = backgroundPattern;
		backgroundPattern = newBackgroundPattern;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.FLAECHEN_FORM__BACKGROUND_PATTERN,
					oldBackgroundPattern, backgroundPattern));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public void setBounds(final Rectangle newBounds) {
		setLocation(newBounds.getLocation());
		setSize(newBounds.getSize());
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEditorDoTyp(EditorDoTyp newEditorDoTyp) {
		if (newEditorDoTyp != eInternalContainer()
				|| (eContainerFeatureID() != DoeditorPackage.FLAECHEN_FORM__EDITOR_DO_TYP && newEditorDoTyp != null)) {
			if (EcoreUtil.isAncestor(this, newEditorDoTyp))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newEditorDoTyp != null)
				msgs = ((InternalEObject) newEditorDoTyp).eInverseAdd(this, DoeditorPackage.EDITOR_DO_TYP__FORMEN,
						EditorDoTyp.class, msgs);
			msgs = basicSetEditorDoTyp(newEditorDoTyp, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.FLAECHEN_FORM__EDITOR_DO_TYP,
					newEditorDoTyp, newEditorDoTyp));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setFilled(boolean newFilled) {
		boolean oldFilled = filled;
		filled = newFilled;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.FLAECHEN_FORM__FILLED, oldFilled,
					filled));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setForegroundColor(EColor newForegroundColor) {
		if (newForegroundColor != foregroundColor) {
			NotificationChain msgs = null;
			if (foregroundColor != null)
				msgs = ((InternalEObject) foregroundColor).eInverseRemove(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.FLAECHEN_FORM__FOREGROUND_COLOR, null, msgs);
			if (newForegroundColor != null)
				msgs = ((InternalEObject) newForegroundColor).eInverseAdd(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.FLAECHEN_FORM__FOREGROUND_COLOR, null, msgs);
			msgs = basicSetForegroundColor(newForegroundColor, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.FLAECHEN_FORM__FOREGROUND_COLOR,
					newForegroundColor, newForegroundColor));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLineAttributes(ELineAttributes newLineAttributes) {
		if (newLineAttributes != lineAttributes) {
			NotificationChain msgs = null;
			if (lineAttributes != null)
				msgs = ((InternalEObject) lineAttributes).eInverseRemove(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.FLAECHEN_FORM__LINE_ATTRIBUTES, null, msgs);
			if (newLineAttributes != null)
				msgs = ((InternalEObject) newLineAttributes).eInverseAdd(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.FLAECHEN_FORM__LINE_ATTRIBUTES, null, msgs);
			msgs = basicSetLineAttributes(newLineAttributes, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.FLAECHEN_FORM__LINE_ATTRIBUTES,
					newLineAttributes, newLineAttributes));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLocation(Point newLocation) {
		Point oldLocation = location;
		location = newLocation;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.FLAECHEN_FORM__LOCATION, oldLocation,
					location));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPositionierung(Positionierung newPositionierung) {
		Positionierung oldPositionierung = positionierung;
		positionierung = newPositionierung == null ? POSITIONIERUNG_EDEFAULT : newPositionierung;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.FLAECHEN_FORM__POSITIONIERUNG,
					oldPositionierung, positionierung));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSize(Dimension newSize) {
		Dimension oldSize = size;
		size = newSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.FLAECHEN_FORM__SIZE, oldSize, size));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVisible(boolean newVisible) {
		boolean oldVisible = visible;
		visible = newVisible;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.FLAECHEN_FORM__VISIBLE, oldVisible,
					visible));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setZoomVerhalten(ZoomVerhalten newZoomVerhalten) {
		ZoomVerhalten oldZoomVerhalten = zoomVerhalten;
		zoomVerhalten = newZoomVerhalten == null ? ZOOM_VERHALTEN_EDEFAULT : newZoomVerhalten;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.FLAECHEN_FORM__ZOOM_VERHALTEN,
					oldZoomVerhalten, zoomVerhalten));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (location: ");
		result.append(location);
		result.append(", visible: ");
		result.append(visible);
		result.append(", angle: ");
		result.append(angle);
		result.append(", zoomVerhalten: ");
		result.append(zoomVerhalten);
		result.append(", positionierung: ");
		result.append(positionierung);
		result.append(", size: ");
		result.append(size);
		result.append(", backgroundPattern: ");
		result.append(backgroundPattern);
		result.append(", filled: ");
		result.append(filled);
		result.append(')');
		return result.toString();
	}

} // FlaechenFormImpl
