/*
 * Rahmenwerk-Plug-in "Darstellungsobjekttyp-Editor"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EFont;

import de.bsvrz.buv.plugin.doeditor.model.Decorator;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.FontDataZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.IntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ZoomDecorator;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Font Data Zoom Decorator</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.FontDataZoomDecoratorImpl#getFont <em>Font</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.FontDataZoomDecoratorImpl#getStart <em>Start</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.FontDataZoomDecoratorImpl#getEnd <em>End</em>}</li>
 * </ul>
 *
 * @generated
 */
public class FontDataZoomDecoratorImpl extends EObjectImpl implements FontDataZoomDecorator {
	/**
	 * The cached value of the '{@link #getFont() <em>Font</em>}' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getFont()
	 * @generated
	 * @ordered
	 */
	protected EFont font;

	/**
	 * The default value of the '{@link #getStart() <em>Start</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getStart()
	 * @generated
	 * @ordered
	 */
	protected static final double START_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getStart() <em>Start</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getStart()
	 * @generated
	 * @ordered
	 */
	protected double start = START_EDEFAULT;

	/**
	 * The default value of the '{@link #getEnd() <em>End</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getEnd()
	 * @generated
	 * @ordered
	 */
	protected static final double END_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getEnd() <em>End</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getEnd()
	 * @generated
	 * @ordered
	 */
	protected double end = END_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected FontDataZoomDecoratorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DoeditorPackage.Literals.FONT_DATA_ZOOM_DECORATOR;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EFont getFont() {
		return font;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetFont(EFont newFont, NotificationChain msgs) {
		EFont oldFont = font;
		font = newFont;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__FONT, oldFont, newFont);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setFont(EFont newFont) {
		if (newFont != font) {
			NotificationChain msgs = null;
			if (font != null)
				msgs = ((InternalEObject) font).eInverseRemove(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__FONT, null, msgs);
			if (newFont != null)
				msgs = ((InternalEObject) newFont).eInverseAdd(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__FONT, null, msgs);
			msgs = basicSetFont(newFont, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__FONT,
					newFont, newFont));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getStart() {
		return start;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStart(double newStart) {
		double oldStart = start;
		start = newStart;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__START,
					oldStart, start));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getEnd() {
		return end;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEnd(double newEnd) {
		double oldEnd = end;
		end = newEnd;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__END, oldEnd,
					end));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__FONT:
			return basicSetFont(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__FONT:
			return getFont();
		case DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__START:
			return getStart();
		case DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__END:
			return getEnd();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__FONT:
			setFont((EFont) newValue);
			return;
		case DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__START:
			setStart((Double) newValue);
			return;
		case DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__END:
			setEnd((Double) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__FONT:
			setFont((EFont) null);
			return;
		case DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__START:
			setStart(START_EDEFAULT);
			return;
		case DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__END:
			setEnd(END_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__FONT:
			return font != null;
		case DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__START:
			return start != START_EDEFAULT;
		case DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__END:
			return end != END_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == Decorator.class) {
			switch (derivedFeatureID) {
			default:
				return -1;
			}
		}
		if (baseClass == IntervalDecorator.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__START:
				return DoeditorPackage.INTERVAL_DECORATOR__START;
			case DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__END:
				return DoeditorPackage.INTERVAL_DECORATOR__END;
			default:
				return -1;
			}
		}
		if (baseClass == ZoomDecorator.class) {
			switch (derivedFeatureID) {
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == Decorator.class) {
			switch (baseFeatureID) {
			default:
				return -1;
			}
		}
		if (baseClass == IntervalDecorator.class) {
			switch (baseFeatureID) {
			case DoeditorPackage.INTERVAL_DECORATOR__START:
				return DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__START;
			case DoeditorPackage.INTERVAL_DECORATOR__END:
				return DoeditorPackage.FONT_DATA_ZOOM_DECORATOR__END;
			default:
				return -1;
			}
		}
		if (baseClass == ZoomDecorator.class) {
			switch (baseFeatureID) {
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (start: ");
		result.append(start);
		result.append(", end: ");
		result.append(end);
		result.append(')');
		return result.toString();
	}

} // FontDataZoomDecoratorImpl
