/*
 * Rahmenwerk-Plug-in "Darstellungsobjekttyp-Editor"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.model.impl;

import java.util.Collection;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EColor;
import com.bitctrl.lib.eclipse.emf.eclipse.model.ELineAttributes;
import com.bitctrl.lib.eclipse.emf.eclipse.model.impl.NamedImpl;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;
import com.bitctrl.lib.eclipse.emf.gef.model.Located;

import de.bsvrz.buv.plugin.doeditor.model.Decorator;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp;
import de.bsvrz.buv.plugin.doeditor.model.PolylineForm;
import de.bsvrz.buv.plugin.doeditor.model.Positionierung;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhalten;
import de.bsvrz.buv.plugin.doeditor.model.ZoomableForm;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Polyline Form</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.PolylineFormImpl#getLocation <em>Location</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.PolylineFormImpl#getEditorDoTyp <em>Editor Do Typ</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.PolylineFormImpl#isVisible <em>Visible</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.PolylineFormImpl#getDecorators <em>Decorators</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.PolylineFormImpl#getAngle <em>Angle</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.PolylineFormImpl#getZoomVerhalten <em>Zoom Verhalten</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.PolylineFormImpl#getPositionierung <em>Positionierung</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.PolylineFormImpl#getBounds <em>Bounds</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.PolylineFormImpl#getForegroundColor <em>Foreground Color</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.PolylineFormImpl#getLineAttributes <em>Line Attributes</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.PolylineFormImpl#getPoints <em>Points</em>}</li>
 * </ul>
 *
 * @generated
 */
public class PolylineFormImpl extends NamedImpl implements PolylineForm {
	/**
	 * The default value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected static final Point LOCATION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected Point location = LOCATION_EDEFAULT;

	/**
	 * The default value of the '{@link #isVisible() <em>Visible</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isVisible()
	 * @generated
	 * @ordered
	 */
	protected static final boolean VISIBLE_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isVisible() <em>Visible</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isVisible()
	 * @generated
	 * @ordered
	 */
	protected boolean visible = VISIBLE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDecorators() <em>Decorators</em>}' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getDecorators()
	 * @generated
	 * @ordered
	 */
	protected EList<Decorator> decorators;

	/**
	 * The default value of the '{@link #getAngle() <em>Angle</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getAngle()
	 * @generated
	 * @ordered
	 */
	protected static final double ANGLE_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getAngle() <em>Angle</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getAngle()
	 * @generated
	 * @ordered
	 */
	protected double angle = ANGLE_EDEFAULT;

	/**
	 * The default value of the '{@link #getZoomVerhalten() <em>Zoom Verhalten</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getZoomVerhalten()
	 * @generated
	 * @ordered
	 */
	protected static final ZoomVerhalten ZOOM_VERHALTEN_EDEFAULT = ZoomVerhalten.DYNAMISCH;

	/**
	 * The cached value of the '{@link #getZoomVerhalten() <em>Zoom Verhalten</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getZoomVerhalten()
	 * @generated
	 * @ordered
	 */
	protected ZoomVerhalten zoomVerhalten = ZOOM_VERHALTEN_EDEFAULT;

	/**
	 * The default value of the '{@link #getPositionierung() <em>Positionierung</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getPositionierung()
	 * @generated
	 * @ordered
	 */
	protected static final Positionierung POSITIONIERUNG_EDEFAULT = Positionierung.LINKS_OBEN;

	/**
	 * The cached value of the '{@link #getPositionierung() <em>Positionierung</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getPositionierung()
	 * @generated
	 * @ordered
	 */
	protected Positionierung positionierung = POSITIONIERUNG_EDEFAULT;

	/**
	 * The default value of the '{@link #getBounds() <em>Bounds</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getBounds()
	 * @generated
	 * @ordered
	 */
	protected static final Rectangle BOUNDS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getForegroundColor() <em>Foreground Color</em>}' containment reference.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #getForegroundColor()
	 * @generated
	 * @ordered
	 */
	protected EColor foregroundColor;

	/**
	 * The cached value of the '{@link #getLineAttributes() <em>Line Attributes</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLineAttributes()
	 * @generated
	 * @ordered
	 */
	protected ELineAttributes lineAttributes;

	/**
	 * The default value of the '{@link #getPoints() <em>Points</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getPoints()
	 * @generated
	 * @ordered
	 */
	protected static final PointList POINTS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPoints() <em>Points</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getPoints()
	 * @generated
	 * @ordered
	 */
	protected PointList points = POINTS_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected PolylineFormImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetEditorDoTyp(EditorDoTyp newEditorDoTyp, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject) newEditorDoTyp, DoeditorPackage.POLYLINE_FORM__EDITOR_DO_TYP, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetForegroundColor(EColor newForegroundColor, NotificationChain msgs) {
		EColor oldForegroundColor = foregroundColor;
		foregroundColor = newForegroundColor;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.POLYLINE_FORM__FOREGROUND_COLOR, oldForegroundColor, newForegroundColor);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLineAttributes(ELineAttributes newLineAttributes, NotificationChain msgs) {
		ELineAttributes oldLineAttributes = lineAttributes;
		lineAttributes = newLineAttributes;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.POLYLINE_FORM__LINE_ATTRIBUTES, oldLineAttributes, newLineAttributes);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == Located.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.POLYLINE_FORM__LOCATION:
				return GefPackage.LOCATED__LOCATION;
			default:
				return -1;
			}
		}
		if (baseClass == ZoomableForm.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.POLYLINE_FORM__ZOOM_VERHALTEN:
				return DoeditorPackage.ZOOMABLE_FORM__ZOOM_VERHALTEN;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
		case DoeditorPackage.POLYLINE_FORM__EDITOR_DO_TYP:
			return eInternalContainer().eInverseRemove(this, DoeditorPackage.EDITOR_DO_TYP__FORMEN, EditorDoTyp.class,
					msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == Located.class) {
			switch (baseFeatureID) {
			case GefPackage.LOCATED__LOCATION:
				return DoeditorPackage.POLYLINE_FORM__LOCATION;
			default:
				return -1;
			}
		}
		if (baseClass == ZoomableForm.class) {
			switch (baseFeatureID) {
			case DoeditorPackage.ZOOMABLE_FORM__ZOOM_VERHALTEN:
				return DoeditorPackage.POLYLINE_FORM__ZOOM_VERHALTEN;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DoeditorPackage.POLYLINE_FORM__LOCATION:
			return getLocation();
		case DoeditorPackage.POLYLINE_FORM__EDITOR_DO_TYP:
			return getEditorDoTyp();
		case DoeditorPackage.POLYLINE_FORM__VISIBLE:
			return isVisible();
		case DoeditorPackage.POLYLINE_FORM__DECORATORS:
			return getDecorators();
		case DoeditorPackage.POLYLINE_FORM__ANGLE:
			return getAngle();
		case DoeditorPackage.POLYLINE_FORM__ZOOM_VERHALTEN:
			return getZoomVerhalten();
		case DoeditorPackage.POLYLINE_FORM__POSITIONIERUNG:
			return getPositionierung();
		case DoeditorPackage.POLYLINE_FORM__BOUNDS:
			return getBounds();
		case DoeditorPackage.POLYLINE_FORM__FOREGROUND_COLOR:
			return getForegroundColor();
		case DoeditorPackage.POLYLINE_FORM__LINE_ATTRIBUTES:
			return getLineAttributes();
		case DoeditorPackage.POLYLINE_FORM__POINTS:
			return getPoints();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DoeditorPackage.POLYLINE_FORM__EDITOR_DO_TYP:
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			return basicSetEditorDoTyp((EditorDoTyp) otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DoeditorPackage.POLYLINE_FORM__EDITOR_DO_TYP:
			return basicSetEditorDoTyp(null, msgs);
		case DoeditorPackage.POLYLINE_FORM__DECORATORS:
			return ((InternalEList<?>) getDecorators()).basicRemove(otherEnd, msgs);
		case DoeditorPackage.POLYLINE_FORM__FOREGROUND_COLOR:
			return basicSetForegroundColor(null, msgs);
		case DoeditorPackage.POLYLINE_FORM__LINE_ATTRIBUTES:
			return basicSetLineAttributes(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DoeditorPackage.POLYLINE_FORM__LOCATION:
			return LOCATION_EDEFAULT == null ? location != null : !LOCATION_EDEFAULT.equals(location);
		case DoeditorPackage.POLYLINE_FORM__EDITOR_DO_TYP:
			return getEditorDoTyp() != null;
		case DoeditorPackage.POLYLINE_FORM__VISIBLE:
			return visible != VISIBLE_EDEFAULT;
		case DoeditorPackage.POLYLINE_FORM__DECORATORS:
			return decorators != null && !decorators.isEmpty();
		case DoeditorPackage.POLYLINE_FORM__ANGLE:
			return angle != ANGLE_EDEFAULT;
		case DoeditorPackage.POLYLINE_FORM__ZOOM_VERHALTEN:
			return zoomVerhalten != ZOOM_VERHALTEN_EDEFAULT;
		case DoeditorPackage.POLYLINE_FORM__POSITIONIERUNG:
			return positionierung != POSITIONIERUNG_EDEFAULT;
		case DoeditorPackage.POLYLINE_FORM__BOUNDS:
			return BOUNDS_EDEFAULT == null ? getBounds() != null : !BOUNDS_EDEFAULT.equals(getBounds());
		case DoeditorPackage.POLYLINE_FORM__FOREGROUND_COLOR:
			return foregroundColor != null;
		case DoeditorPackage.POLYLINE_FORM__LINE_ATTRIBUTES:
			return lineAttributes != null;
		case DoeditorPackage.POLYLINE_FORM__POINTS:
			return POINTS_EDEFAULT == null ? points != null : !POINTS_EDEFAULT.equals(points);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DoeditorPackage.POLYLINE_FORM__LOCATION:
			setLocation((Point) newValue);
			return;
		case DoeditorPackage.POLYLINE_FORM__EDITOR_DO_TYP:
			setEditorDoTyp((EditorDoTyp) newValue);
			return;
		case DoeditorPackage.POLYLINE_FORM__VISIBLE:
			setVisible((Boolean) newValue);
			return;
		case DoeditorPackage.POLYLINE_FORM__DECORATORS:
			getDecorators().clear();
			getDecorators().addAll((Collection<? extends Decorator>) newValue);
			return;
		case DoeditorPackage.POLYLINE_FORM__ANGLE:
			setAngle((Double) newValue);
			return;
		case DoeditorPackage.POLYLINE_FORM__ZOOM_VERHALTEN:
			setZoomVerhalten((ZoomVerhalten) newValue);
			return;
		case DoeditorPackage.POLYLINE_FORM__POSITIONIERUNG:
			setPositionierung((Positionierung) newValue);
			return;
		case DoeditorPackage.POLYLINE_FORM__BOUNDS:
			setBounds((Rectangle) newValue);
			return;
		case DoeditorPackage.POLYLINE_FORM__FOREGROUND_COLOR:
			setForegroundColor((EColor) newValue);
			return;
		case DoeditorPackage.POLYLINE_FORM__LINE_ATTRIBUTES:
			setLineAttributes((ELineAttributes) newValue);
			return;
		case DoeditorPackage.POLYLINE_FORM__POINTS:
			setPoints((PointList) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DoeditorPackage.Literals.POLYLINE_FORM;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DoeditorPackage.POLYLINE_FORM__LOCATION:
			setLocation(LOCATION_EDEFAULT);
			return;
		case DoeditorPackage.POLYLINE_FORM__EDITOR_DO_TYP:
			setEditorDoTyp((EditorDoTyp) null);
			return;
		case DoeditorPackage.POLYLINE_FORM__VISIBLE:
			setVisible(VISIBLE_EDEFAULT);
			return;
		case DoeditorPackage.POLYLINE_FORM__DECORATORS:
			getDecorators().clear();
			return;
		case DoeditorPackage.POLYLINE_FORM__ANGLE:
			setAngle(ANGLE_EDEFAULT);
			return;
		case DoeditorPackage.POLYLINE_FORM__ZOOM_VERHALTEN:
			setZoomVerhalten(ZOOM_VERHALTEN_EDEFAULT);
			return;
		case DoeditorPackage.POLYLINE_FORM__POSITIONIERUNG:
			setPositionierung(POSITIONIERUNG_EDEFAULT);
			return;
		case DoeditorPackage.POLYLINE_FORM__BOUNDS:
			setBounds(BOUNDS_EDEFAULT);
			return;
		case DoeditorPackage.POLYLINE_FORM__FOREGROUND_COLOR:
			setForegroundColor((EColor) null);
			return;
		case DoeditorPackage.POLYLINE_FORM__LINE_ATTRIBUTES:
			setLineAttributes((ELineAttributes) null);
			return;
		case DoeditorPackage.POLYLINE_FORM__POINTS:
			setPoints(POINTS_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getAngle() {
		return angle;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public Rectangle getBounds() {
		return new Rectangle(getPoints().getBounds());
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Decorator> getDecorators() {
		if (decorators == null) {
			decorators = new EObjectContainmentEList<Decorator>(Decorator.class, this,
					DoeditorPackage.POLYLINE_FORM__DECORATORS);
		}
		return decorators;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EditorDoTyp getEditorDoTyp() {
		if (eContainerFeatureID() != DoeditorPackage.POLYLINE_FORM__EDITOR_DO_TYP)
			return null;
		return (EditorDoTyp) eInternalContainer();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EColor getForegroundColor() {
		return foregroundColor;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ELineAttributes getLineAttributes() {
		return lineAttributes;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Point getLocation() {
		return location;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PointList getPoints() {
		return points;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Positionierung getPositionierung() {
		return positionierung;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ZoomVerhalten getZoomVerhalten() {
		return zoomVerhalten;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isVisible() {
		return visible;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAngle(double newAngle) {
		double oldAngle = angle;
		angle = newAngle;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.POLYLINE_FORM__ANGLE, oldAngle,
					angle));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public void setBounds(final Rectangle newBounds) {
		if (newBounds != null) {
			setLocation(newBounds.getLocation());
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEditorDoTyp(EditorDoTyp newEditorDoTyp) {
		if (newEditorDoTyp != eInternalContainer()
				|| (eContainerFeatureID() != DoeditorPackage.POLYLINE_FORM__EDITOR_DO_TYP && newEditorDoTyp != null)) {
			if (EcoreUtil.isAncestor(this, newEditorDoTyp))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newEditorDoTyp != null)
				msgs = ((InternalEObject) newEditorDoTyp).eInverseAdd(this, DoeditorPackage.EDITOR_DO_TYP__FORMEN,
						EditorDoTyp.class, msgs);
			msgs = basicSetEditorDoTyp(newEditorDoTyp, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.POLYLINE_FORM__EDITOR_DO_TYP,
					newEditorDoTyp, newEditorDoTyp));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setForegroundColor(EColor newForegroundColor) {
		if (newForegroundColor != foregroundColor) {
			NotificationChain msgs = null;
			if (foregroundColor != null)
				msgs = ((InternalEObject) foregroundColor).eInverseRemove(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.POLYLINE_FORM__FOREGROUND_COLOR, null, msgs);
			if (newForegroundColor != null)
				msgs = ((InternalEObject) newForegroundColor).eInverseAdd(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.POLYLINE_FORM__FOREGROUND_COLOR, null, msgs);
			msgs = basicSetForegroundColor(newForegroundColor, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.POLYLINE_FORM__FOREGROUND_COLOR,
					newForegroundColor, newForegroundColor));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLineAttributes(ELineAttributes newLineAttributes) {
		if (newLineAttributes != lineAttributes) {
			NotificationChain msgs = null;
			if (lineAttributes != null)
				msgs = ((InternalEObject) lineAttributes).eInverseRemove(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.POLYLINE_FORM__LINE_ATTRIBUTES, null, msgs);
			if (newLineAttributes != null)
				msgs = ((InternalEObject) newLineAttributes).eInverseAdd(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.POLYLINE_FORM__LINE_ATTRIBUTES, null, msgs);
			msgs = basicSetLineAttributes(newLineAttributes, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.POLYLINE_FORM__LINE_ATTRIBUTES,
					newLineAttributes, newLineAttributes));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public void setLocation(final Point newLocation) {
		Point oldLocation = location;
		if (oldLocation == null && points != null) {
			oldLocation = points.getBounds().getLocation();
		}
		location = newLocation;
		if (oldLocation != null) {
			points.performTranslate(newLocation.x - oldLocation.x, newLocation.y - oldLocation.y);
		}

		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.POLYLINE_FORM__LOCATION, oldLocation,
					location));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public void setPoints(final PointList newPoints) {
		final PointList oldPoints = points;
		points = newPoints;
		if (points != null) {
			location = points.getBounds().getLocation();
		} else {
			location = new Point();
		}
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.POLYLINE_FORM__POINTS, oldPoints,
					points));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPositionierung(Positionierung newPositionierung) {
		Positionierung oldPositionierung = positionierung;
		positionierung = newPositionierung == null ? POSITIONIERUNG_EDEFAULT : newPositionierung;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.POLYLINE_FORM__POSITIONIERUNG,
					oldPositionierung, positionierung));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVisible(boolean newVisible) {
		boolean oldVisible = visible;
		visible = newVisible;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.POLYLINE_FORM__VISIBLE, oldVisible,
					visible));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setZoomVerhalten(ZoomVerhalten newZoomVerhalten) {
		ZoomVerhalten oldZoomVerhalten = zoomVerhalten;
		zoomVerhalten = newZoomVerhalten == null ? ZOOM_VERHALTEN_EDEFAULT : newZoomVerhalten;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.POLYLINE_FORM__ZOOM_VERHALTEN,
					oldZoomVerhalten, zoomVerhalten));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (location: ");
		result.append(location);
		result.append(", visible: ");
		result.append(visible);
		result.append(", angle: ");
		result.append(angle);
		result.append(", zoomVerhalten: ");
		result.append(zoomVerhalten);
		result.append(", positionierung: ");
		result.append(positionierung);
		result.append(", points: ");
		result.append(points);
		result.append(')');
		return result.toString();
	}

} // PolylineFormImpl
