/*
 * Rahmenwerk-Plug-in "Darstellungsobjekttyp-Editor"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhalten;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenParameterDefinition;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Zoom Verhalten Attribute Text Decorator</b></em>'. <!-- end-user-doc
 * -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>
 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.ZoomVerhaltenAttributeTextDecoratorImpl#getDefaultValue
 * <em>Default Value</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.ZoomVerhaltenAttributeTextDecoratorImpl#getParameter
 * <em>Parameter</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class ZoomVerhaltenAttributeTextDecoratorImpl extends AttributeTextDecoratorImpl
		implements ZoomVerhaltenAttributeTextDecorator {
	/**
	 * The default value of the '{@link #getZoomVerhalten() <em>Zoom Verhalten</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getZoomVerhalten()
	 * @generated
	 * @ordered
	 */
	protected static final ZoomVerhalten ZOOM_VERHALTEN_EDEFAULT = ZoomVerhalten.DYNAMISCH;

	/**
	 * The cached value of the '{@link #getZoomVerhalten() <em>Zoom Verhalten</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getZoomVerhalten()
	 * @generated
	 * @ordered
	 */
	protected ZoomVerhalten zoomVerhalten = ZOOM_VERHALTEN_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ZoomVerhaltenAttributeTextDecoratorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DoeditorPackage.Literals.ZOOM_VERHALTEN_ATTRIBUTE_TEXT_DECORATOR;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ZoomVerhalten getZoomVerhalten() {
		return zoomVerhalten;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setZoomVerhalten(ZoomVerhalten newZoomVerhalten) {
		ZoomVerhalten oldZoomVerhalten = zoomVerhalten;
		zoomVerhalten = newZoomVerhalten == null ? ZOOM_VERHALTEN_EDEFAULT : newZoomVerhalten;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.ZOOM_VERHALTEN_ATTRIBUTE_TEXT_DECORATOR__ZOOM_VERHALTEN, oldZoomVerhalten,
					zoomVerhalten));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DoeditorPackage.ZOOM_VERHALTEN_ATTRIBUTE_TEXT_DECORATOR__ZOOM_VERHALTEN:
			return getZoomVerhalten();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DoeditorPackage.ZOOM_VERHALTEN_ATTRIBUTE_TEXT_DECORATOR__ZOOM_VERHALTEN:
			setZoomVerhalten((ZoomVerhalten) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DoeditorPackage.ZOOM_VERHALTEN_ATTRIBUTE_TEXT_DECORATOR__ZOOM_VERHALTEN:
			setZoomVerhalten(ZOOM_VERHALTEN_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DoeditorPackage.ZOOM_VERHALTEN_ATTRIBUTE_TEXT_DECORATOR__ZOOM_VERHALTEN:
			return zoomVerhalten != ZOOM_VERHALTEN_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == ParameterDefinition.class) {
			switch (derivedFeatureID) {
			default:
				return -1;
			}
		}
		if (baseClass == ZoomVerhaltenParameterDefinition.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.ZOOM_VERHALTEN_ATTRIBUTE_TEXT_DECORATOR__ZOOM_VERHALTEN:
				return DoeditorPackage.ZOOM_VERHALTEN_PARAMETER_DEFINITION__ZOOM_VERHALTEN;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == ParameterDefinition.class) {
			switch (baseFeatureID) {
			default:
				return -1;
			}
		}
		if (baseClass == ZoomVerhaltenParameterDefinition.class) {
			switch (baseFeatureID) {
			case DoeditorPackage.ZOOM_VERHALTEN_PARAMETER_DEFINITION__ZOOM_VERHALTEN:
				return DoeditorPackage.ZOOM_VERHALTEN_ATTRIBUTE_TEXT_DECORATOR__ZOOM_VERHALTEN;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (zoomVerhalten: ");
		result.append(zoomVerhalten);
		result.append(')');
		return result.toString();
	}

} // ZoomVerhaltenAttributeTextDecoratorImpl
