/**
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 * 
 */
package de.bsvrz.buv.plugin.doeditor.model.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import com.bitctrl.lib.eclipse.emf.gef.model.Located;
import com.bitctrl.lib.eclipse.emf.gef.model.Sized;

import de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator;
import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.model.DoKompositum;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.doeditor.model.*;
import de.bsvrz.buv.plugin.doeditor.model.AttributeDecorator;
import de.bsvrz.buv.plugin.doeditor.model.AttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.AttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BackgroundAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BackgroundAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BackgroundParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.BackgroundZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BildForm;
import de.bsvrz.buv.plugin.doeditor.model.BorderColorAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BorderColorAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BorderColorParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.BorderColorZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BorderWidthAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BorderWidthAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BorderWidthParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.BorderWidthZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BorderedForm;
import de.bsvrz.buv.plugin.doeditor.model.ColorParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.Decorator;
import de.bsvrz.buv.plugin.doeditor.model.DoEditorDiagramm;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.DrehwinkelAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.DrehwinkelAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.DrehwinkelParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.DrehwinkelZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoModel;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTypReferenz;
import de.bsvrz.buv.plugin.doeditor.model.EllipseForm;
import de.bsvrz.buv.plugin.doeditor.model.EmbeddedDoForm;
import de.bsvrz.buv.plugin.doeditor.model.ExternalDoForm;
import de.bsvrz.buv.plugin.doeditor.model.FlaechenForm;
import de.bsvrz.buv.plugin.doeditor.model.FontDataAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.FontDataAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.FontDataParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.FontDataZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ForegroundAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ForegroundAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ForegroundParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.ForegroundZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.Identidy;
import de.bsvrz.buv.plugin.doeditor.model.IntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.LineAttributeAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.LineAttributeAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.LineAttributeParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.LineAttributeZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.LinienForm;
import de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.PolygonForm;
import de.bsvrz.buv.plugin.doeditor.model.PolylineForm;
import de.bsvrz.buv.plugin.doeditor.model.PunktForm;
import de.bsvrz.buv.plugin.doeditor.model.RechteckForm;
import de.bsvrz.buv.plugin.doeditor.model.RotatableForm;
import de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.StringAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.StringAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.StringParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.StringZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.TextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.TextForm;
import de.bsvrz.buv.plugin.doeditor.model.VisibleForm;
import de.bsvrz.buv.plugin.doeditor.model.ZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ZoomableForm;

/**
 * <!-- begin-user-doc --> The <b>Adapter Factory</b> for the model. It provides
 * an adapter <code>createXXX</code> method for each class of the model. <!--
 * end-user-doc -->
 * @see de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage
 * @generated
 */
public class DoeditorAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected static DoeditorPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public DoeditorAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = DoeditorPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc --> This implementation returns <code>true</code> if
	 * the object is either the model's package or is an instance object of the
	 * model. <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject) object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected DoeditorSwitch<Adapter> modelSwitch = new DoeditorSwitch<Adapter>() {
		@Override
		public Adapter caseVisibleForm(VisibleForm object) {
			return createVisibleFormAdapter();
		}

		@Override
		public Adapter caseRotatableForm(RotatableForm object) {
			return createRotatableFormAdapter();
		}

		@Override
		public Adapter caseBorderedForm(BorderedForm object) {
			return createBorderedFormAdapter();
		}

		@Override
		public Adapter caseZoomableForm(ZoomableForm object) {
			return createZoomableFormAdapter();
		}

		@Override
		public Adapter casePunktForm(PunktForm object) {
			return createPunktFormAdapter();
		}

		@Override
		public Adapter caseBildForm(BildForm object) {
			return createBildFormAdapter();
		}

		@Override
		public Adapter caseTextForm(TextForm object) {
			return createTextFormAdapter();
		}

		@Override
		public Adapter casePolylineForm(PolylineForm object) {
			return createPolylineFormAdapter();
		}

		@Override
		public Adapter casePolygonForm(PolygonForm object) {
			return createPolygonFormAdapter();
		}

		@Override
		public Adapter caseFlaechenForm(FlaechenForm object) {
			return createFlaechenFormAdapter();
		}

		@Override
		public Adapter caseEllipseForm(EllipseForm object) {
			return createEllipseFormAdapter();
		}

		@Override
		public Adapter caseRechteckForm(RechteckForm object) {
			return createRechteckFormAdapter();
		}

		@Override
		public Adapter caseLinienForm(LinienForm object) {
			return createLinienFormAdapter();
		}

		@Override
		public Adapter caseDecorator(Decorator object) {
			return createDecoratorAdapter();
		}

		@Override
		public Adapter caseTextDecorator(TextDecorator object) {
			return createTextDecoratorAdapter();
		}

		@Override
		public Adapter caseAttributeDecorator(AttributeDecorator object) {
			return createAttributeDecoratorAdapter();
		}

		@Override
		public Adapter caseIntervalDecorator(IntervalDecorator object) {
			return createIntervalDecoratorAdapter();
		}

		@Override
		public Adapter caseZoomDecorator(ZoomDecorator object) {
			return createZoomDecoratorAdapter();
		}

		@Override
		public Adapter caseEditorDoModel(EditorDoModel object) {
			return createEditorDoModelAdapter();
		}

		@Override
		public Adapter caseAttributeTextDecorator(AttributeTextDecorator object) {
			return createAttributeTextDecoratorAdapter();
		}

		@Override
		public Adapter caseAttributeIntervalDecorator(AttributeIntervalDecorator object) {
			return createAttributeIntervalDecoratorAdapter();
		}

		@Override
		public Adapter caseBackgroundAttributeIntervalDecorator(BackgroundAttributeIntervalDecorator object) {
			return createBackgroundAttributeIntervalDecoratorAdapter();
		}

		@Override
		public Adapter caseParameterDefinition(ParameterDefinition object) {
			return createParameterDefinitionAdapter();
		}

		@Override
		public Adapter caseColorParameterDefinition(ColorParameterDefinition object) {
			return createColorParameterDefinitionAdapter();
		}

		@Override
		public Adapter caseBackgroundParameterDefinition(BackgroundParameterDefinition object) {
			return createBackgroundParameterDefinitionAdapter();
		}

		@Override
		public Adapter caseForegroundParameterDefinition(ForegroundParameterDefinition object) {
			return createForegroundParameterDefinitionAdapter();
		}

		@Override
		public Adapter caseBorderColorParameterDefinition(BorderColorParameterDefinition object) {
			return createBorderColorParameterDefinitionAdapter();
		}

		@Override
		public Adapter caseFontDataParameterDefinition(FontDataParameterDefinition object) {
			return createFontDataParameterDefinitionAdapter();
		}

		@Override
		public Adapter caseDrehwinkelParameterDefinition(DrehwinkelParameterDefinition object) {
			return createDrehwinkelParameterDefinitionAdapter();
		}

		@Override
		public Adapter caseLineAttributeParameterDefinition(LineAttributeParameterDefinition object) {
			return createLineAttributeParameterDefinitionAdapter();
		}

		@Override
		public Adapter caseStringParameterDefinition(StringParameterDefinition object) {
			return createStringParameterDefinitionAdapter();
		}

		@Override
		public Adapter caseSichtbarkeitParameterDefinition(SichtbarkeitParameterDefinition object) {
			return createSichtbarkeitParameterDefinitionAdapter();
		}

		@Override
		public Adapter caseZoomVerhaltenParameterDefinition(ZoomVerhaltenParameterDefinition object) {
			return createZoomVerhaltenParameterDefinitionAdapter();
		}

		@Override
		public Adapter caseBackgroundAttributeTextDecorator(BackgroundAttributeTextDecorator object) {
			return createBackgroundAttributeTextDecoratorAdapter();
		}

		@Override
		public Adapter caseBackgroundZoomDecorator(BackgroundZoomDecorator object) {
			return createBackgroundZoomDecoratorAdapter();
		}

		@Override
		public Adapter caseDrehwinkelAttributeTextDecorator(DrehwinkelAttributeTextDecorator object) {
			return createDrehwinkelAttributeTextDecoratorAdapter();
		}

		@Override
		public Adapter caseDrehwinkelAttributeIntervalDecorator(DrehwinkelAttributeIntervalDecorator object) {
			return createDrehwinkelAttributeIntervalDecoratorAdapter();
		}

		@Override
		public Adapter caseDrehwinkelZoomDecorator(DrehwinkelZoomDecorator object) {
			return createDrehwinkelZoomDecoratorAdapter();
		}

		@Override
		public Adapter caseFontDataAttributeIntervalDecorator(FontDataAttributeIntervalDecorator object) {
			return createFontDataAttributeIntervalDecoratorAdapter();
		}

		@Override
		public Adapter caseFontDataAttributeTextDecorator(FontDataAttributeTextDecorator object) {
			return createFontDataAttributeTextDecoratorAdapter();
		}

		@Override
		public Adapter caseFontDataZoomDecorator(FontDataZoomDecorator object) {
			return createFontDataZoomDecoratorAdapter();
		}

		@Override
		public Adapter caseForegroundAttributeTextDecorator(ForegroundAttributeTextDecorator object) {
			return createForegroundAttributeTextDecoratorAdapter();
		}

		@Override
		public Adapter caseForegroundAttributeIntervalDecorator(ForegroundAttributeIntervalDecorator object) {
			return createForegroundAttributeIntervalDecoratorAdapter();
		}

		@Override
		public Adapter caseForegroundZoomDecorator(ForegroundZoomDecorator object) {
			return createForegroundZoomDecoratorAdapter();
		}

		@Override
		public Adapter caseLineAttributeAttributeIntervalDecorator(LineAttributeAttributeIntervalDecorator object) {
			return createLineAttributeAttributeIntervalDecoratorAdapter();
		}

		@Override
		public Adapter caseLineAttributeAttributeTextDecorator(LineAttributeAttributeTextDecorator object) {
			return createLineAttributeAttributeTextDecoratorAdapter();
		}

		@Override
		public Adapter caseLineAttributeZoomDecorator(LineAttributeZoomDecorator object) {
			return createLineAttributeZoomDecoratorAdapter();
		}

		@Override
		public Adapter caseSichtbarkeitAttributeTextDecorator(SichtbarkeitAttributeTextDecorator object) {
			return createSichtbarkeitAttributeTextDecoratorAdapter();
		}

		@Override
		public Adapter caseSichtbarkeitAttributeIntervalDecorator(SichtbarkeitAttributeIntervalDecorator object) {
			return createSichtbarkeitAttributeIntervalDecoratorAdapter();
		}

		@Override
		public Adapter caseSichtbarkeitZoomDecorator(SichtbarkeitZoomDecorator object) {
			return createSichtbarkeitZoomDecoratorAdapter();
		}

		@Override
		public Adapter caseStringAttributeIntervalDecorator(StringAttributeIntervalDecorator object) {
			return createStringAttributeIntervalDecoratorAdapter();
		}

		@Override
		public Adapter caseStringAttributeTextDecorator(StringAttributeTextDecorator object) {
			return createStringAttributeTextDecoratorAdapter();
		}

		@Override
		public Adapter caseStringZoomDecorator(StringZoomDecorator object) {
			return createStringZoomDecoratorAdapter();
		}

		@Override
		public Adapter caseZoomVerhaltenAttributeIntervalDecorator(ZoomVerhaltenAttributeIntervalDecorator object) {
			return createZoomVerhaltenAttributeIntervalDecoratorAdapter();
		}

		@Override
		public Adapter caseZoomVerhaltenAttributeTextDecorator(ZoomVerhaltenAttributeTextDecorator object) {
			return createZoomVerhaltenAttributeTextDecoratorAdapter();
		}

		@Override
		public Adapter caseZoomVerhaltenZoomDecorator(ZoomVerhaltenZoomDecorator object) {
			return createZoomVerhaltenZoomDecoratorAdapter();
		}

		@Override
		public Adapter caseEmbeddedDoForm(EmbeddedDoForm object) {
			return createEmbeddedDoFormAdapter();
		}

		@Override
		public Adapter caseExternalDoForm(ExternalDoForm object) {
			return createExternalDoFormAdapter();
		}

		@Override
		public Adapter caseDoEditorDiagramm(DoEditorDiagramm object) {
			return createDoEditorDiagrammAdapter();
		}

		@Override
		public Adapter caseEditorDoTyp(EditorDoTyp object) {
			return createEditorDoTypAdapter();
		}

		@Override
		public Adapter caseEditorDoTypReferenz(EditorDoTypReferenz object) {
			return createEditorDoTypReferenzAdapter();
		}

		@Override
		public Adapter caseBorderWidthParameterDefinition(BorderWidthParameterDefinition object) {
			return createBorderWidthParameterDefinitionAdapter();
		}

		@Override
		public Adapter caseBorderColorAttributeTextDecorator(BorderColorAttributeTextDecorator object) {
			return createBorderColorAttributeTextDecoratorAdapter();
		}

		@Override
		public Adapter caseBorderColorAttributeIntervalDecorator(BorderColorAttributeIntervalDecorator object) {
			return createBorderColorAttributeIntervalDecoratorAdapter();
		}

		@Override
		public Adapter caseBorderColorZoomDecorator(BorderColorZoomDecorator object) {
			return createBorderColorZoomDecoratorAdapter();
		}

		@Override
		public Adapter caseBorderWidthAttributeTextDecorator(BorderWidthAttributeTextDecorator object) {
			return createBorderWidthAttributeTextDecoratorAdapter();
		}

		@Override
		public Adapter caseBorderWidthAttributeIntervalDecorator(BorderWidthAttributeIntervalDecorator object) {
			return createBorderWidthAttributeIntervalDecoratorAdapter();
		}

		@Override
		public Adapter caseBorderWidthZoomDecorator(BorderWidthZoomDecorator object) {
			return createBorderWidthZoomDecoratorAdapter();
		}

		@Override
		public Adapter caseIdentidy(Identidy object) {
			return createIdentidyAdapter();
		}

		@Override
		public Adapter caseNamed(Named object) {
			return createNamedAdapter();
		}

		@Override
		public Adapter caseLocated(Located object) {
			return createLocatedAdapter();
		}

		@Override
		public Adapter caseSized(Sized object) {
			return createSizedAdapter();
		}

		@Override
		public Adapter caseDoKomponente(DoKomponente object) {
			return createDoKomponenteAdapter();
		}

		@Override
		public Adapter caseDoModel(DoModel object) {
			return createDoModelAdapter();
		}

		@Override
		public <T extends DoKomponente> Adapter caseDoKompositum(DoKompositum<T> object) {
			return createDoKompositumAdapter();
		}

		@Override
		public Adapter caseSkalierungDecorator(SkalierungDecorator object) {
			return createSkalierungDecoratorAdapter();
		}

		@Override
		public Adapter caseDrehungDecorator(DrehungDecorator object) {
			return createDrehungDecoratorAdapter();
		}

		@Override
		public Adapter caseDoTyp(DoTyp object) {
			return createDoTypAdapter();
		}

		@Override
		public Adapter defaultCase(EObject object) {
			return createEObjectAdapter();
		}
	};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject) target);
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.VisibleForm <em>Visible Form</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.VisibleForm
	 * @generated
	 */
	public Adapter createVisibleFormAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.RotatableForm <em>Rotatable Form</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.RotatableForm
	 * @generated
	 */
	public Adapter createRotatableFormAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.BorderedForm <em>Bordered Form</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderedForm
	 * @generated
	 */
	public Adapter createBorderedFormAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.ZoomableForm <em>Zoomable Form</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomableForm
	 * @generated
	 */
	public Adapter createZoomableFormAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.PunktForm <em>Punkt Form</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so
	 * that we can easily ignore cases; it's useful to ignore a case when
	 * inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.PunktForm
	 * @generated
	 */
	public Adapter createPunktFormAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.BildForm <em>Bild Form</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BildForm
	 * @generated
	 */
	public Adapter createBildFormAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.TextForm <em>Text Form</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.TextForm
	 * @generated
	 */
	public Adapter createTextFormAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.PolylineForm <em>Polyline Form</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.PolylineForm
	 * @generated
	 */
	public Adapter createPolylineFormAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.PolygonForm <em>Polygon Form</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.PolygonForm
	 * @generated
	 */
	public Adapter createPolygonFormAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.FlaechenForm <em>Flaechen Form</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.FlaechenForm
	 * @generated
	 */
	public Adapter createFlaechenFormAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.EllipseForm <em>Ellipse Form</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EllipseForm
	 * @generated
	 */
	public Adapter createEllipseFormAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.RechteckForm <em>Rechteck Form</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.RechteckForm
	 * @generated
	 */
	public Adapter createRechteckFormAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.LinienForm <em>Linien Form</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.LinienForm
	 * @generated
	 */
	public Adapter createLinienFormAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.Decorator <em>Decorator</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.Decorator
	 * @generated
	 */
	public Adapter createDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.TextDecorator <em>Text Decorator</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.TextDecorator
	 * @generated
	 */
	public Adapter createTextDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.AttributeDecorator <em>Attribute Decorator</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.AttributeDecorator
	 * @generated
	 */
	public Adapter createAttributeDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.IntervalDecorator <em>Interval Decorator</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.IntervalDecorator
	 * @generated
	 */
	public Adapter createIntervalDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.ZoomDecorator <em>Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomDecorator
	 * @generated
	 */
	public Adapter createZoomDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoModel <em>Editor Do Model</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EditorDoModel
	 * @generated
	 */
	public Adapter createEditorDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.AttributeTextDecorator <em>Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.AttributeTextDecorator
	 * @generated
	 */
	public Adapter createAttributeTextDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.AttributeIntervalDecorator <em>Attribute Interval Decorator</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.AttributeIntervalDecorator
	 * @generated
	 */
	public Adapter createAttributeIntervalDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.BackgroundAttributeIntervalDecorator <em>Background Attribute Interval Decorator</em>}'.
	 * <!-- begin-user-doc
	 * --> This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BackgroundAttributeIntervalDecorator
	 * @generated
	 */
	public Adapter createBackgroundAttributeIntervalDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition <em>Parameter Definition</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition
	 * @generated
	 */
	public Adapter createParameterDefinitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.ColorParameterDefinition <em>Color Parameter Definition</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ColorParameterDefinition
	 * @generated
	 */
	public Adapter createColorParameterDefinitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.BackgroundParameterDefinition <em>Background Parameter Definition</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BackgroundParameterDefinition
	 * @generated
	 */
	public Adapter createBackgroundParameterDefinitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.ForegroundParameterDefinition <em>Foreground Parameter Definition</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ForegroundParameterDefinition
	 * @generated
	 */
	public Adapter createForegroundParameterDefinitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.BorderColorParameterDefinition <em>Border Color Parameter Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderColorParameterDefinition
	 * @generated
	 */
	public Adapter createBorderColorParameterDefinitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.FontDataParameterDefinition <em>Font Data Parameter Definition</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.FontDataParameterDefinition
	 * @generated
	 */
	public Adapter createFontDataParameterDefinitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.DrehwinkelParameterDefinition <em>Drehwinkel Parameter Definition</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.DrehwinkelParameterDefinition
	 * @generated
	 */
	public Adapter createDrehwinkelParameterDefinitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.LineAttributeParameterDefinition <em>Line Attribute Parameter Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.LineAttributeParameterDefinition
	 * @generated
	 */
	public Adapter createLineAttributeParameterDefinitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.StringParameterDefinition <em>String Parameter Definition</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.StringParameterDefinition
	 * @generated
	 */
	public Adapter createStringParameterDefinitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitParameterDefinition <em>Sichtbarkeit Parameter Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitParameterDefinition
	 * @generated
	 */
	public Adapter createSichtbarkeitParameterDefinitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenParameterDefinition <em>Zoom Verhalten Parameter Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenParameterDefinition
	 * @generated
	 */
	public Adapter createZoomVerhaltenParameterDefinitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.BackgroundAttributeTextDecorator <em>Background Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BackgroundAttributeTextDecorator
	 * @generated
	 */
	public Adapter createBackgroundAttributeTextDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.BackgroundZoomDecorator <em>Background Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BackgroundZoomDecorator
	 * @generated
	 */
	public Adapter createBackgroundZoomDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.DrehwinkelAttributeTextDecorator <em>Drehwinkel Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.DrehwinkelAttributeTextDecorator
	 * @generated
	 */
	public Adapter createDrehwinkelAttributeTextDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.DrehwinkelAttributeIntervalDecorator <em>Drehwinkel Attribute Interval Decorator</em>}'.
	 * <!-- begin-user-doc
	 * --> This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.DrehwinkelAttributeIntervalDecorator
	 * @generated
	 */
	public Adapter createDrehwinkelAttributeIntervalDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.DrehwinkelZoomDecorator <em>Drehwinkel Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.DrehwinkelZoomDecorator
	 * @generated
	 */
	public Adapter createDrehwinkelZoomDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.FontDataAttributeIntervalDecorator <em>Font Data Attribute Interval Decorator</em>}'.
	 * <!-- begin-user-doc
	 * --> This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.FontDataAttributeIntervalDecorator
	 * @generated
	 */
	public Adapter createFontDataAttributeIntervalDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.FontDataAttributeTextDecorator <em>Font Data Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.FontDataAttributeTextDecorator
	 * @generated
	 */
	public Adapter createFontDataAttributeTextDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.FontDataZoomDecorator <em>Font Data Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.FontDataZoomDecorator
	 * @generated
	 */
	public Adapter createFontDataZoomDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.ForegroundAttributeTextDecorator <em>Foreground Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ForegroundAttributeTextDecorator
	 * @generated
	 */
	public Adapter createForegroundAttributeTextDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.ForegroundAttributeIntervalDecorator <em>Foreground Attribute Interval Decorator</em>}'.
	 * <!-- begin-user-doc
	 * --> This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ForegroundAttributeIntervalDecorator
	 * @generated
	 */
	public Adapter createForegroundAttributeIntervalDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.ForegroundZoomDecorator <em>Foreground Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ForegroundZoomDecorator
	 * @generated
	 */
	public Adapter createForegroundZoomDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.LineAttributeAttributeIntervalDecorator
	 * <em>Line Attribute Attribute Interval Decorator</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.LineAttributeAttributeIntervalDecorator
	 * @generated
	 */
	public Adapter createLineAttributeAttributeIntervalDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.LineAttributeAttributeTextDecorator <em>Line Attribute Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc
	 * --> This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.LineAttributeAttributeTextDecorator
	 * @generated
	 */
	public Adapter createLineAttributeAttributeTextDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.LineAttributeZoomDecorator <em>Line Attribute Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.LineAttributeZoomDecorator
	 * @generated
	 */
	public Adapter createLineAttributeZoomDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitAttributeTextDecorator <em>Sichtbarkeit Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitAttributeTextDecorator
	 * @generated
	 */
	public Adapter createSichtbarkeitAttributeTextDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitAttributeIntervalDecorator <em>Sichtbarkeit Attribute Interval Decorator</em>}'.
	 * <!-- begin-user-doc
	 * --> This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitAttributeIntervalDecorator
	 * @generated
	 */
	public Adapter createSichtbarkeitAttributeIntervalDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitZoomDecorator <em>Sichtbarkeit Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitZoomDecorator
	 * @generated
	 */
	public Adapter createSichtbarkeitZoomDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.StringAttributeIntervalDecorator <em>String Attribute Interval Decorator</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.StringAttributeIntervalDecorator
	 * @generated
	 */
	public Adapter createStringAttributeIntervalDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.StringAttributeTextDecorator <em>String Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.StringAttributeTextDecorator
	 * @generated
	 */
	public Adapter createStringAttributeTextDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.StringZoomDecorator <em>String Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.StringZoomDecorator
	 * @generated
	 */
	public Adapter createStringZoomDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenAttributeIntervalDecorator
	 * <em>Zoom Verhalten Attribute Interval Decorator</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenAttributeIntervalDecorator
	 * @generated
	 */
	public Adapter createZoomVerhaltenAttributeIntervalDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenAttributeTextDecorator <em>Zoom Verhalten Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc
	 * --> This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenAttributeTextDecorator
	 * @generated
	 */
	public Adapter createZoomVerhaltenAttributeTextDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenZoomDecorator <em>Zoom Verhalten Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenZoomDecorator
	 * @generated
	 */
	public Adapter createZoomVerhaltenZoomDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.EmbeddedDoForm <em>Embedded Do Form</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EmbeddedDoForm
	 * @generated
	 */
	public Adapter createEmbeddedDoFormAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.ExternalDoForm <em>External Do Form</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ExternalDoForm
	 * @generated
	 */
	public Adapter createExternalDoFormAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.DoEditorDiagramm <em>Do Editor Diagramm</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.DoEditorDiagramm
	 * @generated
	 */
	public Adapter createDoEditorDiagrammAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp <em>Editor Do Typ</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp
	 * @generated
	 */
	public Adapter createEditorDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTypReferenz
	 * <em>Editor Do Typ Referenz</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EditorDoTypReferenz
	 * @generated NOT
	 */
	public Adapter createEditorDoTypReferenzAdapter() {
		return new EditorDoTypReferenzAdapter();
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.BorderWidthParameterDefinition <em>Border Width Parameter Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderWidthParameterDefinition
	 * @generated
	 */
	public Adapter createBorderWidthParameterDefinitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.BorderColorAttributeTextDecorator <em>Border Color Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderColorAttributeTextDecorator
	 * @generated
	 */
	public Adapter createBorderColorAttributeTextDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.BorderColorAttributeIntervalDecorator <em>Border Color Attribute Interval Decorator</em>}'.
	 * <!-- begin-user-doc
	 * --> This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderColorAttributeIntervalDecorator
	 * @generated
	 */
	public Adapter createBorderColorAttributeIntervalDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.BorderColorZoomDecorator <em>Border Color Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderColorZoomDecorator
	 * @generated
	 */
	public Adapter createBorderColorZoomDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.BorderWidthAttributeTextDecorator <em>Border Width Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderWidthAttributeTextDecorator
	 * @generated
	 */
	public Adapter createBorderWidthAttributeTextDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.BorderWidthAttributeIntervalDecorator <em>Border Width Attribute Interval Decorator</em>}'.
	 * <!-- begin-user-doc
	 * --> This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderWidthAttributeIntervalDecorator
	 * @generated
	 */
	public Adapter createBorderWidthAttributeIntervalDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.BorderWidthZoomDecorator <em>Border Width Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderWidthZoomDecorator
	 * @generated
	 */
	public Adapter createBorderWidthZoomDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.doeditor.model.Identidy <em>Identidy</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.doeditor.model.Identidy
	 * @generated
	 */
	public Adapter createIdentidyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.bitctrl.lib.eclipse.emf.eclipse.model.Named <em>Named</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.bitctrl.lib.eclipse.emf.eclipse.model.Named
	 * @generated
	 */
	public Adapter createNamedAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.bitctrl.lib.eclipse.emf.gef.model.Located <em>Located</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.bitctrl.lib.eclipse.emf.gef.model.Located
	 * @generated
	 */
	public Adapter createLocatedAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link com.bitctrl.lib.eclipse.emf.gef.model.Sized <em>Sized</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see com.bitctrl.lib.eclipse.emf.gef.model.Sized
	 * @generated
	 */
	public Adapter createSizedAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.dobj.model.DoKomponente <em>Do Komponente</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoKomponente
	 * @generated
	 */
	public Adapter createDoKomponenteAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.dobj.model.DoModel <em>Do Model</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoModel
	 * @generated
	 */
	public Adapter createDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.dobj.model.DoKompositum <em>Do Kompositum</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoKompositum
	 * @generated
	 */
	public Adapter createDoKompositumAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator <em>Skalierung Decorator</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator
	 * @generated
	 */
	public Adapter createSkalierungDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator <em>Drehung Decorator</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator
	 * @generated
	 */
	public Adapter createDrehungDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.dobj.model.DoTyp <em>Do Typ</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoTyp
	 * @generated
	 */
	public Adapter createDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} // DoeditorAdapterFactory
